/*
 * Decompiled with CFR 0.152.
 */
package oddities.items.weapons.magic;

import necesse.engine.localization.Localization;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.projectile.Projectile;
import necesse.gfx.GameResources;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.ItemInteractAction;
import necesse.inventory.item.toolItem.projectileToolItem.magicProjectileToolItem.MagicProjectileToolItem;
import necesse.inventory.lootTable.LootItemInterface;
import necesse.inventory.lootTable.lootItem.OneOfLootItems;
import necesse.level.maps.Level;
import oddities.projectiles.IceShardProjectile;

public class IceShardsWeapon
extends MagicProjectileToolItem
implements ItemInteractAction {
    public IceShardsWeapon() {
        super(400, new OneOfLootItems(new LootItemInterface[0]));
        this.rarity = Item.Rarity.EPIC;
        this.attackAnimTime.setBaseValue(150);
        this.attackDamage.setBaseValue(20.0f).setUpgradedValue(1.0f, 30.0f);
        this.velocity.setBaseValue(100);
        this.knockback.setBaseValue(20);
        this.attackRange.setBaseValue(1000);
        this.manaCost.setBaseValue(2.5f).setUpgradedValue(5.0f, 2.0f);
        this.attackXOffset = 12;
        this.attackYOffset = 22;
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getPreEnchantmentTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"iceshardweapontip"));
        return tooltips;
    }

    public void showAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, int animAttack, int seed, GNDItemMap mapContent) {
        if (level.isClient()) {
            SoundManager.playSound((GameSound)GameResources.magicbolt4, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(0.7f).pitch(GameRandom.globalRandom.getFloatBetween(1.0f, 1.1f)));
        }
    }

    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        PlayerMob player;
        if (attackerMob instanceof PlayerMob && (player = (PlayerMob)attackerMob).getMana() >= this.getManaCost(item)) {
            IceShardProjectile projectile = new IceShardProjectile(level, (Mob)player, player.x, player.y, x, y, this.getProjectileVelocity(item, (Mob)player), this.getAttackRange(item), this.getAttackDamage(item), this.getKnockback(item, (Attacker)player));
            GameRandom random = new GameRandom((long)seed);
            projectile.setAngle(projectile.getAngle() + (random.nextSeeded(27).nextFloat() - 0.5f) * 10.0f);
            projectile.resetUniqueID(random);
            projectile.moveDist(40.0);
            attackerMob.addAndSendAttackerProjectile((Projectile)projectile, 20, 0.0f);
            this.consumeMana((ItemAttackerMob)player, item);
        }
        return item;
    }

    public boolean canLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item) {
        return attackerMob.getMana() >= this.getManaCost(item) * 10.0f;
    }

    public InventoryItem onLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int seed, GNDItemMap mapContent) {
        if (attackerMob.isPlayer) {
            GameRandom random = new GameRandom((long)seed);
            GameRandom spreadRandom = random.nextSeeded(27);
            for (int i = 0; i < 10; ++i) {
                IceShardProjectile projectile = new IceShardProjectile(level, (Mob)attackerMob, attackerMob.x, attackerMob.y, x, y, this.getProjectileVelocity(item, (Mob)attackerMob), this.getAttackRange(item), this.getAttackDamage(item), this.getKnockback(item, (Attacker)attackerMob));
                projectile.setAngle(projectile.getAngle() + (spreadRandom.nextFloat() - 0.5f) * 10.0f);
                projectile.resetUniqueID(random);
                projectile.moveDist(40.0);
                attackerMob.addAndSendAttackerProjectile((Projectile)projectile, 20, 0.0f);
            }
            this.consumeMana(this.getManaCost(item) * 10.0f, attackerMob);
        }
        return item;
    }

    public int getLevelInteractAttackAnimTime(InventoryItem item, ItemAttackerMob attackerMob) {
        return 600;
    }
}

