/*
 * Decompiled with CFR 0.152.
 */
package oddities.items.weapons.magic;

import necesse.engine.localization.Localization;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.projectile.Projectile;
import necesse.gfx.GameResources;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.toolItem.projectileToolItem.magicProjectileToolItem.MagicProjectileToolItem;
import necesse.inventory.lootTable.LootItemInterface;
import necesse.inventory.lootTable.lootItem.OneOfLootItems;
import necesse.level.maps.Level;
import oddities.projectiles.GlacialProjectile;
import oddities.projectiles.InfernoProjectile;
import oddities.projectiles.VenomProjectile;

public class ChromaticSprayWeapon
extends MagicProjectileToolItem {
    public ChromaticSprayWeapon() {
        super(5000, new OneOfLootItems(new LootItemInterface[0]));
        this.rarity = Item.Rarity.LEGENDARY;
        this.attackAnimTime.setBaseValue(150);
        this.attackDamage.setBaseValue(15.0f).setUpgradedValue(1.0f, 20.0f);
        this.velocity.setBaseValue(80);
        this.knockback.setBaseValue(0);
        this.attackRange.setBaseValue(1500);
        this.manaCost.setBaseValue(15.0f).setUpgradedValue(5.0f, 12.0f);
        this.attackXOffset = 12;
        this.attackYOffset = 22;
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getPreEnchantmentTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"chromaticspraytip"));
        return tooltips;
    }

    public void showAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, int animAttack, int seed, GNDItemMap mapContent) {
        if (level.isClient()) {
            SoundManager.playSound((GameSound)GameResources.magicbolt2, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(0.7f).pitch(GameRandom.globalRandom.getFloatBetween(1.0f, 1.1f)));
        }
    }

    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        if (attackerMob.getMana() >= this.getManaCost(item)) {
            GameRandom random = new GameRandom((long)seed);
            GameRandom spreadRandom = random.nextSeeded(27);
            InfernoProjectile infernoProjectile = new InfernoProjectile(level, (Mob)attackerMob, attackerMob.x, attackerMob.y, x, y, this.getProjectileVelocity(item, (Mob)attackerMob), this.getAttackRange(item), this.getAttackDamage(item), this.getKnockback(item, (Attacker)attackerMob));
            infernoProjectile.setAngle(infernoProjectile.getAngle() + (spreadRandom.nextFloat() - 0.5f) * 25.0f);
            infernoProjectile.resetUniqueID(random);
            infernoProjectile.moveDist(30.0);
            VenomProjectile venomProjectile = new VenomProjectile(level, (Mob)attackerMob, attackerMob.x, attackerMob.y, x, y, this.getProjectileVelocity(item, (Mob)attackerMob), this.getAttackRange(item), this.getAttackDamage(item), this.getKnockback(item, (Attacker)attackerMob));
            venomProjectile.setAngle(venomProjectile.getAngle() + (spreadRandom.nextFloat() - 0.5f) * 25.0f);
            venomProjectile.resetUniqueID(random);
            venomProjectile.moveDist(30.0);
            GlacialProjectile glacialProjectile = new GlacialProjectile(level, (Mob)attackerMob, attackerMob.x, attackerMob.y, x, y, this.getProjectileVelocity(item, (Mob)attackerMob), this.getAttackRange(item), this.getAttackDamage(item), this.getKnockback(item, (Attacker)attackerMob));
            glacialProjectile.setAngle(glacialProjectile.getAngle() + (spreadRandom.nextFloat() - 0.5f) * 25.0f);
            glacialProjectile.resetUniqueID(random);
            glacialProjectile.moveDist(30.0);
            attackerMob.addAndSendAttackerProjectile((Projectile)infernoProjectile, 20);
            attackerMob.addAndSendAttackerProjectile((Projectile)venomProjectile, 20);
            attackerMob.addAndSendAttackerProjectile((Projectile)glacialProjectile, 20);
            this.consumeMana(attackerMob, item);
        }
        return item;
    }
}

