/*
 * Decompiled with CFR 0.152.
 */
package oddities.examples;

import java.awt.Color;
import java.awt.Point;
import necesse.engine.util.GameRandom;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.gameTexture.GameTextureSection;
import necesse.level.gameTile.TerrainSplatterTile;
import necesse.level.maps.Level;

public class ExampleTile
extends TerrainSplatterTile {
    private GameTexture texture;
    private final GameRandom drawRandom;

    public ExampleTile() {
        super(false, "exampletile");
        this.canBeMined = true;
        this.drawRandom = new GameRandom();
        this.roomProperties.add("outsidefloor");
        this.mapColor = new Color(200, 50, 200);
    }

    protected void loadTextures() {
        super.loadTextures();
        this.texture = GameTexture.fromFile((String)"tiles/exampletile");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getTerrainSprite(GameTextureSection gameTextureSection, Level level, int tileX, int tileY) {
        int tile;
        GameRandom gameRandom = this.drawRandom;
        synchronized (gameRandom) {
            tile = this.drawRandom.seeded(ExampleTile.getTileSeed((int)tileX, (int)tileY)).nextInt(this.texture.getHeight() / 32);
        }
        return new Point(0, tile);
    }

    public int getTerrainPriority() {
        return 100;
    }
}

