/*
 * Decompiled with CFR 0.152.
 */
package oddities.buffs;

import java.awt.Color;
import java.util.concurrent.atomic.AtomicReference;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.DeathMessageTable;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import necesse.entity.particle.Particle;

public class VenomBuff
extends Buff {
    public VenomBuff() {
        this.canCancel = false;
        this.isImportant = true;
    }

    public void init(ActiveBuff buff, BuffEventSubscriber eventSubscriber) {
        buff.setModifier(BuffModifiers.POISON_DAMAGE_FLAT, (Object)Float.valueOf(250.0f));
    }

    public void clientTick(ActiveBuff buff) {
        if (buff.owner.isVisible()) {
            Mob owner = buff.owner;
            owner.getLevel().entityManager.addParticle(owner.x + (float)(GameRandom.globalRandom.nextGaussian() * 6.0), owner.y + (float)(GameRandom.globalRandom.nextGaussian() * 8.0), Particle.GType.IMPORTANT_COSMETIC).movesConstant(owner.dx / 10.0f, owner.dy / 10.0f).flameColor().givesLight(0.0f, 0.5f).height(16.0f);
            AtomicReference<Float> currentAngle = new AtomicReference<Float>(Float.valueOf(GameRandom.globalRandom.nextFloat() * 360.0f));
            float distance = 5.0f;
            owner.getLevel().entityManager.addParticle(owner.x + GameMath.sin((float)currentAngle.get().floatValue()) * distance, owner.y + GameMath.cos((float)currentAngle.get().floatValue()) * distance * 0.75f, Particle.GType.CRITICAL).color(new Color(28, 158, 0)).height(0.0f).moves((pos, delta, lifeTime, timeAlive, lifePercent) -> {
                float angle = currentAngle.accumulateAndGet(Float.valueOf(delta * 150.0f / 250.0f), Float::sum).floatValue();
                float distY = distance * 0.75f;
                pos.x = owner.x + GameMath.sin((float)angle) * distance;
                pos.y = owner.y + GameMath.cos((float)angle) * distY * 0.75f;
            }).lifeTime(1000).sizeFades(16, 24);
        }
    }

    public Attacker getSource(Attacker source) {
        return new VenomAttacker(source);
    }

    public static class VenomAttacker
    implements Attacker {
        Attacker owner;

        public VenomAttacker(Attacker owner) {
            this.owner = owner;
        }

        public GameMessage getAttackerName() {
            return this.owner != null ? this.owner.getAttackerName() : new LocalMessage("deaths", "firename");
        }

        public DeathMessageTable getDeathMessages() {
            return this.getDeathMessages("fire", 3);
        }

        public Mob getFirstAttackOwner() {
            return this.owner != null ? this.owner.getAttackOwner() : null;
        }

        public boolean isTrapAttacker() {
            return this.owner != null ? this.owner.isTrapAttacker() : super.isTrapAttacker();
        }
    }
}

