/*
 * Decompiled with CFR 0.152.
 */
package oddities.buffs;

import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobWasHitEvent;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.staticBuffs.armorBuffs.trinketBuffs.TrinketBuff;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.trinketItem.TrinketItem;

public class RazorPlateBuff
extends TrinketBuff {
    public void init(ActiveBuff activeBuff, BuffEventSubscriber buffEventSubscriber) {
    }

    public void onWasHit(ActiveBuff buff, MobWasHitEvent event) {
        super.onWasHit(buff, event);
        if (!event.wasPrevented && buff.owner.isServer()) {
            boolean hasOwnerInChain;
            Mob attackOwner = event.attacker != null ? event.attacker.getAttackOwner() : null;
            boolean bl = hasOwnerInChain = event.attacker != null && event.attacker.isInAttackOwnerChain(buff.owner);
            if (attackOwner != null && !hasOwnerInChain) {
                float dx = attackOwner.getX() - buff.owner.getX();
                float dy = attackOwner.getY() - buff.owner.getY();
                float damage = buff.owner.getArmor();
                if (attackOwner.isPlayer) {
                    damage /= 2.0f;
                }
                attackOwner.isServerHit(new GameDamage(event.isCrit ? damage / 2.0f : damage, 0.0f), dx, dy, 50.0f, (Attacker)buff.owner);
            }
        }
    }

    public ListGameTooltips getTrinketTooltip(TrinketItem trinketItem, InventoryItem item, PlayerMob perspective) {
        return super.getTrinketTooltip(trinketItem, item, perspective);
    }
}

