/*
 * Decompiled with CFR 0.152.
 */
package oddities.buffs;

import necesse.engine.input.Control;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.registries.BuffRegistry;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.ActiveBuffAbility;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import necesse.entity.mobs.buffs.staticBuffs.StaminaBuff;
import necesse.gfx.camera.GameCamera;

public class HermesBuff
extends Buff
implements ActiveBuffAbility {
    public HermesBuff() {
        this.canCancel = false;
        this.isImportant = true;
    }

    public void init(ActiveBuff buff, BuffEventSubscriber eventSubscriber) {
        buff.setModifier(BuffModifiers.FROST_DAMAGE_FLAT, (Object)Float.valueOf(50.0f));
        buff.setModifier(BuffModifiers.SLOW, (Object)Float.valueOf(0.8f));
        buff.setModifier(BuffModifiers.SPEED_FLAT, (Object)Float.valueOf(5.0f));
    }

    public Packet getStartAbilityContent(PlayerMob player, ActiveBuff buff, GameCamera camera) {
        return this.getRunningAbilityContent(player, buff);
    }

    public Packet getRunningAbilityContent(PlayerMob player, ActiveBuff buff) {
        Packet content = new Packet();
        PacketWriter writer = new PacketWriter(content);
        StaminaBuff.writeStaminaData((Mob)player, (PacketWriter)writer);
        return content;
    }

    public boolean canRunAbility(PlayerMob player, ActiveBuff buff, Packet content) {
        if (buff.owner.isRiding()) {
            return false;
        }
        return player.isServer() || StaminaBuff.canStartStaminaUsage((Mob)buff.owner);
    }

    public void onActiveAbilityStarted(PlayerMob player, ActiveBuff buff, Packet content) {
        PacketReader reader = new PacketReader(content);
        if (!player.isServer()) {
            StaminaBuff.readStaminaData((Mob)player, (PacketReader)reader);
        }
        if (!buff.owner.inLiquid()) {
            player.buffManager.addBuff(new ActiveBuff(BuffRegistry.ZEPHYR_BOOTS_ACTIVE, (Mob)player, 1.0f, (Attacker)null), false);
        }
    }

    public boolean tickActiveAbility(PlayerMob player, ActiveBuff buff, boolean isRunningClient) {
        if (player.inLiquid()) {
            player.buffManager.removeBuff(BuffRegistry.ZEPHYR_BOOTS_ACTIVE, false);
        } else {
            long msToDeplete;
            float usage;
            ActiveBuff speedBuff = player.buffManager.getBuff(BuffRegistry.ZEPHYR_BOOTS_ACTIVE);
            if (speedBuff != null) {
                speedBuff.setDurationLeftSeconds(1.0f);
            } else {
                player.buffManager.addBuff(new ActiveBuff(BuffRegistry.ZEPHYR_BOOTS_ACTIVE, (Mob)player, 1.0f, (Attacker)null), false);
            }
            if (!(player.moveX == 0.0f && player.moveY == 0.0f || player.dx == 0.0f && player.dy == 0.0f || StaminaBuff.useStaminaAndGetValid((Mob)player, (float)(usage = 50.0f / (float)(msToDeplete = 4000L))))) {
                return false;
            }
        }
        return !isRunningClient || Control.TRINKET_ABILITY.isDown();
    }

    public void onActiveAbilityUpdate(PlayerMob player, ActiveBuff buff, Packet content) {
    }

    public void onActiveAbilityStopped(PlayerMob player, ActiveBuff buff) {
        player.buffManager.removeBuff(BuffRegistry.ZEPHYR_BOOTS_ACTIVE, false);
    }
}

