/*
 * Decompiled with CFR 0.152.
 */
package oddities.buffs;

import java.awt.Color;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.DeathMessageTable;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import necesse.entity.particle.Particle;

public class GlacialBuff
extends Buff {
    public GlacialBuff() {
        this.canCancel = false;
        this.isImportant = true;
    }

    public void init(ActiveBuff buff, BuffEventSubscriber eventSubscriber) {
        buff.setModifier(BuffModifiers.FROST_DAMAGE_FLAT, (Object)Float.valueOf(50.0f));
        buff.setModifier(BuffModifiers.SLOW, (Object)Float.valueOf(0.8f));
    }

    public void clientTick(ActiveBuff buff) {
        super.clientTick(buff);
        if (buff.owner.isVisible()) {
            Mob owner = buff.owner;
            owner.getLevel().entityManager.addParticle(owner.x + (float)(GameRandom.globalRandom.nextGaussian() * 6.0), owner.y + (float)(GameRandom.globalRandom.nextGaussian() * 8.0), Particle.GType.IMPORTANT_COSMETIC).movesConstant(owner.dx / 10.0f, owner.dy / 10.0f).color(new Color(46, 197, 255)).givesLight(200.0f, 0.5f).height(16.0f);
        }
    }

    public Attacker getSource(Attacker source) {
        return new InfernoAttacker(source);
    }

    public static class InfernoAttacker
    implements Attacker {
        Attacker owner;

        public InfernoAttacker(Attacker owner) {
            this.owner = owner;
        }

        public GameMessage getAttackerName() {
            return this.owner != null ? this.owner.getAttackerName() : new LocalMessage("deaths", "firename");
        }

        public DeathMessageTable getDeathMessages() {
            return this.getDeathMessages("fire", 3);
        }

        public Mob getFirstAttackOwner() {
            return this.owner != null ? this.owner.getAttackOwner() : null;
        }

        public boolean isTrapAttacker() {
            return this.owner != null ? this.owner.isTrapAttacker() : super.isTrapAttacker();
        }
    }
}

