/*
 * Decompiled with CFR 0.152.
 */
package oddities;

import java.util.Objects;
import java.util.Random;
import necesse.engine.GameEventInterface;
import necesse.engine.GameEventListener;
import necesse.engine.GameEvents;
import necesse.engine.commands.ChatCommand;
import necesse.engine.commands.CommandsManager;
import necesse.engine.events.loot.MobLootTableDropsEvent;
import necesse.engine.modLoader.annotations.ModEntry;
import necesse.engine.registries.PacketRegistry;
import necesse.engine.util.GameRandom;
import necesse.inventory.InventoryItem;
import oddities.examples.ExampleChatCommand;
import oddities.examples.ExamplePacket;
import oddities.registry.ModBuffs;
import oddities.registry.ModContainers;
import oddities.registry.ModItems;
import oddities.registry.ModMats;
import oddities.registry.ModObjects;
import oddities.registry.ModProjectiles;
import oddities.registry.ModRecipeTechs;
import oddities.registry.ModRecipes;
import oddities.registry.ModTiles;

@ModEntry
public class Main {
    public void init() {
        this.RegisterEverything();
        PacketRegistry.registerPacket(ExamplePacket.class);
    }

    private void RegisterEverything() {
        new ModTiles();
        new ModObjects();
        new ModItems();
        new ModProjectiles();
        new ModBuffs();
        new ModRecipeTechs();
        new ModContainers();
        new ModMats();
    }

    public void initResources() {
    }

    public void postInit() {
        GameEvents.addListener(MobLootTableDropsEvent.class, (GameEventInterface)new GameEventListener<MobLootTableDropsEvent>(){

            public void onEvent(MobLootTableDropsEvent event) {
                if (event.mob.isBoss()) {
                    event.drops.add(new InventoryItem("tatteredscroll", GameRandom.getIntBetween((Random)new Random(), (int)2, (int)5)));
                }
                Main.this.MobDropChance(event, "fallenwizard", 100, "trinkettable", 1);
                Main.this.MobDropChance(event, "sunlightchampion", 20, "razorplatetrinket", 1);
                Main.this.MobDropChance(event, "moonlightdancer", 10, "chromaticsprayweapon", 1);
                Main.this.MobDropChance(event, "crystaldragon", 10, "giantslayerweapon", 1);
                Main.this.MobDropChance(event, "spiderempress", 10, "piercingfloodweapon", 1);
                Main.this.MobDropChance(event, "pestwarden", 25, "sturdyplatetrinket", 1);
                Main.this.MobDropChance(event, "sageandgrit", 15, "infernoweapon", 1);
                Main.this.MobDropChance(event, "sageandgrit", 75, "infernoarrow", 250);
            }
        });
        new ModRecipes();
        CommandsManager.registerServerCommand((ChatCommand)new ExampleChatCommand());
    }

    private void MobDropChance(MobLootTableDropsEvent event, String id, int chance, String drop, int amount) {
        if (Objects.equals(event.mob.getStringID(), id) && GameRandom.getIntBetween((Random)new Random(), (int)1, (int)100) <= chance) {
            event.drops.add(new InventoryItem(drop, amount));
        }
    }
}

