/*
 * Decompiled with CFR 0.152.
 */
package ultrastorage.objects;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.stream.Collectors;
import necesse.engine.network.Packet;
import necesse.engine.network.packet.PacketPlaceObject;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.ObjectRegistry;
import necesse.entity.Entity;
import necesse.entity.TileEntity;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.levelEvent.SmokePuffCloudLevelEvent;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.objectEntity.InventoryObjectEntity;
import necesse.entity.objectEntity.interfaces.OEUsers;
import necesse.entity.pickup.ItemPickupEntity;
import necesse.inventory.Inventory;
import necesse.inventory.item.toolItem.ToolType;
import necesse.inventory.recipe.Ingredient;
import necesse.level.gameObject.GameObject;
import necesse.level.gameObject.container.StorageBoxInventoryObject;
import necesse.level.maps.Level;
import necesse.level.maps.LevelObject;
import necesse.level.maps.multiTile.MultiTile;
import ultrastorage.UltraStorage;
import ultrastorage.containers.VaultStorageContainer;

public class VaultObject
extends StorageBoxInventoryObject {
    public String stringId;
    public Ingredient ingredient;
    public int position;

    private VaultObject(String stringId, Color color, Ingredient ingredient, String textureName, int slots, boolean isWood) {
        super(textureName, slots, isWood ? ToolType.ALL : ToolType.PICKAXE, color);
        this.stringId = stringId;
        this.ingredient = ingredient;
    }

    public void interact(Level level, int x, int y, PlayerMob player) {
        if (level.isServer()) {
            VaultStorageContainer.openAndSendContainer(UltraStorage.ULTRA_STORAGE_CONTAINER, player.getServerClient(), level, x, y);
        }
        if (level.isClient() && !(this instanceof OEUsers)) {
            this.playInteractSound(level, (Mob)player, x, y, false, false);
        }
    }

    public VaultObject getNextUltraChest() {
        if (this.position >= 0 && this.position + 1 < UltraStorage.vaultObjectList.size()) {
            return UltraStorage.vaultObjectList.get(this.position + 1);
        }
        return null;
    }

    public static void register(String storageID, Color color, String texture, Ingredient ingredient, int slots, float brokerValue, boolean isWood) {
        VaultObject vaultObject = new VaultObject(storageID, color, ingredient, texture, slots, isWood);
        vaultObject.position = UltraStorage.vaultObjectList.size();
        UltraStorage.vaultObjectList.add(vaultObject);
        ObjectRegistry.registerObject((String)storageID, (GameObject)vaultObject, (float)brokerValue, (boolean)true);
    }

    public static void register(String storageID, Color color, Ingredient ingredient, int slots, float brokerValue, boolean isWood) {
        VaultObject.register(storageID, color, storageID, ingredient, slots, brokerValue, isWood);
    }

    public static void register(String storageID, Color color, Ingredient ingredient, int slots, boolean isWood) {
        VaultObject.register(storageID, color, ingredient, slots, -1.0f, isWood);
    }

    public static void register(String storageID, Color color, Ingredient ingredient, int slots, float brokerValue) {
        VaultObject.register(storageID, color, ingredient, slots, brokerValue, false);
    }

    public static void register(String storageID, Color color, Ingredient ingredient, int slots) {
        VaultObject.register(storageID, color, ingredient, slots, -1.0f);
    }

    public void performUpgrade(VaultObject newVaultObject, Level level, int tileX, int tileY, ServerClient serverClient, Inventory inventory) {
        byte rotation = level.getObjectRotation(tileX, tileY);
        MultiTile multiTile = this.getMultiTile(level, 0, tileX, tileY);
        ArrayList lastObjects = multiTile.streamObjects(tileX, tileY).filter(e -> level.getObjectID(e.tileX, e.tileY) == ((GameObject)e.value).getID()).map(e -> level.getLevelObject(e.tileX, e.tileY)).collect(Collectors.toCollection(ArrayList::new));
        for (LevelObject lastObject : lastObjects) {
            level.setObject(lastObject.tileX, lastObject.tileY, 0);
        }
        newVaultObject.customPlaceObject(level, 0, tileX, tileY, rotation, true, inventory);
        level.getServer().network.sendToClientsWithTile((Packet)new PacketPlaceObject(level, null, 0, tileX, tileY, newVaultObject.getID(), (int)rotation, true), level, tileX, tileY);
        Rectangle levelRectangle = newVaultObject.getMultiTile(rotation).getLevelRectangle(tileX, tileY);
        level.entityManager.addLevelEvent((LevelEvent)new SmokePuffCloudLevelEvent(levelRectangle, newVaultObject.mapColor));
        for (LevelObject lastObject : lastObjects) {
            level.sendObjectUpdatePacket(lastObject.tileX, lastObject.tileY);
        }
    }

    public void customPlaceObject(Level level, int layerID, int x, int y, int rotation, boolean byPlayer, Inventory inventory) {
        level.objectLayer.getObject(layerID, x, y).onPlacedOn(level, layerID, x, y, (GameObject)this);
        level.objectLayer.setObject(layerID, x, y, this.getID());
        level.objectLayer.setObjectRotation(layerID, x, y, (int)((byte)rotation));
        level.objectLayer.setIsPlayerPlaced(layerID, x, y, byPlayer);
        if (layerID == 0 && level.isServer()) {
            InventoryObjectEntity objectEntity = (InventoryObjectEntity)this.getNewObjectEntity(level, x, y);
            if (objectEntity != null) {
                inventory.streamSlots().filter(slot -> slot != null && !slot.isSlotClear()).forEach(slot -> objectEntity.inventory.setItem(slot.slot, slot.getItem()));
                level.entityManager.objectEntities.add((TileEntity)objectEntity);
            } else {
                inventory.streamSlots().filter(slot -> slot != null && !slot.isSlotClear()).forEach(slot -> {
                    ItemPickupEntity itemPickup = new ItemPickupEntity(level, slot.getItem(), (float)(x * 32 + 16), (float)(y * 32 + 16), 0.0f, 0.0f);
                    level.entityManager.pickups.add((Entity)itemPickup);
                });
            }
        }
        MultiTile multiTile = this.getMultiTile(rotation);
        if (multiTile.isMaster) {
            multiTile.streamOtherObjects(x, y).forEach(e -> ((GameObject)e.value).placeObject(level, layerID, e.tileX, e.tileY, rotation, byPlayer));
        }
    }
}

