/*
 * Decompiled with CFR 0.152.
 */
package ultrastorage.containers;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import necesse.engine.Settings;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.input.Control;
import necesse.engine.localization.Localization;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.localization.message.StaticMessage;
import necesse.engine.modLoader.LoadedMod;
import necesse.engine.network.client.Client;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.window.GameWindow;
import necesse.engine.window.WindowManager;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.objectEntity.interfaces.OEInventory;
import necesse.gfx.GameBackground;
import necesse.gfx.GameColor;
import necesse.gfx.fairType.FairType;
import necesse.gfx.fairType.TypeParsers;
import necesse.gfx.fairType.parsers.TypeParser;
import necesse.gfx.forms.ContainerComponent;
import necesse.gfx.forms.Form;
import necesse.gfx.forms.FormSwitcher;
import necesse.gfx.forms.components.FormBreakLine;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormContentBox;
import necesse.gfx.forms.components.FormContentIconButton;
import necesse.gfx.forms.components.FormFairTypeButton;
import necesse.gfx.forms.components.FormFlow;
import necesse.gfx.forms.components.FormInputSize;
import necesse.gfx.forms.components.FormLabelEdit;
import necesse.gfx.forms.components.FormTextInput;
import necesse.gfx.forms.components.containerSlot.FormContainerSlot;
import necesse.gfx.forms.components.localComponents.FormLocalLabel;
import necesse.gfx.forms.presets.containerComponent.ContainerFormSwitcher;
import necesse.gfx.forms.presets.containerComponent.settlement.SettlementObjectStatusFormManager;
import necesse.gfx.gameFont.FontOptions;
import necesse.gfx.gameTooltips.FairTypeTooltip;
import necesse.gfx.gameTooltips.GameTooltipManager;
import necesse.gfx.gameTooltips.GameTooltips;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.gfx.gameTooltips.SpacerGameTooltip;
import necesse.gfx.gameTooltips.StringTooltips;
import necesse.gfx.gameTooltips.TooltipLocation;
import necesse.gfx.ui.ButtonColor;
import necesse.gfx.ui.ButtonTexture;
import necesse.inventory.InventoryItem;
import necesse.inventory.container.Container;
import necesse.inventory.container.slots.ContainerSlot;
import necesse.inventory.item.Item;
import necesse.inventory.item.armorItem.ArmorItem;
import necesse.inventory.item.miscItem.VinylItem;
import necesse.inventory.item.placeableItem.StonePlaceableItem;
import necesse.inventory.item.placeableItem.consumableItem.ConsumableItem;
import necesse.inventory.item.placeableItem.objectItem.ObjectItem;
import necesse.inventory.item.placeableItem.tileItem.TileItem;
import necesse.inventory.recipe.CanCraft;
import necesse.inventory.recipe.Ingredient;
import necesse.inventory.recipe.Recipe;
import necesse.level.maps.Level;
import ultrastorage.UltraStorage;
import ultrastorage.containers.FormContainerVaultSlot;
import ultrastorage.containers.VaultStorageContainer;
import ultrastorage.objects.VaultObject;

public class VaultStorageContainerForm
extends ContainerFormSwitcher<VaultStorageContainer> {
    public static int width = 550;
    public Form inventoryForm = (Form)this.addComponent((FormComponent)new Form(width, 300), (form, active) -> {
        if (!active.booleanValue()) {
            this.label.setTyping(false);
            this.runEditUpdate();
        }
    });
    public SettlementObjectStatusFormManager settlementObjectFormManager;
    public FormLabelEdit label;
    public FormContentIconButton edit;
    public FormContentBox slotsBox;
    public FormContainerSlot[] slots;
    public LocalMessage renameTip;
    public FormLocalLabel labelSlots;
    public FormTextInput searchFilter;
    public FormTextInput searchModFilter;
    public FormFairTypeButton upgradeButton;
    public static SlotsFilterButton[] filterButtons = new SlotsFilterButton[]{new SlotsFilterButton("all", (ButtonTexture)UltraStorage.ALL_ITEMS_FILTER), new SlotsFilterButton("mat", (ButtonTexture)UltraStorage.MAT_ITEMS_FILTER), new SlotsFilterButton("weapon-melee", (ButtonTexture)UltraStorage.MELEE_WEAPONS_FILTER), new SlotsFilterButton("weapon-range", (ButtonTexture)UltraStorage.RANGE_WEAPONS_FILTER), new SlotsFilterButton("weapon-magic", (ButtonTexture)UltraStorage.MAGIC_WEAPONS_FILTER), new SlotsFilterButton("weapon-summon", (ButtonTexture)UltraStorage.SUMMON_WEAPONS_FILTER), new SlotsFilterButton("weapon-other", (ButtonTexture)UltraStorage.OTHER_WEAPONS_FILTER), new SlotsFilterButton("tool", (ButtonTexture)UltraStorage.TOOL_ITEMS_FILTER), new SlotsFilterButton("armor", (ButtonTexture)UltraStorage.ARMOR_ITEMS_FILTER), new SlotsFilterButton("cosmetic", (ButtonTexture)UltraStorage.COSMETIC_ITEMS_FILTER), new SlotsFilterButton("trinket", (ButtonTexture)UltraStorage.TRINKET_ITEMS_FILTER), new SlotsFilterButton("mount", (ButtonTexture)UltraStorage.MOUNT_ITEMS_FILTER), new SlotsFilterButton("arrow", (ButtonTexture)UltraStorage.ARROW_ITEMS_FILTER), new SlotsFilterButton("bullet", (ButtonTexture)UltraStorage.BULLET_ITEMS_FILTER), new SlotsFilterButton("seed", (ButtonTexture)UltraStorage.SEED_ITEMS_FILTER), new SlotsFilterButton("bait", (ButtonTexture)UltraStorage.BAIT_ITEMS_FILTER), new SlotsFilterButton("food", (ButtonTexture)UltraStorage.FOOD_ITEMS_FILTER), new SlotsFilterButton("consumable", (ButtonTexture)UltraStorage.CONSUMABLE_ITEMS_FILTER), new SlotsFilterButton("quest", (ButtonTexture)UltraStorage.QUEST_ITEMS_FILTER), new SlotsFilterButton("misc", (ButtonTexture)UltraStorage.MISC_ITEMS_FILTER), new SlotsFilterButton("object", (ButtonTexture)UltraStorage.OBJECT_ITEMS_FILTER), new SlotsFilterButton("tile", (ButtonTexture)UltraStorage.TILE_ITEMS_FILTER), new SlotsFilterButton("vinyl", (ButtonTexture)UltraStorage.VINYL_ITEMS_FILTER)};
    public Map<String, FormContentIconButton> itemsFilterButtons = new HashMap<String, FormContentIconButton>();
    public String selectedButtonFilter = "all";
    public static int addedHeightForSearch = 86;
    public static final int buttonsPerColumn = 8;
    public static int maxColumns = (int)Math.ceil((float)filterButtons.length / 8.0f) - 1;
    public static int addedWidthForButtonFilters = maxColumns * 40 + 40 + 10;

    public static TypeParser<?>[] getParsers(FontOptions fontOptions) {
        return new TypeParser[]{TypeParsers.GAME_COLOR, TypeParsers.REMOVE_URL, TypeParsers.URL_OPEN, TypeParsers.ItemIcon((int)fontOptions.getSize()), TypeParsers.MobIcon((int)fontOptions.getSize()), TypeParsers.InputIcon((FontOptions)fontOptions)};
    }

    public VaultStorageContainerForm(final Client client, final VaultStorageContainer container) {
        super(client, (Container)container);
        OEInventory oeInventory = container.oeInventory;
        FontOptions labelOptions = new FontOptions(20);
        this.label = (FormLabelEdit)this.inventoryForm.addComponent((FormComponent)new FormLabelEdit("", labelOptions, Settings.UI.activeTextColor, 4, 4, this.inventoryForm.getWidth() - 8, 50), -1000);
        this.label.onMouseChangedTyping(e -> this.runEditUpdate());
        this.label.onSubmit(e -> this.runEditUpdate());
        this.label.allowCaretSetTyping = oeInventory.canSetInventoryName();
        this.label.allowItemAppend = true;
        this.label.setParsers(VaultStorageContainerForm.getParsers(labelOptions));
        this.label.setText(oeInventory.getInventoryName().translate());
        FormFlow iconFlow = new FormFlow(this.inventoryForm.getWidth() - 4 - 20);
        this.renameTip = new LocalMessage("ui", "renamebutton");
        if (oeInventory.canSetInventoryName()) {
            this.edit = (FormContentIconButton)this.inventoryForm.addComponent((FormComponent)new FormContentIconButton(iconFlow.next(-26) - 24, 4, FormInputSize.SIZE_24, ButtonColor.BASE, (ButtonTexture)Settings.UI.container_rename, new GameMessage[]{this.renameTip}));
            this.edit.onClicked(e -> {
                this.label.setTyping(!this.label.isTyping());
                this.runEditUpdate();
            });
        }
        FormContentIconButton actionButton = (FormContentIconButton)this.inventoryForm.addComponent((FormComponent)new FormContentIconButton(iconFlow.next(-26) - 24, 4, FormInputSize.SIZE_24, ButtonColor.BASE, (ButtonTexture)Settings.UI.inventory_quickstack_out, new GameMessage[0]){

            public GameTooltips getTooltips(PlayerMob perspective) {
                StringTooltips tooltips = new StringTooltips(Localization.translate((String)"ui", (String)"inventoryquickstack"));
                GameWindow window = WindowManager.getWindow();
                if (!window.isKeyDown(340) && !window.isKeyDown(344)) {
                    tooltips.add(Localization.translate((String)"ui", (String)"shiftmoreinfo"), GameColor.LIGHT_GRAY);
                } else {
                    tooltips.add(Localization.translate((String)"ui", (String)"inventoryquickstackinfo", (String)"key", (String)(TypeParsers.getInputParseString((Control)Control.INV_LOCK) + "+" + TypeParsers.getInputParseString((int)-100))), GameColor.LIGHT_GRAY, 400);
                }
                return tooltips;
            }
        });
        actionButton.onClicked(e -> {
            container.quickStackButton.runAndSend();
            this.updateFilter();
        });
        actionButton.setCooldown(500);
        class TransferAllButton
        extends FormContentIconButton {
            TransferAllButton(int x, int y, FormInputSize size, ButtonColor color, ButtonTexture icon, GameMessage ... tooltips) {
                super(x, y, size, color, icon, tooltips);
            }

            public GameTooltips getTooltips(PlayerMob perspective) {
                StringTooltips tooltips = new StringTooltips(Localization.translate((String)"ui", (String)"inventorytransferall"));
                GameWindow window = WindowManager.getWindow();
                if (!window.isKeyDown(340) && !window.isKeyDown(344)) {
                    tooltips.add(Localization.translate((String)"ui", (String)"shiftmoreinfo"), GameColor.LIGHT_GRAY);
                } else {
                    tooltips.add(Localization.translate((String)"ui", (String)"inventorytransferallinfo", (String)"key", (String)(TypeParsers.getInputParseString((Control)Control.INV_LOCK) + "+" + TypeParsers.getInputParseString((int)-100))), GameColor.LIGHT_GRAY, 400);
                }
                return tooltips;
            }
        }
        actionButton = ((TransferAllButton)this.inventoryForm.addComponent((FormComponent)new TransferAllButton(iconFlow.next(-26) - 24, 4, FormInputSize.SIZE_24, ButtonColor.BASE, (ButtonTexture)Settings.UI.container_loot_all, new GameMessage[0]))).mirrorY();
        actionButton.onClicked(e -> {
            container.transferAll.runAndSend();
            this.updateFilter();
        });
        actionButton.setCooldown(500);
        actionButton = (FormContentIconButton)this.inventoryForm.addComponent((FormComponent)new FormContentIconButton(iconFlow.next(-26) - 24, 4, FormInputSize.SIZE_24, ButtonColor.BASE, (ButtonTexture)Settings.UI.inventory_quickstack_in, new GameMessage[]{new LocalMessage("ui", "inventoryrestock")}));
        actionButton.onClicked(e -> {
            container.restockButton.runAndSend();
            this.updateFilter();
        });
        actionButton.setCooldown(500);
        actionButton = (FormContentIconButton)this.inventoryForm.addComponent((FormComponent)new FormContentIconButton(iconFlow.next(-26) - 24, 4, FormInputSize.SIZE_24, ButtonColor.BASE, (ButtonTexture)Settings.UI.container_loot_all, new GameMessage[]{new LocalMessage("ui", "inventorylootall")}));
        actionButton.onClicked(e -> container.lootButton.runAndSend());
        actionButton = (FormContentIconButton)this.inventoryForm.addComponent((FormComponent)new FormContentIconButton(iconFlow.next(-26) - 24, 4, FormInputSize.SIZE_24, ButtonColor.BASE, (ButtonTexture)Settings.UI.inventory_sort, new GameMessage[]{new LocalMessage("ui", "inventorysort")}));
        actionButton.onClicked(e -> container.sortButton.runAndSend());
        actionButton.setCooldown(500);
        this.settlementObjectFormManager = container.settlementObjectManager.getFormManager((FormSwitcher)this, (FormComponent)this.inventoryForm, client);
        this.settlementObjectFormManager.addConfigButtonRow(this.inventoryForm, iconFlow, 4, -1);
        VaultObject vaultObject = (VaultObject)container.objectEntity.getObject();
        final VaultObject nextVaultObject = vaultObject.getNextUltraChest();
        if (nextVaultObject != null) {
            int upgradeButtonWidth = 200;
            final InventoryItem upgradeItem = new InventoryItem((Item)nextVaultObject.getObjectItem());
            LocalMessage upgradeMessage = new LocalMessage("ui", "upgradeto", "upgrade", TypeParsers.getItemParseString((InventoryItem)upgradeItem));
            this.upgradeButton = (FormFairTypeButton)this.inventoryForm.addComponent((FormComponent)new FormFairTypeButton((GameMessage)upgradeMessage, iconFlow.next() - upgradeButtonWidth, 4, 200, FormInputSize.SIZE_24, ButtonColor.GREEN){

                protected void addTooltips(PlayerMob perspective) {
                    super.addTooltips(perspective);
                    ListGameTooltips tooltips = new ListGameTooltips();
                    FairType upgradeToType = new FairType();
                    FontOptions fontOptions = new FontOptions(Settings.tooltipTextSize).outline();
                    GameColor upgradeToColor = upgradeItem.item.getRarityColor(upgradeItem);
                    upgradeToType.append(fontOptions, Localization.translate((String)"ui", (String)"upgradeto", (String)"upgrade", (String)(upgradeToColor.getColorCode() + nextVaultObject.getDisplayName())));
                    upgradeToType.applyParsers(new TypeParser[]{TypeParsers.GAME_COLOR});
                    tooltips.add((Object)new FairTypeTooltip(upgradeToType));
                    tooltips.add((Object)new SpacerGameTooltip(10));
                    tooltips.add(Localization.translate((String)"misc", (String)"recipecostsing"));
                    Ingredient ingredient = nextVaultObject.ingredient;
                    CanCraft canCraft = Recipe.canCraft((Ingredient[])new Ingredient[]{ingredient}, (Level)client.getLevel(), (PlayerMob)client.getPlayer(), container.getCraftInventories(), (boolean)true);
                    tooltips.add((Object)ingredient.getTooltips(canCraft.canCraft() ? ingredient.getIngredientAmount() : canCraft.haveIngredients[0], true));
                    GameTooltipManager.addTooltip((GameTooltips)tooltips, (GameBackground)GameBackground.getItemTooltipBackground(), (TooltipLocation)TooltipLocation.FORM_FOCUS);
                }
            });
            this.upgradeButton.setParsers(new TypeParser[]{TypeParsers.ItemIcon((int)12)});
            this.upgradeButton.onClicked(e -> container.upgradeUltraChest.runAndSend());
        }
        this.label.setWidth(iconFlow.next() - 8);
        this.slotsBox = new FormContentBox(6, 34, this.inventoryForm.getWidth() - 12 - 23, 260 - addedHeightForSearch);
        this.inventoryForm.addComponent((FormComponent)this.slotsBox);
        this.searchFilter = (FormTextInput)this.inventoryForm.addComponent((FormComponent)new FormTextInput(26, this.inventoryForm.getHeight() - 86 + 12, FormInputSize.SIZE_32_TO_40, this.inventoryForm.getWidth() - 52, this.inventoryForm.getHeight() - 20));
        this.searchFilter.placeHolder = new LocalMessage("ui", "searchtip");
        this.searchFilter.rightClickToClear = true;
        this.searchFilter.onChange(event -> this.updateFilter());
        this.labelSlots = (FormLocalLabel)this.inventoryForm.addComponent((FormComponent)new FormLocalLabel((GameMessage)new StaticMessage(""), new FontOptions(10), 0, this.searchFilter.getX() + (this.inventoryForm.getWidth() - 52) / 2, this.searchFilter.getY() - 12));
        this.searchModFilter = (FormTextInput)this.inventoryForm.addComponent((FormComponent)new FormTextInput(26, this.inventoryForm.getHeight() - 46 + 6, FormInputSize.SIZE_32_TO_40, this.inventoryForm.getWidth() - 52, this.inventoryForm.getHeight() - 20));
        this.searchModFilter.placeHolder = new LocalMessage("ui", "searchmodtip");
        this.searchModFilter.rightClickToClear = true;
        this.searchModFilter.onChange(event -> this.updateFilter());
        FormBreakLine breakLine = (FormBreakLine)this.inventoryForm.addComponent((FormComponent)new FormBreakLine(FormBreakLine.ALIGN_MID, this.inventoryForm.getWidth() - 10, this.inventoryForm.getHeight() / 2, this.inventoryForm.getHeight() - 20, false));
        breakLine.color = new Color(0, 0, 0);
        this.inventoryForm.setWidth(width + addedWidthForButtonFilters);
        FormFlow buttonsIconFlow = new FormFlow(0);
        AtomicInteger inColumn = new AtomicInteger();
        AtomicInteger column = new AtomicInteger();
        Arrays.stream(filterButtons).forEach(itemFilterButtons -> {
            int actualColumn = column.get();
            int actualInRow = inColumn.get();
            if (inColumn.get() >= 8) {
                column.set(++actualColumn);
                actualInRow = 1;
                inColumn.set(actualInRow);
                buttonsIconFlow.next(-buttonsIconFlow.next());
            } else {
                inColumn.set(++actualInRow);
            }
            this.itemsFilterButtons.put(itemFilterButtons.id, (FormContentIconButton)(this.inventoryForm.addComponent((FormComponent)new FormContentIconButton(this.inventoryForm.getWidth() - addedWidthForButtonFilters + actualColumn * 40 + 6, buttonsIconFlow.next(34) + 10, FormInputSize.SIZE_32, Objects.equals(itemFilterButtons.id, "all") ? ButtonColor.GREEN : ButtonColor.BASE, itemFilterButtons.icon, new GameMessage[0], (SlotsFilterButton)itemFilterButtons){
                final /* synthetic */ SlotsFilterButton val$itemFilterButtons;
                {
                    this.val$itemFilterButtons = slotsFilterButton;
                    super(arg0, arg1, arg2, arg3, arg4, arg5);
                }

                public GameTooltips getTooltips(PlayerMob perspective) {
                    return new StringTooltips(Localization.translate((String)"ui", (String)(this.val$itemFilterButtons.id + "itemsfilter")));
                }
            })).onClicked(button -> {
                this.itemsFilterButtons.get((Object)this.selectedButtonFilter).color = ButtonColor.BASE;
                this.selectedButtonFilter = itemFilterButtons.id;
                this.itemsFilterButtons.get((Object)this.selectedButtonFilter).color = ButtonColor.GREEN;
                this.updateFilter();
            }));
        });
        this.updateFilter(true);
        this.makeCurrent((FormComponent)this.inventoryForm);
    }

    public void onWindowResized(GameWindow window) {
        super.onWindowResized(window);
        ContainerComponent.setPosFocus((Form)this.inventoryForm);
        this.settlementObjectFormManager.onWindowResized();
    }

    public boolean shouldOpenInventory() {
        return true;
    }

    public void updateFilter() {
        this.updateFilter(false);
    }

    public void updateFilter(boolean firstTime) {
        PlayerMob perspective = this.client.getPlayer();
        ArrayList<ContainerSlot> allSlots = ((VaultStorageContainer)this.container).getAllSlots();
        if (firstTime) {
            this.labelSlots.setText(allSlots.size() + " slots");
        } else {
            ((VaultStorageContainer)this.container).sortButton.runAndSend();
        }
        String searchText = this.searchFilter.getText().toLowerCase();
        String searchModText = this.searchModFilter.getText().toLowerCase();
        Stream<ContainerSlot> selectedSlots = allSlots.stream().filter(containerSlot -> {
            InventoryItem inventoryItem = containerSlot.getItem();
            if (inventoryItem == null) {
                return true;
            }
            Item item = inventoryItem.item;
            if (item == null) {
                return true;
            }
            LoadedMod mod = ItemRegistry.getItemMod((int)item.getID());
            if (mod == null ? !"vanilla".contains(searchModText) : !mod.id.contains(searchModText)) {
                return false;
            }
            if (!Objects.equals(this.selectedButtonFilter, "all")) {
                if (item instanceof StonePlaceableItem) {
                    if (!Objects.equals(this.selectedButtonFilter, "mat")) {
                        return false;
                    }
                } else if (Objects.equals(this.selectedButtonFilter, "tool") || this.selectedButtonFilter.startsWith("weapon-")) {
                    if (!UltraStorage.isRequiredToolType(this.selectedButtonFilter, item, perspective)) {
                        return false;
                    }
                } else if (Objects.equals(this.selectedButtonFilter, "armor") || Objects.equals(this.selectedButtonFilter, "cosmetic")) {
                    if (!(item instanceof ArmorItem)) {
                        return false;
                    }
                    if (UltraStorage.isCosmetic((ArmorItem)item, perspective) != Objects.equals(this.selectedButtonFilter, "cosmetic")) {
                        return false;
                    }
                } else if (Arrays.asList(UltraStorage.miscSeparatedItems).contains(this.selectedButtonFilter)) {
                    if (item.type != Item.Type.MISC) {
                        return false;
                    }
                    if (item instanceof ConsumableItem ? !Objects.equals(this.selectedButtonFilter, "consumable") : (item instanceof ObjectItem ? !Objects.equals(this.selectedButtonFilter, "object") : (item instanceof TileItem ? !Objects.equals(this.selectedButtonFilter, "tile") : (item instanceof VinylItem ? !Objects.equals(this.selectedButtonFilter, "vinyl") : !Objects.equals(this.selectedButtonFilter, "misc"))))) {
                        return false;
                    }
                } else if (item.type != Item.Type.valueOf((String)this.selectedButtonFilter.toUpperCase())) {
                    return false;
                }
            }
            return item.getStringID().toLowerCase().contains(searchText) || item.getDisplayName(item.getDefaultItem(this.client.getPlayer(), 1)).toLowerCase().contains(searchText);
        });
        this.slotsBox.clearComponents();
        FormFlow flow = new FormFlow(34);
        this.addSlots(flow, selectedSlots.collect(Collectors.toList()));
        this.slotsBox.setContentBox(new Rectangle(6, 34, this.slotsBox.getWidth(), flow.next()));
    }

    private void runEditUpdate() {
        OEInventory oeInventory = ((VaultStorageContainer)this.container).getOEInventory();
        if (oeInventory.canSetInventoryName()) {
            if (this.label.isTyping()) {
                this.edit.setIcon(Settings.UI.container_rename_save);
                this.renameTip = new LocalMessage("ui", "savebutton");
            } else {
                if (!this.label.getText().equals(oeInventory.getInventoryName().translate())) {
                    oeInventory.setInventoryName(this.label.getText());
                    ((VaultStorageContainer)this.container).renameButton.runAndSend(this.label.getText());
                }
                this.edit.setIcon(Settings.UI.container_rename);
                this.renameTip = new LocalMessage("ui", "renamebutton");
                this.label.setText(oeInventory.getInventoryName().translate());
            }
            this.edit.setTooltips(new GameMessage[]{this.renameTip});
        }
    }

    public void draw(TickManager tickManager, PlayerMob perspective, Rectangle renderBox) {
        this.settlementObjectFormManager.updateButtons();
        super.draw(tickManager, perspective, renderBox);
    }

    protected void addSlots(FormFlow flow, List<ContainerSlot> itemSlots) {
        this.slots = new FormContainerSlot[itemSlots.size()];
        int currentY = flow.next();
        for (int i = 0; i < itemSlots.size(); ++i) {
            ContainerSlot containerSlot = itemSlots.get(i);
            int x = i % 12;
            if (x == 0) {
                currentY = flow.next(40);
            }
            this.slots[i] = (FormContainerSlot)this.slotsBox.addComponent((FormComponent)new FormContainerVaultSlot(this.client, this.container, containerSlot.getContainerIndex(), 28 + x * 40, currentY));
        }
    }

    public static class SlotsFilterButton {
        String id;
        ButtonTexture icon;

        public SlotsFilterButton(String id, ButtonTexture icon) {
            this.id = id;
            this.icon = icon;
        }
    }
}

