/*
 * Decompiled with CFR 0.152.
 */
package ultrastorage.containers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import necesse.engine.GameTileRange;
import necesse.engine.Settings;
import necesse.engine.network.NetworkClient;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.network.packet.PacketOEInventoryNameUpdate;
import necesse.engine.network.packet.PacketOpenContainer;
import necesse.engine.network.server.ServerClient;
import necesse.engine.registries.ContainerRegistry;
import necesse.engine.world.WorldEntityGameClock;
import necesse.engine.world.worldData.SettlementsWorldData;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.objectEntity.ObjectEntity;
import necesse.entity.objectEntity.interfaces.OEInventory;
import necesse.entity.objectEntity.interfaces.OEUsers;
import necesse.inventory.Inventory;
import necesse.inventory.InventoryRange;
import necesse.inventory.container.SlotIndexRange;
import necesse.inventory.container.customAction.ContainerCustomAction;
import necesse.inventory.container.customAction.EmptyCustomAction;
import necesse.inventory.container.customAction.StringCustomAction;
import necesse.inventory.container.settlement.SettlementContainerObjectStatusManager;
import necesse.inventory.container.settlement.SettlementDependantContainer;
import necesse.inventory.container.settlement.events.SettlementDataEvent;
import necesse.inventory.container.slots.ContainerSlot;
import necesse.inventory.container.slots.OEInventoryContainerSlot;
import necesse.inventory.recipe.Ingredient;
import necesse.inventory.recipe.Recipe;
import necesse.level.maps.Level;
import necesse.level.maps.levelData.settlementData.ServerSettlementData;
import necesse.level.maps.regionSystem.RegionPositionGetter;
import ultrastorage.objects.VaultObject;

public class VaultStorageContainer
extends SettlementDependantContainer {
    public StringCustomAction renameButton;
    public EmptyCustomAction quickStackButton;
    public EmptyCustomAction transferAll;
    public EmptyCustomAction restockButton;
    public EmptyCustomAction lootButton;
    public EmptyCustomAction sortButton;
    public final OEInventory oeInventory;
    public final ObjectEntity objectEntity;
    public final OEUsers oeUsers;
    public int INVENTORY_START = -1;
    public int INVENTORY_END = -1;
    public SettlementContainerObjectStatusManager settlementObjectManager;
    public final EmptyCustomAction upgradeUltraChest;
    private final LinkedHashSet<Inventory> nearbyInventories = new LinkedHashSet();

    public VaultStorageContainer(final NetworkClient client, int uniqueSeed, SettlementDataEvent settlement, final OEInventory oeInventory, PacketReader reader) {
        super(client, uniqueSeed, settlement, true);
        this.oeInventory = oeInventory;
        this.objectEntity = (ObjectEntity)oeInventory;
        VaultObject vaultObject = (VaultObject)this.objectEntity.getObject();
        oeInventory.triggerInteracted();
        this.oeUsers = this.objectEntity instanceof OEUsers ? (OEUsers)this.objectEntity : null;
        if (client.isServer() & this.oeUsers != null) {
            this.oeUsers.startUser((Mob)client.playerMob);
        }
        this.nearbyInventories.addAll(this.craftInventories);
        this.nearbyInventories.add(this.oeInventory.getInventory());
        for (InventoryRange inventoryRange : this.getNearbyInventories(this.getLevel(), this.objectEntity.tileX, this.objectEntity.tileY, new GameTileRange(9, vaultObject.getMultiTile(0).getTileRectangle(0, 0)), OEInventory::canUseForNearbyCrafting)) {
            this.nearbyInventories.add(inventoryRange.inventory);
        }
        this.settlementObjectManager = new SettlementContainerObjectStatusManager((SettlementDependantContainer)this, this.objectEntity.getLevel(), this.objectEntity.tileX, this.objectEntity.tileY, reader);
        InventoryRange inventoryRange = this.getOEInventoryRange();
        for (int i = inventoryRange.startSlot; i <= inventoryRange.endSlot; ++i) {
            int index = this.addSlot(this.getOEContainerSlot(oeInventory, i));
            if (this.INVENTORY_START == -1) {
                this.INVENTORY_START = index;
            }
            if (this.INVENTORY_END == -1) {
                this.INVENTORY_END = index;
            }
            this.INVENTORY_START = Math.min(this.INVENTORY_START, index);
            this.INVENTORY_END = Math.max(this.INVENTORY_END, index);
        }
        this.addInventoryQuickTransfer(this.INVENTORY_START, this.INVENTORY_END);
        this.renameButton = (StringCustomAction)this.registerAction((ContainerCustomAction)new StringCustomAction(){

            protected void run(String value) {
                if (oeInventory.canSetInventoryName()) {
                    oeInventory.setInventoryName(value);
                    if (client.isServer()) {
                        client.getServerClient().getServer().network.sendToClientsWithEntity((Packet)new PacketOEInventoryNameUpdate(oeInventory, value), (RegionPositionGetter)VaultStorageContainer.this.objectEntity);
                    }
                }
            }
        });
        this.quickStackButton = (EmptyCustomAction)this.registerAction((ContainerCustomAction)new EmptyCustomAction(){

            protected void run() {
                if (oeInventory.canQuickStackInventory()) {
                    ArrayList<InventoryRange> targets = new ArrayList<InventoryRange>(Collections.singleton(VaultStorageContainer.this.getOEInventoryRange()));
                    VaultStorageContainer.this.quickStackToInventories(targets, (Inventory)client.playerMob.getInv().main);
                }
            }
        });
        this.transferAll = (EmptyCustomAction)this.registerAction((ContainerCustomAction)new EmptyCustomAction(){

            protected void run() {
                for (int i = VaultStorageContainer.this.CLIENT_INVENTORY_START; i <= VaultStorageContainer.this.CLIENT_INVENTORY_END; ++i) {
                    if (VaultStorageContainer.this.getSlot(i).isItemLocked()) continue;
                    VaultStorageContainer.this.transferToSlots(VaultStorageContainer.this.getSlot(i), VaultStorageContainer.this.INVENTORY_START, VaultStorageContainer.this.INVENTORY_END, "transferall");
                }
            }
        });
        this.restockButton = (EmptyCustomAction)this.registerAction((ContainerCustomAction)new EmptyCustomAction(){

            protected void run() {
                ArrayList<InventoryRange> targets = new ArrayList<InventoryRange>(Collections.singleton(VaultStorageContainer.this.getOEInventoryRange()));
                VaultStorageContainer.this.restockFromInventories(targets, (Inventory)client.playerMob.getInv().main);
            }
        });
        this.lootButton = (EmptyCustomAction)this.registerAction((ContainerCustomAction)new EmptyCustomAction(){

            protected void run() {
                for (int i = VaultStorageContainer.this.INVENTORY_START; i <= VaultStorageContainer.this.INVENTORY_END; ++i) {
                    if (VaultStorageContainer.this.getSlot(i).isItemLocked()) continue;
                    VaultStorageContainer.this.transferToSlots(VaultStorageContainer.this.getSlot(i), Arrays.asList(new SlotIndexRange(VaultStorageContainer.this.CLIENT_HOTBAR_START, VaultStorageContainer.this.CLIENT_HOTBAR_END), new SlotIndexRange(VaultStorageContainer.this.CLIENT_INVENTORY_START, VaultStorageContainer.this.CLIENT_INVENTORY_END)), "lootall");
                }
            }
        });
        this.sortButton = (EmptyCustomAction)this.registerAction((ContainerCustomAction)new EmptyCustomAction(){

            protected void run() {
                if (oeInventory.canSortInventory()) {
                    InventoryRange range = VaultStorageContainer.this.getOEInventoryRange();
                    range.inventory.sortItems(client.playerMob.getLevel(), client.playerMob, range.startSlot, range.endSlot);
                }
            }
        });
        this.upgradeUltraChest = (EmptyCustomAction)this.registerAction((ContainerCustomAction)new EmptyCustomAction(){

            protected void run() {
                VaultObject vaultObject = (VaultObject)VaultStorageContainer.this.objectEntity.getObject();
                VaultObject nextVaultObject = vaultObject.getNextUltraChest();
                if (nextVaultObject != null) {
                    Collection<Inventory> craftInventories = VaultStorageContainer.this.getCraftInventories();
                    if (VaultStorageContainer.this.canCraftRecipe(new Ingredient[]{nextVaultObject.ingredient}, craftInventories, true).canCraft()) {
                        if (client.isServer()) {
                            vaultObject.performUpgrade(nextVaultObject, VaultStorageContainer.this.objectEntity.getLevelObject().level, VaultStorageContainer.this.objectEntity.getLevelObject().tileX, VaultStorageContainer.this.objectEntity.getLevelObject().tileY, client.getServerClient(), oeInventory.getInventory());
                        }
                        Recipe.craft((Ingredient[])new Ingredient[]{nextVaultObject.ingredient}, (Level)client.playerMob.getLevel(), (PlayerMob)client.playerMob, craftInventories);
                    }
                    VaultStorageContainer.this.close();
                }
            }
        });
    }

    private boolean useNearbyInventories() {
        return this.client.isServer() ? this.client.craftingUsesNearbyInventories : (Boolean)Settings.craftingUseNearby.get();
    }

    public Collection<Inventory> getCraftInventories() {
        return this.useNearbyInventories() ? this.nearbyInventories : super.getCraftInventories();
    }

    public ArrayList<ContainerSlot> getAllSlots() {
        ArrayList<ContainerSlot> containerSlots = new ArrayList<ContainerSlot>();
        for (int i = this.INVENTORY_START; i <= this.INVENTORY_END; ++i) {
            containerSlots.add(this.getSlot(i));
        }
        return containerSlots;
    }

    public ContainerSlot getOEContainerSlot(OEInventory oeInventory, int slot) {
        return new OEInventoryContainerSlot(oeInventory, slot);
    }

    public void quickStackControlPressed() {
        this.quickStackButton.runAndSend();
    }

    public void tick() {
        super.tick();
        if (this.client.isServer() & this.oeUsers != null) {
            this.oeUsers.startUser((Mob)this.client.playerMob);
        }
    }

    protected Level getLevel() {
        return this.objectEntity.getLevel();
    }

    public boolean isValid(ServerClient client) {
        if (!super.isValid(client)) {
            return false;
        }
        Level level = client.getLevel();
        return !this.objectEntity.removed() && level.getObject(this.objectEntity.tileX, this.objectEntity.tileY).isInInteractRange(level, this.objectEntity.tileX, this.objectEntity.tileY, client.playerMob);
    }

    public OEInventory getOEInventory() {
        return this.oeInventory;
    }

    public InventoryRange getOEInventoryRange() {
        return new InventoryRange(this.oeInventory.getInventory());
    }

    public void onClose() {
        super.onClose();
        if (this.client.isServer() & this.oeUsers != null) {
            this.oeUsers.stopUser((Mob)this.client.playerMob);
        }
    }

    public static void openAndSendContainer(int containerID, ServerClient client, Level level, int tileX, int tileY, Packet extraContent) {
        if (!level.isServer()) {
            throw new IllegalStateException("Level must be a server level");
        }
        Packet packet = new Packet();
        PacketWriter writer = new PacketWriter(packet);
        ServerSettlementData settlement = SettlementsWorldData.getSettlementsData((WorldEntityGameClock)level).getServerDataAtTile(level.getIdentifier(), tileX, tileY);
        SettlementContainerObjectStatusManager.writeContent((ServerSettlementData)settlement, (Level)level, (int)tileX, (int)tileY, (PacketWriter)writer);
        if (extraContent != null) {
            writer.putNextContentPacket(extraContent);
        }
        ObjectEntity objectEntity = level.entityManager.getObjectEntity(tileX, tileY);
        PacketOpenContainer p = PacketOpenContainer.SettlementObjectEntity((int)containerID, (ServerSettlementData)settlement, (ObjectEntity)objectEntity, (Packet)packet);
        ContainerRegistry.openAndSendContainer((ServerClient)client, (PacketOpenContainer)p);
    }

    public static void openAndSendContainer(int containerID, ServerClient client, Level level, int tileX, int tileY) {
        VaultStorageContainer.openAndSendContainer(containerID, client, level, tileX, tileY, null);
    }
}

