/*
 * Decompiled with CFR 0.152.
 */
package watch;

import necesse.engine.localization.Localization;
import necesse.engine.util.GameBlackboard;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.trinketItem.SimpleTrinketItem;
import necesse.inventory.lootTable.presets.TrinketsLootTable;
import watch.Watch;

public class WatchItem
extends SimpleTrinketItem {
    public WatchItem(Item.Rarity rarity, String buffStringID, int enchantCost) {
        super(rarity, buffStringID, enchantCost, TrinketsLootTable.trinkets);
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = new ListGameTooltips();
        tooltips.add(Localization.translate((String)"itemtooltip", (String)(this.isAbilityTrinket(item) ? "trinketabilityslot" : "trinketslot")));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"watchbuff1"));
        if (Watch.settingsGetter.getSelection("timeFormat").toString().equalsIgnoreCase("24")) {
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"watchbuff2", (String)"time", (String)perspective.getWorldEntity().getDayTimeReadable()));
        } else if (perspective.getWorldEntity().getDayTimeHour() == 0) {
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"watchbuff2", (String)"time", (String)("12:" + this.addAzero(perspective.getWorldEntity().getDayTimeMinute()) + " AM")));
        } else if (perspective.getWorldEntity().getDayTimeHour() <= 11) {
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"watchbuff2", (String)"time", (String)(Integer.toString(perspective.getWorldEntity().getDayTimeHour()) + ":" + this.addAzero(perspective.getWorldEntity().getDayTimeMinute()) + " AM")));
        } else if (perspective.getWorldEntity().getDayTimeHour() == 12) {
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"watchbuff2", (String)"time", (String)("12:" + this.addAzero(perspective.getWorldEntity().getDayTimeMinute()) + " PM")));
        } else if (perspective.getWorldEntity().getDayTimeHour() > 12) {
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"watchbuff2", (String)"time", (String)(Integer.toString(perspective.getWorldEntity().getDayTimeHour() - 12) + ":" + this.addAzero(perspective.getWorldEntity().getDayTimeMinute()) + " PM")));
        }
        return tooltips;
    }

    public String addAzero(Integer time) {
        String out = time < 10 ? "0" + Integer.toString(time) : Integer.toString(time);
        return out;
    }
}

