/*
 * Decompiled with CFR 0.152.
 */
package quickrecipesmenu.menu.lists;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import necesse.engine.Settings;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.input.InputEvent;
import necesse.engine.input.controller.ControllerEvent;
import necesse.engine.input.controller.ControllerInput;
import necesse.engine.journal.JournalEntry;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.StaticMessage;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.util.LevelIdentifier;
import necesse.engine.window.GameWindow;
import necesse.engine.window.WindowManager;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.GameBackground;
import necesse.gfx.GameColor;
import necesse.gfx.forms.components.lists.FormGeneralGridList;
import necesse.gfx.forms.components.lists.FormListGridElement;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.gameTooltips.GameTooltipManager;
import necesse.gfx.gameTooltips.GameTooltips;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.gfx.gameTooltips.StringTooltips;
import necesse.gfx.gameTooltips.TooltipLocation;
import necesse.gfx.ui.HoverStateTextures;
import necesse.inventory.item.Item;
import quickrecipesmenu.menu.MenuContainerForm;
import quickrecipesmenu.menu.entries.single.SingleLevelEntry;

public class FormLevelList
extends FormGeneralGridList<JournalEntryGrid> {
    public MenuContainerForm<?> mainForm;
    public static Map<String, String> otherLevelTextures = new HashMap<String, String>();

    public FormLevelList(MenuContainerForm<?> mainForm, int x, int y, int width, int height) {
        super(x, y, width, height, 36, 36);
        this.mainForm = mainForm;
    }

    public void setLevels(Collection<JournalEntry> journalEntries) {
        this.elements = new ArrayList();
        if (journalEntries != null) {
            this.elements.addAll(journalEntries.stream().map(x$0 -> new JournalEntryGrid((JournalEntry)x$0)).collect(Collectors.toList()));
        }
        this.limitMaxScroll();
    }

    public void onLevelClicked(JournalEntry journalEntry, InputEvent event) {
        SingleLevelEntry.showLevel(this.mainForm, journalEntry.getID());
        this.playTickSound();
        ControllerInput.submitNextRefreshFocusEvent();
    }

    public void addTooltips(JournalEntry journalEntry, ListGameTooltips tooltips) {
    }

    public GameMessage getEmptyMessage() {
        return new StaticMessage("Nothing");
    }

    protected void drawScrollButtons(TickManager tickManager) {
        HoverStateTextures buttonTextures = Settings.UI.button_navigate_vertical;
        if (this.isHoveringTop) {
            GameTexture topTexture = buttonTextures.highlighted;
            Color topColor = Settings.UI.highlightElementColor;
            topTexture.initDraw().color(topColor).draw(this.getX() + this.width / 2 - topTexture.getWidth() / 2, this.getY() + 3);
        }
        if (this.isHoveringBot) {
            GameTexture botTexture = buttonTextures.highlighted;
            Color botColor = Settings.UI.highlightElementColor;
            botTexture.initDraw().color(botColor).mirrorY().draw(this.getX() + this.width / 2 - botTexture.getWidth() / 2, this.getY() + this.height - 3 - botTexture.getHeight());
        }
    }

    static {
        otherLevelTextures.put("temple", "items/templeentrance");
    }

    public class JournalEntryGrid
    extends FormListGridElement<FormLevelList> {
        public final JournalEntry journalEntry;

        public JournalEntryGrid(JournalEntry journalEntry) {
            this.journalEntry = journalEntry;
        }

        protected void draw(FormLevelList parent, TickManager tickManager, PlayerMob perspective, int elementIndex) {
            Color color = Settings.UI.activeElementColor;
            if (this.isMouseOver(parent)) {
                color = Settings.UI.highlightElementColor;
                GameWindow window = WindowManager.getWindow();
                if (!window.isKeyDown(-100) && !window.isKeyDown(-99)) {
                    ListGameTooltips tooltips = new ListGameTooltips((GameTooltips)new StringTooltips(this.journalEntry.getLocalization().translate(), GameColor.ITEM_NORMAL));
                    FormLevelList.this.addTooltips(this.journalEntry, tooltips);
                    GameTooltipManager.addTooltip((GameTooltips)tooltips, (GameBackground)GameBackground.getItemTooltipBackground(), (TooltipLocation)TooltipLocation.FORM_FOCUS);
                }
            }
            GameTexture slotTexture = this.isMouseOver(parent) ? Settings.UI.inventoryslot_small.highlighted : Settings.UI.inventoryslot_small.active;
            slotTexture.initDraw().color(color).draw(2, 2);
            if (Objects.equals(this.journalEntry.getStringID(), "plainssurface")) {
                GameTexture.fromFile((String)"biomes/plains").initDraw().draw(2, 2);
                return;
            }
            if (this.journalEntry.incursionBiome != null) {
                this.journalEntry.incursionBiome.getTabletSprite().initDraw().draw(2, 2);
            } else if (this.journalEntry.biome != null) {
                if (this.journalEntry.levelIdentifier == LevelIdentifier.CAVE_IDENTIFIER || this.journalEntry.levelIdentifier == LevelIdentifier.DEEP_CAVE_IDENTIFIER) {
                    GameTexture.fromFile((String)("biomes/" + this.journalEntry.biome.getStringID())).initDraw().draw(2, 2);
                    Item item = this.journalEntry.levelIdentifier == LevelIdentifier.CAVE_IDENTIFIER ? ItemRegistry.getItem((String)"ladderdown") : ItemRegistry.getItem((String)"deepladderdown");
                    item.getItemSprite(item.getDefaultItem(perspective, 1), perspective).initDraw().draw(10, 8);
                } else {
                    GameTexture.fromFile((String)otherLevelTextures.getOrDefault(this.journalEntry.getStringID(), "biomes/" + this.journalEntry.biome.getStringID())).initDraw().draw(2, 2);
                }
            }
        }

        protected void onClick(FormLevelList parent, int elementIndex, InputEvent event, PlayerMob perspective) {
            FormLevelList.this.onLevelClicked(this.journalEntry, event);
        }

        protected void onControllerEvent(FormLevelList parent, int elementIndex, ControllerEvent event, TickManager tickManager, PlayerMob perspective) {
            if (event.getState() == ControllerInput.MENU_SELECT) {
                FormLevelList.this.onLevelClicked(this.journalEntry, InputEvent.ControllerButtonEvent((ControllerEvent)event, (TickManager)tickManager));
                event.use();
            }
        }
    }
}

