/*
 * Decompiled with CFR 0.152.
 */
package quickrecipesmenu.menu.lists;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import necesse.engine.Settings;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.input.InputEvent;
import necesse.engine.input.controller.ControllerEvent;
import necesse.engine.input.controller.ControllerInput;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.StaticMessage;
import necesse.engine.util.GameBlackboard;
import necesse.engine.window.GameWindow;
import necesse.engine.window.WindowManager;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.GameBackground;
import necesse.gfx.forms.components.lists.FormGeneralGridList;
import necesse.gfx.forms.components.lists.FormListGridElement;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.gameTooltips.GameTooltipManager;
import necesse.gfx.gameTooltips.GameTooltips;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.gfx.gameTooltips.TooltipLocation;
import necesse.gfx.ui.HoverStateTextures;
import necesse.inventory.item.Item;
import quickrecipesmenu.menu.MenuContainerForm;
import quickrecipesmenu.menu.entries.single.SingleItemEntry;

public class FormItemList
extends FormGeneralGridList<ItemGrid> {
    public MenuContainerForm<?> mainForm;

    public FormItemList(MenuContainerForm<?> mainForm, int x, int y, int width, int height) {
        super(x, y, width, height, 36, 36);
        this.mainForm = mainForm;
    }

    public void setItems(Collection<Item> items) {
        this.elements = new ArrayList();
        if (items != null) {
            this.elements.addAll(items.stream().map(x$0 -> new ItemGrid((Item)x$0)).collect(Collectors.toList()));
        }
        this.limitMaxScroll();
    }

    public void onItemClicked(Item item, InputEvent event) {
        SingleItemEntry.showItem(this.mainForm, item.getID());
        this.playTickSound();
        ControllerInput.submitNextRefreshFocusEvent();
    }

    public void addTooltips(Item item, ListGameTooltips tooltips) {
    }

    public GameMessage getEmptyMessage() {
        return new StaticMessage("Nothing");
    }

    protected void drawScrollButtons(TickManager tickManager) {
        HoverStateTextures buttonTextures = Settings.UI.button_navigate_vertical;
        if (this.isHoveringTop) {
            GameTexture topTexture = buttonTextures.highlighted;
            Color topColor = Settings.UI.highlightElementColor;
            topTexture.initDraw().color(topColor).draw(this.getX() + this.width / 2 - topTexture.getWidth() / 2, this.getY() + 3);
        }
        if (this.isHoveringBot) {
            GameTexture botTexture = buttonTextures.highlighted;
            Color botColor = Settings.UI.highlightElementColor;
            botTexture.initDraw().color(botColor).mirrorY().draw(this.getX() + this.width / 2 - botTexture.getWidth() / 2, this.getY() + this.height - 3 - botTexture.getHeight());
        }
    }

    public class ItemGrid
    extends FormListGridElement<FormItemList> {
        public final Item item;

        public ItemGrid(Item item) {
            this.item = item;
        }

        protected void draw(FormItemList parent, TickManager tickManager, PlayerMob perspective, int elementIndex) {
            Color color = Settings.UI.activeElementColor;
            if (this.isMouseOver(parent)) {
                color = Settings.UI.highlightElementColor;
                GameWindow window = WindowManager.getWindow();
                if (!window.isKeyDown(-100) && !window.isKeyDown(-99)) {
                    ListGameTooltips tooltips = new ListGameTooltips((GameTooltips)this.item.getDefaultItem(perspective, 1).getTooltip(perspective, new GameBlackboard()));
                    FormItemList.this.addTooltips(this.item, tooltips);
                    GameTooltipManager.addTooltip((GameTooltips)tooltips, (GameBackground)GameBackground.getItemTooltipBackground(), (TooltipLocation)TooltipLocation.FORM_FOCUS);
                }
            }
            GameTexture slotTexture = this.isMouseOver(parent) ? Settings.UI.inventoryslot_small.highlighted : Settings.UI.inventoryslot_small.active;
            slotTexture.initDraw().color(color).draw(2, 2);
            this.item.getItemSprite(this.item.getDefaultItem(perspective, 1), perspective).initDraw().draw(2, 2);
        }

        protected void onClick(FormItemList parent, int elementIndex, InputEvent event, PlayerMob perspective) {
            FormItemList.this.onItemClicked(this.item, event);
        }

        protected void onControllerEvent(FormItemList parent, int elementIndex, ControllerEvent event, TickManager tickManager, PlayerMob perspective) {
            if (event.getState() == ControllerInput.MENU_SELECT) {
                FormItemList.this.onItemClicked(this.item, InputEvent.ControllerButtonEvent((ControllerEvent)event, (TickManager)tickManager));
                event.use();
            }
        }
    }
}

