/*
 * Decompiled with CFR 0.152.
 */
package quickrecipesmenu.menu.entries.single;

import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import necesse.engine.journal.JournalEntry;
import necesse.engine.localization.Localization;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.registries.JournalRegistry;
import necesse.engine.registries.MobRegistry;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.ai.behaviourTree.AINode;
import necesse.entity.mobs.ai.behaviourTree.trees.CollisionPlayerChaserWandererAI;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormContentBox;
import necesse.gfx.forms.components.FormLabel;
import necesse.gfx.forms.components.localComponents.FormLocalLabel;
import necesse.gfx.gameFont.FontOptions;
import necesse.inventory.item.Item;
import quickrecipesmenu.QuickRecipesMenu;
import quickrecipesmenu.menu.MenuContainerForm;
import quickrecipesmenu.menu.entries.MenuEntry;
import quickrecipesmenu.menu.entries.show.ShowMobComponent;
import quickrecipesmenu.menu.lists.FormItemList;
import quickrecipesmenu.menu.lists.FormLevelList;

public class SingleMobEntry
extends MenuEntry {
    private static final Map<Integer, List<Integer>> mobsLoot = new HashMap<Integer, List<Integer>>();
    private static final Map<Integer, List<Integer>> mobFoundInJournal = new HashMap<Integer, List<Integer>>();
    public static int mobID;
    public static MobLabelData[] mobLabelDataList;

    public SingleMobEntry() {
        super(mobID == -1 ? "unknownmob" : "mob." + MobRegistry.getMobStringID((int)mobID));
    }

    @Override
    public void updateContent(MenuContainerForm<?> mainForm, FormContentBox form) {
        if (mobID != -1) {
            boolean findJournal;
            FormContentBox mobContent = (FormContentBox)form.addComponent((FormComponent)new FormContentBox(0, 0, form.getWidth(), form.getHeight()));
            Mob mob = MobRegistry.getMob((int)mobID, null);
            int currentY = 6;
            mobContent.addComponent((FormComponent)new ShowMobComponent(4, 8, mobID));
            mobContent.addComponent((FormComponent)new FormLabel(mob.getDisplayName(), new FontOptions(32), -1, 46, currentY));
            currentY += 48;
            for (MobLabelData mobLabelData : mobLabelDataList) {
                currentY = mobLabelData.display(mobContent, mob, currentY);
            }
            currentY += 20;
            List<Integer> loot = mobsLoot.get(mobID);
            List<Integer> journal = mobFoundInJournal.get(mobID);
            boolean findLoot = loot == null;
            boolean bl = findJournal = journal == null;
            if (findLoot || findJournal) {
                if (findLoot) {
                    loot = new ArrayList<Integer>();
                }
                if (findJournal) {
                    journal = new ArrayList<Integer>();
                }
                for (JournalEntry journalEntry : QuickRecipesMenu.journalEntriesByProgression()) {
                    JournalEntry.MobJournalData mobData;
                    if (journalEntry.mobsData == null || (mobData = (JournalEntry.MobJournalData)journalEntry.mobsData.stream().filter(m -> m.mob.getID() == mobID).findAny().orElse(null)) == null) continue;
                    if (findLoot) {
                        for (Item item : mobData.itemDrops.getItems()) {
                            if (loot.contains(item.getID())) continue;
                            loot.add(item.getID());
                        }
                    }
                    if (!findJournal) continue;
                    journal.add(journalEntry.getID());
                }
                if (findLoot) {
                    mobsLoot.put(mobID, loot);
                }
                if (findJournal) {
                    mobFoundInJournal.put(mobID, journal);
                }
            }
            if (!loot.isEmpty()) {
                mobContent.addComponent((FormComponent)new FormLocalLabel("ui", "loot", new FontOptions(18), -1, 0, currentY));
                int rows = (int)Math.ceil((float)loot.size() / 19.0f);
                int height = 32 + rows * 36;
                FormItemList itemList = new FormItemList(mainForm, 0, currentY += 20, form.getWidth(), height);
                mobContent.addComponent((FormComponent)itemList);
                itemList.setItems(loot.stream().map(ItemRegistry::getItem).collect(Collectors.toList()));
                currentY += height + 20;
            }
            if (!journal.isEmpty()) {
                mobContent.addComponent((FormComponent)new FormLocalLabel("ui", "foundin", new FontOptions(18), -1, 0, currentY));
                int rows = (int)Math.ceil((float)journal.size() / 19.0f);
                int height = 32 + rows * 36;
                FormLevelList levelList = new FormLevelList(mainForm, 0, currentY += 20, form.getWidth(), height){};
                mobContent.addComponent((FormComponent)levelList);
                levelList.setLevels(journal.stream().map(JournalRegistry::getJournalEntry).collect(Collectors.toList()));
                currentY += height + 20;
            }
            mobContent.setContentBox(new Rectangle(0, 0, form.getWidth(), currentY));
        }
    }

    public static void showMob(MenuContainerForm<?> mainForm, int mobID) {
        SingleMobEntry.mobID = mobID;
        MenuContainerForm.actualEntry = new SingleMobEntry();
        MenuContainerForm.mainForm.updateContent();
        mainForm.updateEntries();
    }

    static {
        mobLabelDataList = new MobLabelData[]{new MobLabelData("health"){

            @Override
            public String getDisplayData(Mob mob) {
                return String.valueOf(mob.getMaxHealth());
            }
        }, new MobLabelData("armor"){

            @Override
            public String getDisplayData(Mob mob) {
                return String.valueOf(mob.getArmor());
            }
        }, new MobLabelData("speed"){

            @Override
            public String getDisplayData(Mob mob) {
                try {
                    Field soeedField = Mob.class.getDeclaredField("speed");
                    soeedField.setAccessible(true);
                    return String.valueOf(soeedField.getFloat(mob));
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    return null;
                }
            }
        }, new MobLabelData("damage"){

            @Override
            public String getDisplayData(Mob mob) {
                if (!mob.isHostile) {
                    return null;
                }
                if (mob.ai == null) {
                    return null;
                }
                AINode aiNode = mob.ai.tree;
                if (aiNode instanceof CollisionPlayerChaserWandererAI) {
                    CollisionPlayerChaserWandererAI hostileAiNode = (CollisionPlayerChaserWandererAI)aiNode;
                    if (hostileAiNode.collisionPlayerChaserAI == null) {
                        return null;
                    }
                    return String.valueOf(hostileAiNode.collisionPlayerChaserAI.damage);
                }
                return null;
            }
        }, new MobLabelData("knockback"){

            @Override
            public String getDisplayData(Mob mob) {
                if (!mob.isHostile) {
                    return null;
                }
                if (mob.ai == null) {
                    return null;
                }
                AINode aiNode = mob.ai.tree;
                if (aiNode instanceof CollisionPlayerChaserWandererAI) {
                    CollisionPlayerChaserWandererAI hostileAiNode = (CollisionPlayerChaserWandererAI)aiNode;
                    if (hostileAiNode.collisionPlayerChaserAI == null) {
                        return null;
                    }
                    return String.valueOf(hostileAiNode.collisionPlayerChaserAI.knockback);
                }
                return null;
            }
        }};
    }

    public static abstract class MobLabelData {
        private final String name;

        public MobLabelData(String name) {
            this.name = name;
        }

        public int display(FormContentBox mobContent, Mob mob, int currentY) {
            String displayData = this.getDisplayData(mob);
            if (displayData != null) {
                mobContent.addComponent((FormComponent)new FormLabel(Localization.translate((String)"ui", (String)this.name) + ": " + this.getDisplayData(mob), new FontOptions(16), -1, 4, currentY));
                currentY += 18;
            }
            return currentY;
        }

        public abstract String getDisplayData(Mob var1);
    }
}

