/*
 * Decompiled with CFR 0.152.
 */
package quickrecipesmenu.menu.entries.single;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.stream.Collectors;
import necesse.engine.journal.JournalEntry;
import necesse.engine.registries.JournalRegistry;
import necesse.entity.mobs.hostile.witches.EvilWitchStartMob;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormContentBox;
import necesse.gfx.forms.components.FormLabel;
import necesse.gfx.forms.components.localComponents.FormLocalLabel;
import necesse.gfx.gameFont.FontOptions;
import necesse.inventory.item.Item;
import quickrecipesmenu.menu.MenuContainerForm;
import quickrecipesmenu.menu.entries.MenuEntry;
import quickrecipesmenu.menu.entries.show.ShowLevelComponent;
import quickrecipesmenu.menu.lists.CustomFormMobList;
import quickrecipesmenu.menu.lists.FormItemList;

public class SingleLevelEntry
extends MenuEntry {
    public static int journalEntryID;

    public SingleLevelEntry() {
        super(journalEntryID == -1 ? "unknownitem" : "entry." + JournalRegistry.getJournalEntryStringID((int)journalEntryID));
    }

    @Override
    public void updateContent(MenuContainerForm<?> mainForm, FormContentBox form) {
        if (journalEntryID != -1) {
            FormItemList itemList;
            CustomFormMobList mobList;
            FormContentBox levelContent = (FormContentBox)form.addComponent((FormComponent)new FormContentBox(0, 0, form.getWidth(), form.getHeight()));
            JournalEntry journalEntry = JournalRegistry.getJournalEntry((int)journalEntryID);
            int currentY = 6;
            levelContent.addComponent((FormComponent)new ShowLevelComponent(4, 8, journalEntryID));
            levelContent.addComponent((FormComponent)new FormLabel(journalEntry.getLocalization().translate(), new FontOptions(32), -1, 46, currentY));
            currentY += 48;
            ArrayList<JournalEntry.MobJournalData> friendlyMobs = new ArrayList<JournalEntry.MobJournalData>();
            ArrayList<JournalEntry.MobJournalData> hostileMobs = new ArrayList<JournalEntry.MobJournalData>();
            ArrayList<JournalEntry.MobJournalData> bosses = new ArrayList<JournalEntry.MobJournalData>();
            for (JournalEntry.MobJournalData mobData : journalEntry.mobsData) {
                if (mobData.mob.isBoss()) {
                    bosses.add(mobData);
                    continue;
                }
                if (mobData.mob.isHostile || mobData.mob instanceof EvilWitchStartMob) {
                    hostileMobs.add(mobData);
                    continue;
                }
                friendlyMobs.add(mobData);
            }
            if (!friendlyMobs.isEmpty()) {
                levelContent.addComponent((FormComponent)new FormLocalLabel("ui", "friendlymobs", new FontOptions(18), -1, 0, currentY));
                int rows = (int)Math.ceil((float)friendlyMobs.size() / 19.0f);
                int height = 32 + rows * 36;
                mobList = new CustomFormMobList(mainForm, 0, currentY += 20, form.getWidth(), height);
                levelContent.addComponent((FormComponent)mobList);
                mobList.setMobs(friendlyMobs.stream().map(i -> i.mob).collect(Collectors.toList()));
                currentY += height + 20;
            }
            if (!hostileMobs.isEmpty()) {
                levelContent.addComponent((FormComponent)new FormLocalLabel("ui", "hostilemobs", new FontOptions(18), -1, 0, currentY));
                int rows = (int)Math.ceil((float)hostileMobs.size() / 19.0f);
                int height = 32 + rows * 36;
                mobList = new CustomFormMobList(mainForm, 0, currentY += 20, form.getWidth(), height);
                levelContent.addComponent((FormComponent)mobList);
                mobList.setMobs(hostileMobs.stream().map(i -> i.mob).collect(Collectors.toList()));
                currentY += height + 20;
            }
            if (!bosses.isEmpty()) {
                levelContent.addComponent((FormComponent)new FormLocalLabel("ui", "bosses", new FontOptions(18), -1, 0, currentY));
                int rows = (int)Math.ceil((float)bosses.size() / 19.0f);
                int height = 32 + rows * 36;
                mobList = new CustomFormMobList(mainForm, 0, currentY += 20, form.getWidth(), height);
                levelContent.addComponent((FormComponent)mobList);
                mobList.setMobs(bosses.stream().map(i -> i.mob).collect(Collectors.toList()));
                currentY += height + 20;
            }
            ArrayList<Item> lootItems = new ArrayList<Item>();
            if (journalEntry.biomeLoot != null) {
                for (Item item : journalEntry.biomeLoot.getItems()) {
                    lootItems.add(item);
                }
            }
            if (!lootItems.isEmpty()) {
                levelContent.addComponent((FormComponent)new FormLocalLabel("ui", "loot", new FontOptions(18), -1, 0, currentY));
                int rows = (int)Math.ceil((float)lootItems.size() / 19.0f);
                int height = 32 + rows * 36;
                FormItemList itemList2 = new FormItemList(mainForm, 0, currentY += 20, form.getWidth(), height);
                levelContent.addComponent((FormComponent)itemList2);
                itemList2.setItems(lootItems);
                currentY += height + 20;
            }
            ArrayList<Item> treasures = new ArrayList<Item>();
            if (journalEntry.treasuresData != null) {
                for (Item item : journalEntry.treasuresData.getItems()) {
                    treasures.add(item);
                }
            }
            if (!treasures.isEmpty()) {
                levelContent.addComponent((FormComponent)new FormLocalLabel("ui", "treasures", new FontOptions(18), -1, 0, currentY));
                int rows = (int)Math.ceil((float)treasures.size() / 19.0f);
                int height = 32 + rows * 36;
                FormItemList itemList3 = new FormItemList(mainForm, 0, currentY += 20, form.getWidth(), height);
                levelContent.addComponent((FormComponent)itemList3);
                itemList3.setItems(treasures);
                currentY += height + 20;
            }
            ArrayList<Item> friendlyMobsLoot = new ArrayList<Item>();
            ArrayList<Item> hostileMobsLoot = new ArrayList<Item>();
            ArrayList<Item> bossesLoot = new ArrayList<Item>();
            for (JournalEntry.MobJournalData friendlyMob : friendlyMobs) {
                for (Item item : friendlyMob.itemDrops.getItems()) {
                    if (friendlyMobsLoot.contains(item)) continue;
                    friendlyMobsLoot.add(item);
                }
            }
            for (JournalEntry.MobJournalData hostileMob : hostileMobs) {
                for (Item item : hostileMob.itemDrops.getItems()) {
                    if (hostileMobsLoot.contains(item)) continue;
                    hostileMobsLoot.add(item);
                }
            }
            for (JournalEntry.MobJournalData boss : bosses) {
                for (Item item : boss.itemDrops.getItems()) {
                    if (bossesLoot.contains(item)) continue;
                    bossesLoot.add(item);
                }
            }
            if (!friendlyMobsLoot.isEmpty()) {
                levelContent.addComponent((FormComponent)new FormLocalLabel("ui", "friendlymobsloot", new FontOptions(18), -1, 0, currentY));
                int rows = (int)Math.ceil((float)friendlyMobsLoot.size() / 19.0f);
                int height = 32 + rows * 36;
                itemList = new FormItemList(mainForm, 0, currentY += 20, form.getWidth(), height);
                levelContent.addComponent((FormComponent)itemList);
                itemList.setItems(friendlyMobsLoot);
                currentY += height + 20;
            }
            if (!hostileMobsLoot.isEmpty()) {
                levelContent.addComponent((FormComponent)new FormLocalLabel("ui", "hostilemobsloot", new FontOptions(18), -1, 0, currentY));
                int rows = (int)Math.ceil((float)hostileMobsLoot.size() / 19.0f);
                int height = 32 + rows * 36;
                itemList = new FormItemList(mainForm, 0, currentY += 20, form.getWidth(), height);
                levelContent.addComponent((FormComponent)itemList);
                itemList.setItems(hostileMobsLoot);
                currentY += height + 20;
            }
            if (!bossesLoot.isEmpty()) {
                levelContent.addComponent((FormComponent)new FormLocalLabel("ui", "bossesloot", new FontOptions(18), -1, 0, currentY));
                int rows = (int)Math.ceil((float)bossesLoot.size() / 19.0f);
                int height = 32 + rows * 36;
                itemList = new FormItemList(mainForm, 0, currentY += 20, form.getWidth(), height);
                levelContent.addComponent((FormComponent)itemList);
                itemList.setItems(bossesLoot);
                currentY += height + 20;
            }
            levelContent.setContentBox(new Rectangle(0, 0, form.getWidth(), currentY));
        }
    }

    public static void showLevel(MenuContainerForm<?> mainForm, int journalEntryID) {
        SingleLevelEntry.journalEntryID = journalEntryID;
        MenuContainerForm.actualEntry = new SingleLevelEntry();
        MenuContainerForm.mainForm.updateContent();
        mainForm.updateEntries();
    }
}

