/*
 * Decompiled with CFR 0.152.
 */
package quickrecipesmenu.menu.entries.single;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import necesse.engine.journal.JournalEntry;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.registries.JournalRegistry;
import necesse.engine.registries.MobRegistry;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormContentBox;
import necesse.gfx.forms.components.FormLabel;
import necesse.gfx.forms.components.localComponents.FormLocalLabel;
import necesse.gfx.gameFont.FontOptions;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.recipe.Ingredient;
import necesse.inventory.recipe.Recipe;
import necesse.inventory.recipe.Recipes;
import quickrecipesmenu.QuickRecipesMenu;
import quickrecipesmenu.menu.MenuContainerForm;
import quickrecipesmenu.menu.entries.MenuEntry;
import quickrecipesmenu.menu.entries.show.ShowItemComponent;
import quickrecipesmenu.menu.lists.CustomFormIngredientRecipeList;
import quickrecipesmenu.menu.lists.CustomFormMobList;
import quickrecipesmenu.menu.lists.FormItemList;
import quickrecipesmenu.menu.lists.FormLevelList;

public class SingleItemEntry
extends MenuEntry {
    private static final Map<Integer, List<Integer>> itemDroppedByMobs = new HashMap<Integer, List<Integer>>();
    private static final Map<Integer, List<Integer>> itemFoundInJournal = new HashMap<Integer, List<Integer>>();
    public static int itemID = -1;

    public SingleItemEntry() {
        super(itemID == -1 ? "unknownitem" : "item." + ItemRegistry.getItemStringID((int)itemID));
    }

    @Override
    public void updateContent(MenuContainerForm<?> mainForm, FormContentBox form) {
        if (itemID != -1) {
            boolean findJournal;
            FormContentBox itemContent = (FormContentBox)form.addComponent((FormComponent)new FormContentBox(0, 0, form.getWidth(), form.getHeight()));
            Item item = ItemRegistry.getItem((int)itemID);
            int currentY = 6;
            itemContent.addComponent((FormComponent)new ShowItemComponent(4, 8, itemID));
            itemContent.addComponent((FormComponent)new FormLabel(item.getDisplayName(new InventoryItem(item)), new FontOptions(32), -1, 46, currentY));
            currentY += 48;
            List recipes = Recipes.getRecipesFromResultAndIngredient((int)itemID);
            if (!recipes.isEmpty()) {
                Recipe recipe2;
                itemContent.addComponent((FormComponent)new FormLocalLabel("ui", "crafting", new FontOptions(18), -1, 0, currentY));
                int rows = (int)Math.ceil((float)recipes.size() / 19.0f);
                int height = 32 + rows * 36;
                CustomFormIngredientRecipeList ingredientRecipeList = new CustomFormIngredientRecipeList(mainForm, 0, currentY += 20, form.getWidth(), height, this.client);
                itemContent.addComponent((FormComponent)ingredientRecipeList);
                ingredientRecipeList.setRecipes(recipes);
                currentY += height + 20;
                ArrayList<Item> ingredients = new ArrayList<Item>();
                List craftThisItem = recipes.stream().filter(recipe -> recipe.resultID == itemID).collect(Collectors.toList());
                Iterator iterator = craftThisItem.iterator();
                while (iterator.hasNext()) {
                    Item techItem;
                    recipe2 = (Recipe)iterator.next();
                    if (recipe2.tech == null || recipe2.tech.itemStringID == null) continue;
                    Object techID = recipe2.tech.itemStringID;
                    if (((String)techID).equals("workstation")) {
                        techID = "workstationduo";
                    } else if (((String)techID).equals("demonicworkstation")) {
                        techID = "demonicworkstationduo";
                    }
                    if ((techItem = ItemRegistry.getItem((String)techID)) == null || ingredients.contains(techItem)) continue;
                    ingredients.add(techItem);
                }
                iterator = craftThisItem.iterator();
                while (iterator.hasNext()) {
                    recipe2 = (Recipe)iterator.next();
                    for (Ingredient ingredient : recipe2.ingredients) {
                        if (ingredient.isGlobalIngredient()) {
                            for (Integer registeredItemID : ingredient.getGlobalIngredient().getRegisteredItemIDs()) {
                                Item globalIngredient = ItemRegistry.getItem((int)registeredItemID);
                                if (ingredients.contains(globalIngredient)) continue;
                                ingredients.add(globalIngredient);
                            }
                            continue;
                        }
                        if (ingredients.contains(ingredient.getDisplayItem())) continue;
                        ingredients.add(ingredient.getDisplayItem());
                    }
                }
                if (!ingredients.isEmpty()) {
                    itemContent.addComponent((FormComponent)new FormLocalLabel("ui", "ingredients", new FontOptions(18), -1, 0, currentY));
                    rows = (int)Math.ceil((float)ingredients.size() / 19.0f);
                    height = 32 + rows * 36;
                    FormItemList ingredientsList = new FormItemList(mainForm, 0, currentY += 20, form.getWidth(), height);
                    itemContent.addComponent((FormComponent)ingredientsList);
                    ingredientsList.setItems(ingredients);
                    currentY += height + 20;
                }
            }
            List<Integer> mobs = itemDroppedByMobs.get(itemID);
            List<Integer> journal = itemFoundInJournal.get(itemID);
            boolean findMobs = mobs == null;
            boolean bl = findJournal = journal == null;
            if (findMobs || findJournal) {
                if (findMobs) {
                    mobs = new ArrayList<Integer>();
                }
                if (findJournal) {
                    journal = new ArrayList<Integer>();
                }
                for (JournalEntry journalEntry : QuickRecipesMenu.journalEntriesByProgression()) {
                    if (findMobs) {
                        for (JournalEntry.MobJournalData mobData : journalEntry.mobsData) {
                            boolean dropsItem;
                            int mobID = mobData.mob.getID();
                            if (mobs.contains(mobID) || !(dropsItem = StreamSupport.stream(mobData.itemDrops.getItems().spliterator(), false).anyMatch(mobItem -> mobItem.getID() == itemID))) continue;
                            mobs.add(mobID);
                        }
                    }
                    if (!findJournal || (journalEntry.biomeLoot == null || !StreamSupport.stream(journalEntry.biomeLoot.getItems().spliterator(), false).anyMatch(mobItem -> mobItem.getID() == itemID)) && (journalEntry.treasuresData == null || !StreamSupport.stream(journalEntry.treasuresData.getItems().spliterator(), false).anyMatch(mobItem -> mobItem.getID() == itemID))) continue;
                    journal.add(journalEntry.getID());
                }
                if (findMobs) {
                    itemDroppedByMobs.put(itemID, mobs);
                }
                if (findJournal) {
                    itemFoundInJournal.put(itemID, journal);
                }
            }
            if (!mobs.isEmpty()) {
                itemContent.addComponent((FormComponent)new FormLocalLabel("ui", "droppedby", new FontOptions(18), -1, 0, currentY));
                int rows = (int)Math.ceil((float)mobs.size() / 19.0f);
                int height = 32 + rows * 36;
                CustomFormMobList mobList = new CustomFormMobList(mainForm, 0, currentY += 20, form.getWidth(), height);
                itemContent.addComponent((FormComponent)mobList);
                mobList.setMobs(mobs.stream().map(i -> MobRegistry.getMob((int)i, null)).collect(Collectors.toList()));
                currentY += height + 20;
            }
            if (!journal.isEmpty()) {
                itemContent.addComponent((FormComponent)new FormLocalLabel("ui", "foundin", new FontOptions(18), -1, 0, currentY));
                int rows = (int)Math.ceil((float)journal.size() / 19.0f);
                int height = 32 + rows * 36;
                FormLevelList levelList = new FormLevelList(mainForm, 0, currentY += 20, form.getWidth(), height){};
                itemContent.addComponent((FormComponent)levelList);
                levelList.setLevels(journal.stream().map(JournalRegistry::getJournalEntry).collect(Collectors.toList()));
                currentY += height + 20;
            }
            itemContent.setContentBox(new Rectangle(0, 0, form.getWidth(), currentY));
        }
    }

    public static void showItem(MenuContainerForm<?> mainForm, int itemID) {
        SingleItemEntry.itemID = itemID;
        MenuContainerForm.actualEntry = new SingleItemEntry();
        MenuContainerForm.mainForm.updateContent();
        mainForm.updateEntries();
    }
}

