/*
 * Decompiled with CFR 0.152.
 */
package quickrecipesmenu.menu.entries.show;

import java.awt.Rectangle;
import java.util.Objects;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.input.InputEvent;
import necesse.engine.journal.JournalEntry;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.registries.JournalRegistry;
import necesse.engine.util.LevelIdentifier;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.forms.components.FormContentBox;
import necesse.gfx.gameTexture.GameTexture;
import necesse.inventory.item.Item;
import quickrecipesmenu.menu.lists.FormLevelList;

public class ShowLevelComponent
extends FormContentBox {
    public int journalEntryID;

    public ShowLevelComponent(int x, int y, int journalEntryID) {
        super(x, y, 32, 32);
        this.journalEntryID = journalEntryID;
    }

    public void draw(TickManager tickManager, PlayerMob perspective, Rectangle renderBox) {
        JournalEntry journalEntry = JournalRegistry.getJournalEntry((int)this.journalEntryID);
        if (Objects.equals(journalEntry.getStringID(), "plainssurface")) {
            GameTexture.fromFile((String)"biomes/plains").initDraw().draw(4, 4);
            return;
        }
        if (journalEntry.incursionBiome != null) {
            journalEntry.incursionBiome.getTabletSprite().initDraw().draw(4, 4);
        } else if (journalEntry.biome != null) {
            if (journalEntry.levelIdentifier == LevelIdentifier.CAVE_IDENTIFIER || journalEntry.levelIdentifier == LevelIdentifier.DEEP_CAVE_IDENTIFIER) {
                GameTexture.fromFile((String)("biomes/" + journalEntry.biome.getStringID())).initDraw().draw(2, 2);
                Item item = journalEntry.levelIdentifier == LevelIdentifier.CAVE_IDENTIFIER ? ItemRegistry.getItem((String)"ladderdown") : ItemRegistry.getItem((String)"deepladderdown");
                item.getItemSprite(item.getDefaultItem(perspective, 1), perspective).initDraw().draw(10, 8);
            } else {
                GameTexture.fromFile((String)FormLevelList.otherLevelTextures.getOrDefault(journalEntry.getStringID(), "biomes/" + journalEntry.biome.getStringID())).initDraw().draw(2, 2);
            }
        }
    }

    public void handleInputEvent(InputEvent event, TickManager tickManager, PlayerMob perspective) {
        super.handleInputEvent(event, tickManager, perspective);
    }
}

