/*
 * Decompiled with CFR 0.152.
 */
package quickrecipesmenu.menu.entries.list;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import necesse.engine.input.InputEvent;
import necesse.engine.input.controller.ControllerInput;
import necesse.gfx.forms.components.FormContentBox;
import necesse.gfx.forms.components.lists.FormGeneralGridList;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.item.Item;
import necesse.inventory.item.ItemSearchTester;
import necesse.inventory.recipe.Ingredient;
import necesse.inventory.recipe.Recipe;
import necesse.inventory.recipe.Recipes;
import quickrecipesmenu.menu.MenuContainerForm;
import quickrecipesmenu.menu.entries.list.ItemsSearchEntry;
import quickrecipesmenu.menu.entries.single.SingleItemEntry;
import quickrecipesmenu.menu.lists.CustomFormIngredientRecipeList;

public class RecipesEntry
extends ItemsSearchEntry {
    public RecipesEntry() {
        super("recipes");
    }

    @Override
    public void updateFilter() {
        Stream<Recipe> recipeStream = Recipes.streamRecipes();
        String searchText = this.searchFilter.getText().toLowerCase();
        String searchModText = this.searchModFilter.getText().toLowerCase();
        ItemSearchTester tester = ItemSearchTester.constructSearchTester((String)searchText);
        recipeStream = recipeStream.filter(recipe -> {
            Ingredient[] var4;
            Item item = recipe.resultItem.item;
            if (this.incorrectMod(item, searchModText) || this.incorrectType(item) || this.incorrectName(item, tester)) {
                return false;
            }
            if (recipe.tech.displayName.translate().toLowerCase().contains(searchText)) {
                return true;
            }
            for (Ingredient ingredient : var4 = recipe.ingredients) {
                if (!ingredient.matchesSearch(this.client.getPlayer(), tester)) continue;
                return true;
            }
            return false;
        });
        this.getItemsList().setRecipes(recipeStream.collect(Collectors.toList()));
    }

    @Override
    public FormGeneralGridList<?> getItemsList(MenuContainerForm<?> mainForm, FormContentBox form, int x, int y, int width, int height) {
        return new CustomFormIngredientRecipeList(mainForm, x, y, width, height, this.client){

            @Override
            public void onRecipeClicked(Recipe recipe, InputEvent event) {
                SingleItemEntry.showItem(this.mainForm, recipe.resultID);
                this.playTickSound();
                ControllerInput.submitNextRefreshFocusEvent();
            }

            public void addTooltips(Recipe recipe, ListGameTooltips tooltips) {
                super.addTooltips(recipe, tooltips);
            }
        };
    }

    public CustomFormIngredientRecipeList getItemsList() {
        return (CustomFormIngredientRecipeList)this.itemsList;
    }
}

