/*
 * Decompiled with CFR 0.152.
 */
package quickrecipesmenu.menu.entries.list;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import necesse.engine.journal.JournalEntry;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.registries.MobRegistry;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.hostile.witches.EvilWitchStartMob;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormContentBox;
import necesse.gfx.forms.components.FormInputSize;
import necesse.gfx.forms.components.FormTextInput;
import necesse.gfx.forms.components.localComponents.FormLocalLabel;
import necesse.gfx.gameFont.FontOptions;
import quickrecipesmenu.QuickRecipesMenu;
import quickrecipesmenu.menu.MenuContainerForm;
import quickrecipesmenu.menu.entries.MenuEntry;
import quickrecipesmenu.menu.lists.CustomFormMobList;

public class MobsEntry
extends MenuEntry {
    public FormTextInput searchFilter;
    public FormContentBox mobsContent;
    public ArrayList<Integer> mobIDs = new ArrayList();

    public MobsEntry() {
        super("mobs");
    }

    public void updateFilter(MenuContainerForm<?> mainForm, FormContentBox form) {
        int height;
        int rows;
        this.mobsContent.clearComponents();
        if (this.mobIDs.isEmpty()) {
            for (JournalEntry journalEntry : QuickRecipesMenu.journalEntriesByProgression()) {
                for (JournalEntry.MobJournalData mobData : journalEntry.mobsData) {
                    int mobID = mobData.mob.getID();
                    if (this.mobIDs.contains(mobID)) continue;
                    this.mobIDs.add(mobID);
                }
            }
        }
        Stream<Mob> mobs = this.mobIDs.stream().map(m -> MobRegistry.getMob((int)m, null));
        String searchText = this.searchFilter.getText().toLowerCase();
        List mobsList = mobs.filter(mob -> this.correctName((Mob)mob, searchText)).collect(Collectors.toList());
        List<Mob> friendlyMobs = mobsList.stream().filter(m -> !m.isBoss() && !m.isHostile && !(m instanceof EvilWitchStartMob)).collect(Collectors.toList());
        List<Mob> hostileMobs = mobsList.stream().filter(m -> !m.isBoss() && (m.isHostile || m instanceof EvilWitchStartMob)).collect(Collectors.toList());
        List<Mob> bosses = mobsList.stream().filter(Mob::isBoss).collect(Collectors.toList());
        int currentY = 0;
        if (!friendlyMobs.isEmpty()) {
            this.mobsContent.addComponent((FormComponent)new FormLocalLabel("ui", "friendlymobs", new FontOptions(18), -1, 0, currentY));
            rows = (int)Math.ceil((float)friendlyMobs.size() / 19.0f);
            height = 32 + rows * 36;
            CustomFormMobList friendlyMobsList = new CustomFormMobList(mainForm, 0, currentY += 20, form.getWidth(), height);
            this.mobsContent.addComponent((FormComponent)friendlyMobsList);
            friendlyMobsList.setMobs(friendlyMobs);
            currentY += height + 20;
        }
        if (!hostileMobs.isEmpty()) {
            this.mobsContent.addComponent((FormComponent)new FormLocalLabel("ui", "hostilemobs", new FontOptions(18), -1, 0, currentY));
            rows = (int)Math.ceil((float)hostileMobs.size() / 19.0f);
            height = 32 + rows * 36;
            CustomFormMobList hostileMobsList = new CustomFormMobList(mainForm, 0, currentY += 20, form.getWidth(), height);
            this.mobsContent.addComponent((FormComponent)hostileMobsList);
            hostileMobsList.setMobs(hostileMobs);
            currentY += height + 20;
        }
        if (!bosses.isEmpty()) {
            this.mobsContent.addComponent((FormComponent)new FormLocalLabel("ui", "bosses", new FontOptions(18), -1, 0, currentY));
            rows = (int)Math.ceil((float)bosses.size() / 19.0f);
            height = 32 + rows * 36;
            CustomFormMobList bossesList = new CustomFormMobList(mainForm, 0, currentY += 20, form.getWidth(), height);
            this.mobsContent.addComponent((FormComponent)bossesList);
            bossesList.setMobs(bosses);
            currentY += height + 20;
        }
        if (currentY == 0) {
            this.mobsContent.addComponent((FormComponent)new FormLocalLabel("ui", "nomobs", new FontOptions(18), -1, 0, currentY));
            currentY += 20;
        }
        this.mobsContent.setContentBox(new Rectangle(0, 0, form.getWidth(), currentY));
    }

    public boolean correctName(Mob mob, String searchText) {
        return mob.getStringID().contains(searchText) || mob.getDisplayName().contains(searchText);
    }

    @Override
    public void updateContent(MenuContainerForm<?> mainForm, FormContentBox form) {
        this.mobsContent = (FormContentBox)form.addComponent((FormComponent)new FormContentBox(0, 0, form.getWidth(), form.getHeight() - 40));
        this.searchFilter = (FormTextInput)form.addComponent((FormComponent)new FormTextInput(0, form.getHeight() - 40, FormInputSize.SIZE_32_TO_40, form.getWidth(), 50));
        this.searchFilter.placeHolder = new LocalMessage("ui", "searchtip");
        this.searchFilter.rightClickToClear = true;
        this.searchFilter.onChange(event -> this.updateFilter(mainForm, form));
        this.updateFilter(mainForm, form);
    }
}

