/*
 * Decompiled with CFR 0.152.
 */
package quickrecipesmenu.menu.entries.list;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import necesse.engine.localization.Localization;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.modLoader.LoadedMod;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.util.GameBlackboard;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormContentBox;
import necesse.gfx.forms.components.FormContentIconButton;
import necesse.gfx.forms.components.FormFlow;
import necesse.gfx.forms.components.FormInputSize;
import necesse.gfx.forms.components.FormTextInput;
import necesse.gfx.forms.components.lists.FormGeneralGridList;
import necesse.gfx.gameTooltips.GameTooltips;
import necesse.gfx.gameTooltips.StringTooltips;
import necesse.gfx.ui.ButtonColor;
import necesse.gfx.ui.ButtonTexture;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.ItemSearchTester;
import necesse.inventory.item.armorItem.ArmorItem;
import necesse.inventory.item.miscItem.VinylItem;
import necesse.inventory.item.placeableItem.StonePlaceableItem;
import necesse.inventory.item.placeableItem.consumableItem.ConsumableItem;
import necesse.inventory.item.placeableItem.objectItem.ObjectItem;
import necesse.inventory.item.placeableItem.tileItem.TileItem;
import quickrecipesmenu.QuickRecipesMenu;
import quickrecipesmenu.menu.MenuContainerForm;
import quickrecipesmenu.menu.entries.MenuEntry;

public abstract class ItemsSearchEntry
extends MenuEntry {
    public FormTextInput searchFilter;
    public FormTextInput searchModFilter;
    public FormGeneralGridList<?> itemsList;
    public static ItemsFilterButton[] baseItemsFilterButtons = new ItemsFilterButton[]{new ItemsFilterButton("all", (ButtonTexture)QuickRecipesMenu.ALL_ITEMS_FILTER), new ItemsFilterButton("mat", (ButtonTexture)QuickRecipesMenu.MAT_ITEMS_FILTER), new ItemsFilterButton("weapon-melee", (ButtonTexture)QuickRecipesMenu.MELEE_WEAPONS_FILTER), new ItemsFilterButton("weapon-range", (ButtonTexture)QuickRecipesMenu.RANGE_WEAPONS_FILTER), new ItemsFilterButton("weapon-magic", (ButtonTexture)QuickRecipesMenu.MAGIC_WEAPONS_FILTER), new ItemsFilterButton("weapon-summon", (ButtonTexture)QuickRecipesMenu.SUMMON_WEAPONS_FILTER), new ItemsFilterButton("weapon-other", (ButtonTexture)QuickRecipesMenu.OTHER_WEAPONS_FILTER), new ItemsFilterButton("tool", (ButtonTexture)QuickRecipesMenu.TOOL_ITEMS_FILTER), new ItemsFilterButton("armor", (ButtonTexture)QuickRecipesMenu.ARMOR_ITEMS_FILTER), new ItemsFilterButton("cosmetic", (ButtonTexture)QuickRecipesMenu.COSMETIC_ITEMS_FILTER), new ItemsFilterButton("trinket", (ButtonTexture)QuickRecipesMenu.TRINKET_ITEMS_FILTER), new ItemsFilterButton("mount", (ButtonTexture)QuickRecipesMenu.MOUNT_ITEMS_FILTER), new ItemsFilterButton("arrow", (ButtonTexture)QuickRecipesMenu.ARROW_ITEMS_FILTER), new ItemsFilterButton("bullet", (ButtonTexture)QuickRecipesMenu.BULLET_ITEMS_FILTER), new ItemsFilterButton("seed", (ButtonTexture)QuickRecipesMenu.SEED_ITEMS_FILTER), new ItemsFilterButton("bait", (ButtonTexture)QuickRecipesMenu.BAIT_ITEMS_FILTER), new ItemsFilterButton("food", (ButtonTexture)QuickRecipesMenu.FOOD_ITEMS_FILTER), new ItemsFilterButton("consumable", (ButtonTexture)QuickRecipesMenu.CONSUMABLE_ITEMS_FILTER), new ItemsFilterButton("quest", (ButtonTexture)QuickRecipesMenu.QUEST_ITEMS_FILTER), new ItemsFilterButton("misc", (ButtonTexture)QuickRecipesMenu.MISC_ITEMS_FILTER), new ItemsFilterButton("object", (ButtonTexture)QuickRecipesMenu.OBJECT_ITEMS_FILTER), new ItemsFilterButton("tile", (ButtonTexture)QuickRecipesMenu.TILE_ITEMS_FILTER), new ItemsFilterButton("vinyl", (ButtonTexture)QuickRecipesMenu.VINYL_ITEMS_FILTER)};
    public static Map<String, FormContentIconButton> itemsFilterButtons = new HashMap<String, FormContentIconButton>();
    public static String selectedButtonFilter = "all";

    public ItemsSearchEntry(String name) {
        super(name);
    }

    @Override
    public void updateContent(MenuContainerForm<?> mainForm, FormContentBox form) {
        this.itemsList = this.getItemsList(mainForm, form, 0, 4, form.getWidth() - 105, form.getHeight() - 74);
        form.addComponent(this.itemsList);
        this.searchFilter = (FormTextInput)form.addComponent((FormComponent)new FormTextInput(0, form.getHeight() - 74, FormInputSize.SIZE_32_TO_40, form.getWidth() - 105, 50));
        this.searchFilter.placeHolder = new LocalMessage("ui", "searchtip");
        this.searchFilter.rightClickToClear = true;
        this.searchFilter.onChange(event -> this.updateFilter());
        this.searchModFilter = (FormTextInput)form.addComponent((FormComponent)new FormTextInput(0, form.getHeight() - 40, FormInputSize.SIZE_32_TO_40, form.getWidth() - 105, 50));
        this.searchModFilter.placeHolder = new LocalMessage("ui", "searchmodtip");
        this.searchModFilter.rightClickToClear = true;
        this.searchModFilter.onChange(event -> this.updateFilter());
        FormFlow iconFlow = new FormFlow(0);
        AtomicInteger inColumn = new AtomicInteger();
        AtomicInteger column = new AtomicInteger();
        Arrays.stream(baseItemsFilterButtons).forEach(itemFilterButton -> {
            int actualColumn = column.get();
            int actualInRow = inColumn.get();
            if (inColumn.get() >= 12) {
                column.set(++actualColumn);
                actualInRow = 1;
                inColumn.set(actualInRow);
                iconFlow.next(-iconFlow.next());
            } else {
                inColumn.set(++actualInRow);
            }
            itemsFilterButtons.put(itemFilterButton.id, (FormContentIconButton)(form.addComponent((FormComponent)new FormContentIconButton(form.getWidth() - 90 + actualColumn * 40, iconFlow.next(34) + 10, FormInputSize.SIZE_32, ButtonColor.BASE, itemFilterButton.icon, new GameMessage[0], (ItemsFilterButton)itemFilterButton){
                final /* synthetic */ ItemsFilterButton val$itemFilterButton;
                {
                    this.val$itemFilterButton = itemsFilterButton;
                    super(arg0, arg1, arg2, arg3, arg4, arg5);
                }

                public GameTooltips getTooltips(PlayerMob perspective) {
                    return new StringTooltips(Localization.translate((String)"ui", (String)(this.val$itemFilterButton.id + "itemsfilter")));
                }
            })).onClicked(button -> {
                ItemsSearchEntry.itemsFilterButtons.get((Object)ItemsSearchEntry.selectedButtonFilter).color = ButtonColor.BASE;
                selectedButtonFilter = itemFilterButton.id;
                ItemsSearchEntry.itemsFilterButtons.get((Object)ItemsSearchEntry.selectedButtonFilter).color = ButtonColor.GREEN;
                this.updateFilter();
            }));
        });
        ItemsSearchEntry.itemsFilterButtons.get((Object)ItemsSearchEntry.selectedButtonFilter).color = ButtonColor.GREEN;
        this.updateFilter();
    }

    public abstract void updateFilter();

    public boolean incorrectType(Item item) {
        if (Objects.equals(selectedButtonFilter, "all")) {
            return false;
        }
        if (item instanceof StonePlaceableItem) {
            return !Objects.equals(selectedButtonFilter, "mat");
        }
        if (Objects.equals(selectedButtonFilter, "tool") || selectedButtonFilter.startsWith("weapon-")) {
            return QuickRecipesMenu.isNotRequiredToolType(selectedButtonFilter, item);
        }
        if (Objects.equals(selectedButtonFilter, "armor") || Objects.equals(selectedButtonFilter, "cosmetic")) {
            if (!(item instanceof ArmorItem)) {
                return true;
            }
            return QuickRecipesMenu.isCosmetic((ArmorItem)item, new InventoryItem(item)) != Objects.equals(selectedButtonFilter, "cosmetic");
        }
        if (Arrays.asList(QuickRecipesMenu.miscSeparatedItems).contains(selectedButtonFilter)) {
            if (item.type != Item.Type.MISC) {
                return true;
            }
            if (item instanceof ConsumableItem) {
                return !Objects.equals(selectedButtonFilter, "consumable");
            }
            if (item instanceof ObjectItem) {
                return !Objects.equals(selectedButtonFilter, "object");
            }
            if (item instanceof TileItem) {
                return !Objects.equals(selectedButtonFilter, "tile");
            }
            if (item instanceof VinylItem) {
                return !Objects.equals(selectedButtonFilter, "vinyl");
            }
            return !Objects.equals(selectedButtonFilter, "misc");
        }
        return item.type != Item.Type.valueOf((String)selectedButtonFilter.toUpperCase());
    }

    public boolean incorrectName(Item item, ItemSearchTester tester) {
        return !tester.matches(item.getDefaultItem(this.client.getPlayer(), 1), this.client.getPlayer(), new GameBlackboard());
    }

    public boolean incorrectMod(Item item, String searchModText) {
        LoadedMod mod = ItemRegistry.getItemMod((int)item.getID());
        if (mod == null) {
            return !"vanilla".contains(searchModText);
        }
        return !mod.id.contains(searchModText);
    }

    public abstract FormGeneralGridList<?> getItemsList(MenuContainerForm<?> var1, FormContentBox var2, int var3, int var4, int var5, int var6);

    public static class ItemsFilterButton {
        String id;
        ButtonTexture icon;

        public ItemsFilterButton(String id, ButtonTexture icon) {
            this.id = id;
            this.icon = icon;
        }
    }
}

