/*
 * Decompiled with CFR 0.152.
 */
package quickrecipesmenu.menu;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import necesse.engine.Settings;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.client.Client;
import necesse.engine.window.GameWindow;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.GameResources;
import necesse.gfx.forms.Form;
import necesse.gfx.forms.components.FormBreakLine;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormComponentList;
import necesse.gfx.forms.components.FormContentBox;
import necesse.gfx.forms.components.FormTextButton;
import necesse.gfx.forms.components.localComponents.FormLocalTextButton;
import necesse.gfx.forms.presets.containerComponent.ContainerFormSwitcher;
import necesse.gfx.gameFont.FontManager;
import necesse.gfx.gameFont.FontOptions;
import necesse.gfx.shader.FormShader;
import quickrecipesmenu.menu.MenuContainer;
import quickrecipesmenu.menu.entries.MenuEntry;
import quickrecipesmenu.menu.entries.list.ItemsEntry;
import quickrecipesmenu.menu.entries.list.LevelsEntry;
import quickrecipesmenu.menu.entries.list.MobsEntry;
import quickrecipesmenu.menu.entries.list.RecipesEntry;

public class MenuContainerForm<T extends MenuContainer>
extends ContainerFormSwitcher<T> {
    public Client client;
    private final Form principalForm;
    public static final MenuEntry[] menuEntries = new MenuEntry[]{new ItemsEntry(), new RecipesEntry(), new MobsEntry(), new LevelsEntry()};
    public static MenuEntry actualEntry = menuEntries[0];
    public FormContentBox entries;
    public FormContentBox entryContent;
    public static MenuContainerForm<? extends MenuContainer> mainForm;

    public MenuContainerForm(Client client, T container) {
        super(client, container);
        mainForm = this;
        this.client = client;
        FormComponentList formComponents = (FormComponentList)this.addComponent((FormComponent)new FormComponentList());
        this.principalForm = (Form)formComponents.addComponent((FormComponent)new Form(925, 500));
        this.entries = (FormContentBox)this.principalForm.addComponent((FormComponent)new FormContentBox(0, 10, 190, this.principalForm.getHeight() - 75));
        FormBreakLine middleVerticalLine = (FormBreakLine)this.principalForm.addComponent((FormComponent)new FormBreakLine(FormBreakLine.ALIGN_BEGINNING, this.entries.getWidth() + 10, this.entries.getY(), this.principalForm.getHeight() - 55, false));
        middleVerticalLine.color = Settings.UI.activeTextColor;
        this.entryContent = (FormContentBox)this.principalForm.addComponent((FormComponent)new FormContentBox(this.entries.getWidth() + 20, 10, 925 - this.entries.getWidth() - 20, this.principalForm.getHeight() - 60));
        ((FormLocalTextButton)this.principalForm.addComponent((FormComponent)new FormLocalTextButton("ui", "closebutton", 4, this.principalForm.getHeight() - 40, this.principalForm.getWidth() - 8))).onClicked(e -> client.closeContainer(true));
        this.makeCurrent((FormComponent)formComponents);
        this.updateEntries();
        this.updateContent();
    }

    public void updateEntries() {
        this.entries.clearComponents();
        ArrayList showEntries = Arrays.stream(menuEntries).collect(Collectors.toCollection(ArrayList::new));
        if (showEntries.stream().noneMatch(entry -> Objects.equals(entry.name, MenuContainerForm.actualEntry.name))) {
            showEntries.add(actualEntry);
        }
        for (int i = 0; i < showEntries.size(); ++i) {
            final MenuEntry menuEntry = (MenuEntry)showEntries.get(i);
            this.entries.addComponent((FormComponent)new FormTextButton(menuEntry.getDisplayName(), 6, 6 + i * 36, 178){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void draw(TickManager tickManager, PlayerMob perspective, Rectangle renderBox) {
                    Rectangle contentRect = this.size.getContentRectangle(this.getWidth());
                    FormShader.FormShaderState textState = GameResources.formShader.startState(new Point(this.getX(), this.getY()), new Rectangle(contentRect.x, contentRect.y, contentRect.width, contentRect.height));
                    try {
                        FontOptions fontOptions = this.size.getFontOptions().color(this.getTextColor());
                        if (!Objects.equals(MenuContainerForm.actualEntry.name, menuEntry.name)) {
                            if (this.isHovering()) {
                                fontOptions.alpha(204);
                            } else {
                                fontOptions.alpha(153);
                            }
                        }
                        String drawText = this.getDrawText();
                        int drawX = this.getWidth() / 2 - FontManager.bit.getWidthCeil(drawText, fontOptions) / 2;
                        FontManager.bit.drawString((float)drawX, (float)this.size.fontDrawOffset, drawText, fontOptions);
                    }
                    finally {
                        textState.end();
                    }
                    if (this.isHovering()) {
                        this.addTooltips(perspective);
                    }
                }
            }.onClicked(e -> {
                actualEntry = menuEntry;
                this.updateContent();
            }));
        }
        this.entries.setContentBox(new Rectangle(this.entries.getX(), this.entries.getY(), this.entries.getWidth(), 12 + showEntries.size() * 36));
    }

    public void updateContent() {
        this.entryContent.clearComponents();
        MenuContainerForm.actualEntry.client = this.client;
        actualEntry.updateContent(this, this.entryContent);
    }

    public void onWindowResized(GameWindow window) {
        super.onWindowResized(window);
        this.principalForm.setPosMiddle(window.getHudWidth() / 2, window.getHudHeight() / 2);
    }

    public boolean shouldOpenInventory() {
        return false;
    }

    public boolean shouldShowToolbar() {
        return false;
    }
}

