/*
 * Decompiled with CFR 0.152.
 */
package quickrecipesmenu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import necesse.engine.GlobalData;
import necesse.engine.Settings;
import necesse.engine.input.Control;
import necesse.engine.input.InputEvent;
import necesse.engine.journal.JournalEntry;
import necesse.engine.modLoader.annotations.ModEntry;
import necesse.engine.network.NetworkClient;
import necesse.engine.network.Packet;
import necesse.engine.network.client.Client;
import necesse.engine.registries.ContainerRegistry;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.registries.JournalRegistry;
import necesse.engine.registries.PacketRegistry;
import necesse.engine.state.MainGame;
import necesse.entity.mobs.gameDamageType.DamageType;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.ui.ButtonIcon;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.armorItem.ArmorItem;
import necesse.inventory.item.toolItem.ToolDamageItem;
import necesse.inventory.item.toolItem.ToolItem;
import necesse.inventory.item.toolItem.miscToolItem.NetToolItem;
import quickrecipesmenu.menu.MenuContainer;
import quickrecipesmenu.menu.MenuContainerForm;
import quickrecipesmenu.menu.MenuPacket;
import quickrecipesmenu.menu.entries.list.ItemsEntry;
import quickrecipesmenu.menu.entries.list.RecipesEntry;

@ModEntry
public class QuickRecipesMenu {
    public static int MENU_CONTAINER;
    public static ButtonIcon ALL_ITEMS_FILTER;
    public static ButtonIcon MAT_ITEMS_FILTER;
    public static ButtonIcon MELEE_WEAPONS_FILTER;
    public static ButtonIcon RANGE_WEAPONS_FILTER;
    public static ButtonIcon MAGIC_WEAPONS_FILTER;
    public static ButtonIcon SUMMON_WEAPONS_FILTER;
    public static ButtonIcon OTHER_WEAPONS_FILTER;
    public static ButtonIcon TOOL_ITEMS_FILTER;
    public static ButtonIcon ARMOR_ITEMS_FILTER;
    public static ButtonIcon COSMETIC_ITEMS_FILTER;
    public static ButtonIcon TRINKET_ITEMS_FILTER;
    public static ButtonIcon MOUNT_ITEMS_FILTER;
    public static ButtonIcon ARROW_ITEMS_FILTER;
    public static ButtonIcon BULLET_ITEMS_FILTER;
    public static ButtonIcon SEED_ITEMS_FILTER;
    public static ButtonIcon BAIT_ITEMS_FILTER;
    public static ButtonIcon FOOD_ITEMS_FILTER;
    public static ButtonIcon CONSUMABLE_ITEMS_FILTER;
    public static ButtonIcon QUEST_ITEMS_FILTER;
    public static ButtonIcon MISC_ITEMS_FILTER;
    public static ButtonIcon OBJECT_ITEMS_FILTER;
    public static ButtonIcon TILE_ITEMS_FILTER;
    public static ButtonIcon VINYL_ITEMS_FILTER;
    public static GameTexture QUICK_RECIPES_BOOK;
    public static String[] miscSeparatedItems;
    public static List<String> progression;

    public void init() {
        MENU_CONTAINER = ContainerRegistry.registerContainer((client, uniqueSeed, content) -> new MenuContainerForm<MenuContainer>(client, new MenuContainer((NetworkClient)client.getClient(), uniqueSeed)), (client, uniqueSeed, content, serverObject) -> new MenuContainer((NetworkClient)client, uniqueSeed));
        PacketRegistry.registerPacket(MenuPacket.class);
        Control.addModControl((Control)new Control(79, "openitemsmenu"){

            public void activate(InputEvent event) {
                super.activate(event);
                MenuContainerForm.actualEntry = new ItemsEntry();
                if (this.isPressed()) {
                    Client client = ((MainGame)GlobalData.getCurrentState()).getClient();
                    client.network.sendPacket((Packet)new MenuPacket());
                }
            }
        });
        Control.addModControl((Control)new Control(80, "openrecipesmenu"){

            public void activate(InputEvent event) {
                super.activate(event);
                MenuContainerForm.actualEntry = new RecipesEntry();
                if (this.isPressed()) {
                    Client client = ((MainGame)GlobalData.getCurrentState()).getClient();
                    client.network.sendPacket((Packet)new MenuPacket());
                }
            }
        });
    }

    public void initResources() {
        ALL_ITEMS_FILTER = new ButtonIcon(Settings.UI, "allitems");
        MAT_ITEMS_FILTER = new ButtonIcon(Settings.UI, "matitems");
        MELEE_WEAPONS_FILTER = new ButtonIcon(Settings.UI, "meleeweapons");
        RANGE_WEAPONS_FILTER = new ButtonIcon(Settings.UI, "rangeweapons");
        MAGIC_WEAPONS_FILTER = new ButtonIcon(Settings.UI, "magicweapons");
        SUMMON_WEAPONS_FILTER = new ButtonIcon(Settings.UI, "summonweapons");
        OTHER_WEAPONS_FILTER = new ButtonIcon(Settings.UI, "otherweapons");
        TOOL_ITEMS_FILTER = new ButtonIcon(Settings.UI, "toolitems");
        ARMOR_ITEMS_FILTER = new ButtonIcon(Settings.UI, "armoritems");
        COSMETIC_ITEMS_FILTER = new ButtonIcon(Settings.UI, "cosmeticitems");
        TRINKET_ITEMS_FILTER = new ButtonIcon(Settings.UI, "trinketitems");
        MOUNT_ITEMS_FILTER = new ButtonIcon(Settings.UI, "mountitems");
        ARROW_ITEMS_FILTER = new ButtonIcon(Settings.UI, "arrowitems");
        BULLET_ITEMS_FILTER = new ButtonIcon(Settings.UI, "bulletitems");
        SEED_ITEMS_FILTER = new ButtonIcon(Settings.UI, "seeditems");
        BAIT_ITEMS_FILTER = new ButtonIcon(Settings.UI, "baititems");
        FOOD_ITEMS_FILTER = new ButtonIcon(Settings.UI, "fooditems");
        CONSUMABLE_ITEMS_FILTER = new ButtonIcon(Settings.UI, "consumableitems");
        QUEST_ITEMS_FILTER = new ButtonIcon(Settings.UI, "questitems");
        MISC_ITEMS_FILTER = new ButtonIcon(Settings.UI, "miscitems");
        OBJECT_ITEMS_FILTER = new ButtonIcon(Settings.UI, "objectitems");
        TILE_ITEMS_FILTER = new ButtonIcon(Settings.UI, "tileitems");
        VINYL_ITEMS_FILTER = new ButtonIcon(Settings.UI, "vinylitems");
        QUICK_RECIPES_BOOK = GameTexture.fromFile((String)"ui/quickrecipesbook");
    }

    public void postInit() {
    }

    public static boolean isNotRequiredToolType(String requiredType, Item item) {
        return QuickRecipesMenu.isNotRequiredToolType(requiredType, new InventoryItem(item));
    }

    public static boolean isNotRequiredToolType(String requiredType, InventoryItem item) {
        return !(item.item instanceof ToolItem) || !QuickRecipesMenu.getToolType((ToolItem)item.item, item).equals(requiredType);
    }

    public static String getToolType(ToolItem toolItem, InventoryItem item) {
        if (toolItem instanceof ToolDamageItem || toolItem instanceof NetToolItem) {
            return "tool";
        }
        DamageType damageType = toolItem.getDamageType(item);
        if (damageType == DamageTypeRegistry.MELEE) {
            return "weapon-melee";
        }
        if (damageType == DamageTypeRegistry.RANGED) {
            return "weapon-range";
        }
        if (damageType == DamageTypeRegistry.MAGIC) {
            return "weapon-magic";
        }
        if (damageType == DamageTypeRegistry.SUMMON) {
            return "weapon-summon";
        }
        return "weapon-other";
    }

    public static boolean isCosmetic(ArmorItem armorItem) {
        return QuickRecipesMenu.isCosmetic(armorItem, new InventoryItem((Item)armorItem));
    }

    public static boolean isCosmetic(ArmorItem armorItem, InventoryItem item) {
        return armorItem.getFlatArmorValue(item) == 0;
    }

    public static List<JournalEntry> journalEntriesByProgression() {
        ArrayList<JournalEntry> journalEntryList = new ArrayList<JournalEntry>();
        for (JournalEntry journalEntry : JournalRegistry.getJournalEntries()) {
            journalEntryList.add(journalEntry);
        }
        journalEntryList.sort((o1, o2) -> {
            int n2;
            int n1 = progression.indexOf(o1.getStringID());
            if (n1 == (n2 = progression.indexOf(o2.getStringID()))) {
                return 0;
            }
            if (n1 == -1) {
                return 1;
            }
            if (n2 == -1) {
                return -1;
            }
            return n1 - n2;
        });
        return journalEntryList;
    }

    static {
        miscSeparatedItems = new String[]{"misc", "consumable", "object", "tile", "vinyl"};
        progression = Arrays.stream(new String[]{"forestsurface", "plainssurface", "snowsurface", "swampsurface", "desertsurface", "forestcave", "snowcave", "dungeon", "plainscave", "swampcave", "desertcave", "forestpiratevillage", "forestdeepcave", "plainsdeepcave", "snowdeepcave", "swampdeepcave", "desertdeepcave", "temple"}).collect(Collectors.toList());
    }
}

