/*
 * Decompiled with CFR 0.152.
 */
package recraft.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import necesse.engine.GlobalData;
import necesse.engine.localization.Localization;
import necesse.engine.network.client.Client;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.registries.ObjectRegistry;
import necesse.engine.registries.RecipeTechRegistry;
import necesse.engine.registries.TileRegistry;
import necesse.engine.state.MainGame;
import necesse.engine.state.State;
import necesse.gfx.fairType.FairGlyph;
import necesse.gfx.fairType.FairItemGlyph;
import necesse.gfx.fairType.FairSpacerGlyph;
import necesse.gfx.fairType.FairType;
import necesse.gfx.gameFont.FontOptions;
import necesse.inventory.InventoryItem;
import recraft.items.ShredderJaws;

public class Helper {
    public static Map<ShredderJaws.ShredderType, String> jawTypeToItemNames = new HashMap<ShredderJaws.ShredderType, String>();

    public static FairType itemToFairType(FontOptions fontOptions, String itemId) {
        FairType fairType = new FairType();
        InventoryItem item = ItemRegistry.getItem((String)itemId).getDefaultItem(null, 1);
        fairType.append(new FairGlyph[]{new FairItemGlyph(fontOptions.getSize(), item)});
        fairType.append(new FairGlyph[]{new FairSpacerGlyph(5.0f, 2.0f)});
        fairType.append(fontOptions, Localization.translate((String)"item", (String)itemId));
        return fairType;
    }

    public static FairType itemPlusItemsToFairType(FontOptions fontOptions, String firstItemId, List<String> itemIds) {
        FairType fairType = new FairType();
        if (firstItemId != null) {
            fairType.append(fontOptions, Localization.translate((String)"itemtooltip", (String)"shredslike"));
            fairType.append(new FairGlyph[]{new FairSpacerGlyph(5.0f, 2.0f)});
            InventoryItem firstItem = ItemRegistry.getItem((String)firstItemId).getDefaultItem(null, 1);
            fairType.append(new FairGlyph[]{new FairItemGlyph(fontOptions.getSize(), firstItem)});
            fairType.append(new FairGlyph[]{new FairSpacerGlyph(5.0f, 2.0f)});
            if (!itemIds.isEmpty()) {
                fairType.append(fontOptions, "+");
                fairType.append(new FairGlyph[]{new FairSpacerGlyph(5.0f, 2.0f)});
            }
        } else {
            fairType.append(fontOptions, Localization.translate((String)"itemtooltip", (String)"shreds"));
            fairType.append(new FairGlyph[]{new FairSpacerGlyph(5.0f, 2.0f)});
        }
        itemIds.forEach(itemId -> {
            InventoryItem item = ItemRegistry.getItem((String)itemId).getDefaultItem(null, 1);
            fairType.append(new FairGlyph[]{new FairItemGlyph(fontOptions.getSize(), item)});
        });
        return fairType;
    }

    public static Client getClient() {
        State gameState = GlobalData.getCurrentState();
        if (gameState instanceof MainGame) {
            MainGame mainGame = (MainGame)GlobalData.getCurrentState();
            return mainGame.getClient();
        }
        return null;
    }

    public static String getDisassemblerIdForJaws(ShredderJaws.ShredderType type) {
        switch (type) {
            case PAPER: 
            case WOODEN: 
            case COPPER: {
                return "light_disassembler";
            }
            case IRON: 
            case GOLDEN: {
                return "disassembler";
            }
            case DEMONIC: 
            case IVY: 
            case QUARTZ: {
                return "heavy_disassembler";
            }
            case TUNGSTEN: 
            case GLACIAL: 
            case MYCELIUM: {
                return "ancient_disassembler";
            }
        }
        return "disassembler";
    }

    public static boolean techExists(String techName) {
        try {
            RecipeTechRegistry.getTech((String)techName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean tileExists(String tileName) {
        try {
            TileRegistry.getTile((String)tileName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean objectExists(String objectName) {
        try {
            ObjectRegistry.getObject((String)objectName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        jawTypeToItemNames.put(ShredderJaws.ShredderType.PAPER, "papershredderjaws");
        jawTypeToItemNames.put(ShredderJaws.ShredderType.WOODEN, "woodenshredderjaws");
        jawTypeToItemNames.put(ShredderJaws.ShredderType.COPPER, "coppershredderjaws");
        jawTypeToItemNames.put(ShredderJaws.ShredderType.IRON, "ironshredderjaws");
        jawTypeToItemNames.put(ShredderJaws.ShredderType.GOLDEN, "goldenshredderjaws");
        jawTypeToItemNames.put(ShredderJaws.ShredderType.DEMONIC, "demonicshredderjaws");
        jawTypeToItemNames.put(ShredderJaws.ShredderType.IVY, "ivyshredderjaws");
        jawTypeToItemNames.put(ShredderJaws.ShredderType.QUARTZ, "quartzshredderjaws");
        jawTypeToItemNames.put(ShredderJaws.ShredderType.TUNGSTEN, "tungstenshredderjaws");
        jawTypeToItemNames.put(ShredderJaws.ShredderType.GLACIAL, "glacialshredderjaws");
        jawTypeToItemNames.put(ShredderJaws.ShredderType.MYCELIUM, "myceliumshredderjaws");
    }
}

