/*
 * Decompiled with CFR 0.152.
 */
package recraft.recipes;

import necesse.engine.registries.RecipeTechRegistry;
import necesse.inventory.recipe.Ingredient;
import necesse.inventory.recipe.Recipe;
import necesse.inventory.recipe.Recipes;
import recraft.recipes.DisassemblerRecipes;

public class RecraftRecipes {
    private static final int BARS_FOR_BROKEN_LOW_JAWS = 4;
    private static final int BARS_FOR_BROKEN_HIGH_JAWS = 5;

    public static void registerRecipes() {
        DisassemblerRecipes.registerRecipes();
        RecraftRecipes.registerNewMachines();
        RecraftRecipes.registerBrokenTools();
        RecraftRecipes.registerShredderJaws();
        Recipes.registerModRecipe((Recipe)new Recipe("acid", 1, RecipeTechRegistry.COMPOST_BIN, Recipes.ingredientsFromScript((String)"{{batwing, 5}}")));
        Recipes.registerModRecipe((Recipe)new Recipe("acid", 1, RecipeTechRegistry.COMPOST_BIN, Recipes.ingredientsFromScript((String)"{{cavespidergland, 5}}")));
        Recipes.registerModRecipe((Recipe)new Recipe("acid", 1, RecipeTechRegistry.COMPOST_BIN, new Ingredient[]{new Ingredient("zombie_part", 5)}));
        Recipes.registerModRecipe((Recipe)new Recipe("goldbar", 1, RecipeTechRegistry.FORGE, Recipes.ingredientsFromScript((String)"{{coin, 100}}")));
        Recipes.registerModRecipe((Recipe)new Recipe("coal", 1, RecipeTechRegistry.FORGE, Recipes.ingredientsFromScript((String)"{{anylog, 1}}")));
        Recipes.registerModRecipe((Recipe)new Recipe("coalpowder", 1, RecipeTechRegistry.GRAIN_MILL, Recipes.ingredientsFromScript((String)"{{coal, 1}}")));
        Recipes.registerModRecipe((Recipe)new Recipe("firemonepowder", 1, RecipeTechRegistry.GRAIN_MILL, Recipes.ingredientsFromScript((String)"{{firemone, 1}}")));
        Recipes.registerModRecipe((Recipe)new Recipe("ironbomb", 1, RecipeTechRegistry.ALCHEMY, Recipes.ingredientsFromScript((String)"{{ironbar, 1}, {coalpowder, 3}, {firemonepowder, 3}, {acid, 2}}")));
        Recipes.registerModRecipe((Recipe)new Recipe("dynamitestick", 1, RecipeTechRegistry.VOID_ALCHEMY, Recipes.ingredientsFromScript((String)"{{chilipepper, 1}, {goldbar, 1}, {coalpowder, 4}, {firemonepowder, 4}, {acid, 2}}")));
    }

    private static void registerNewMachines() {
        Recipes.registerModRecipe((Recipe)new Recipe("light_disassembler", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript((String)"{{anylog, 10}, {copperbar, 3}, {anystone, 10}}")).showAfter("woodstaff"));
        Recipes.registerModRecipe((Recipe)new Recipe("disassembler", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript((String)"{{ironbar, 10}, {copperbar, 3}, {anystone, 20}, {anyjewel, 1}}")));
        Recipes.registerModRecipe((Recipe)new Recipe("heavy_disassembler", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript((String)"{{demonicbar, 10}, {goldbar, 3}, {voidshard, 4}, {anyjewel, 4}}")).showBefore("demonicpickaxe"));
        Recipes.registerModRecipe((Recipe)new Recipe("ancient_disassembler", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript((String)"{{tungstenbar, 10}, {demonicbar, 3}, {anyjewel, 5}, {glacialshard, 2}, {lifequartz, 2}}")).showAfter("landscapingstation"));
    }

    private static void registerShredderJaws() {
        Recipes.registerModRecipe((Recipe)new Recipe("woodenshredderjaws", 1, RecipeTechRegistry.WORKSTATION, Recipes.ingredientsFromScript((String)"{{anylog, 4}, {anysapling, 1}}")).showAfter("light_disassembler"));
        Recipes.registerModRecipe((Recipe)new Recipe("coppershredderjaws", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript((String)"{{copperbar, 8}, {ironbar, 2}}")));
        Recipes.registerModRecipe((Recipe)new Recipe("ironshredderjaws", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript((String)"{{ironbar, 8}, {goldbar, 2}}")));
        Recipes.registerModRecipe((Recipe)new Recipe("goldenshredderjaws", 1, RecipeTechRegistry.IRON_ANVIL, Recipes.ingredientsFromScript((String)"{{goldbar, 8}, {anyjewel, 1}}")));
        Recipes.registerModRecipe((Recipe)new Recipe("demonicshredderjaws", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript((String)"{{demonicbar, 8}, {voidshard, 4}, {anyjewel, 1}}")).showAfter("heavy_disassembler"));
        Recipes.registerModRecipe((Recipe)new Recipe("ivyshredderjaws", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript((String)"{{ivybar, 8}, {swampsludge, 4}, {anyjewel, 1}}")).showAfter("demonicshredderjaws"));
        Recipes.registerModRecipe((Recipe)new Recipe("quartzshredderjaws", 1, RecipeTechRegistry.DEMONIC_WORKSTATION, Recipes.ingredientsFromScript((String)"{{quartz, 8}, {demonicbar, 2}, {anyjewel, 1}}")).showAfter("ivyshredderjaws"));
        Recipes.registerModRecipe((Recipe)new Recipe("tungstenshredderjaws", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript((String)"{{tungstenbar, 8}, {obsidian, 4}, {anyjewel, 1}}")).showAfter("ancient_disassembler"));
        Recipes.registerModRecipe((Recipe)new Recipe("glacialshredderjaws", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript((String)"{{glacialbar, 8}, {glacialshard, 4}, {anyjewel, 1}}")).showAfter("tungstenshredderjaws"));
        Recipes.registerModRecipe((Recipe)new Recipe("myceliumshredderjaws", 1, RecipeTechRegistry.TUNGSTEN_WORKSTATION, Recipes.ingredientsFromScript((String)"{{myceliumbar, 8}, {anyjewel, 1}}")).showAfter("glacialshredderjaws"));
        Recipes.registerModRecipe((Recipe)new Recipe("ironbar", 4, RecipeTechRegistry.FORGE, new Ingredient[]{new Ingredient("ironshredderjaws", 1)}));
        Recipes.registerModRecipe((Recipe)new Recipe("copperbar", 4, RecipeTechRegistry.FORGE, new Ingredient[]{new Ingredient("coppershredderjaws", 1)}));
        Recipes.registerModRecipe((Recipe)new Recipe("goldbar", 4, RecipeTechRegistry.FORGE, new Ingredient[]{new Ingredient("goldenshredderjaws", 1)}));
        Recipes.registerModRecipe((Recipe)new Recipe("demonicbar", 4, RecipeTechRegistry.FORGE, new Ingredient[]{new Ingredient("demonicshredderjaws", 1)}));
        Recipes.registerModRecipe((Recipe)new Recipe("ivybar", 4, RecipeTechRegistry.FORGE, new Ingredient[]{new Ingredient("ivyshredderjaws", 1)}));
        Recipes.registerModRecipe((Recipe)new Recipe("quartz", 4, RecipeTechRegistry.FORGE, new Ingredient[]{new Ingredient("quartzshredderjaws", 1)}));
        Recipes.registerModRecipe((Recipe)new Recipe("tungstenbar", 5, RecipeTechRegistry.FORGE, new Ingredient[]{new Ingredient("tungstenshredderjaws", 1)}));
        Recipes.registerModRecipe((Recipe)new Recipe("glacialbar", 5, RecipeTechRegistry.FORGE, new Ingredient[]{new Ingredient("glacialshredderjaws", 1)}));
        Recipes.registerModRecipe((Recipe)new Recipe("myceliumbar", 4, RecipeTechRegistry.FORGE, new Ingredient[]{new Ingredient("myceliumshredderjaws", 1)}));
    }

    private static void registerBrokenTools() {
        Recipes.registerModRecipe((Recipe)new Recipe("goldbar", 2, RecipeTechRegistry.FORGE, new Ingredient[]{new Ingredient("brokengoldentool", 1)}));
        Recipes.registerModRecipe((Recipe)new Recipe("demonicbar", 2, RecipeTechRegistry.FORGE, new Ingredient[]{new Ingredient("brokendemonictool", 1)}));
        Recipes.registerModRecipe((Recipe)new Recipe("runestone", 2, RecipeTechRegistry.FORGE, new Ingredient[]{new Ingredient("brokenrunictool", 1)}));
        Recipes.registerModRecipe((Recipe)new Recipe("ivybar", 2, RecipeTechRegistry.FORGE, new Ingredient[]{new Ingredient("brokenivytool", 1)}));
        Recipes.registerModRecipe((Recipe)new Recipe("quartz", 2, RecipeTechRegistry.FORGE, new Ingredient[]{new Ingredient("brokenquartztool", 1)}));
        Recipes.registerModRecipe((Recipe)new Recipe("tungstenbar", 2, RecipeTechRegistry.FORGE, new Ingredient[]{new Ingredient("brokentungstentool", 1)}));
        Recipes.registerModRecipe((Recipe)new Recipe("glacialbar", 2, RecipeTechRegistry.FORGE, new Ingredient[]{new Ingredient("brokenglacialtool", 1)}));
        Recipes.registerModRecipe((Recipe)new Recipe("myceliumbar", 2, RecipeTechRegistry.FORGE, new Ingredient[]{new Ingredient("brokenmyceliumtool", 1)}));
        Recipes.registerModRecipe((Recipe)new Recipe("ancientfossilbar", 2, RecipeTechRegistry.FORGE, new Ingredient[]{new Ingredient("brokenancientfossiltool", 1)}));
        Recipes.registerModRecipe((Recipe)new Recipe("nightsteelbar", 2, RecipeTechRegistry.FORGE, new Ingredient[]{new Ingredient("brokennightsteeltool", 1)}));
        Recipes.registerModRecipe((Recipe)new Recipe("spideritebar", 2, RecipeTechRegistry.FORGE, new Ingredient[]{new Ingredient("brokenspideritetool", 1)}));
    }
}

