/*
 * Decompiled with CFR 0.152.
 */
package recraft.recipes;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import necesse.inventory.recipe.Ingredient;
import necesse.inventory.recipe.Recipe;
import necesse.inventory.recipe.Recipes;
import necesse.inventory.recipe.Tech;
import recraft.items.ShredderJaws;
import recraft.util.RecraftTech;

public class DisassemblerRecipes {
    private static final Map<String, Integer> NEEDED_JAW_POWER_FOR_ITEM = new HashMap<String, Integer>();
    private static final int PLANTS_NEEDED_FOR_SEED = 4;
    public static final boolean ENABLE_OBJECTS_RECYCLING = true;
    public static final boolean ENABLE_TRAPS_RECYCLING = true;
    public static final ShredderJaws.ShredderType JAWS_FOR_SEEDS = ShredderJaws.ShredderType.WOODEN;
    public static final ShredderJaws.ShredderType JAWS_FOR_LEATHER = ShredderJaws.ShredderType.WOODEN;
    public static final ShredderJaws.ShredderType JAWS_FOR_CLOTHES = ShredderJaws.ShredderType.WOODEN;
    public static final ShredderJaws.ShredderType JAWS_FOR_TOOLS = ShredderJaws.ShredderType.WOODEN;
    public static final ShredderJaws.ShredderType JAWS_FOR_WOOD = ShredderJaws.ShredderType.WOODEN;
    public static final ShredderJaws.ShredderType JAWS_FOR_FURNITURE = ShredderJaws.ShredderType.COPPER;
    public static final ShredderJaws.ShredderType JAWS_FOR_TRAPS = ShredderJaws.ShredderType.COPPER;
    public static final ShredderJaws.ShredderType JAWS_FOR_COPPER = ShredderJaws.ShredderType.COPPER;
    public static final ShredderJaws.ShredderType JAWS_FOR_FROST = ShredderJaws.ShredderType.IRON;
    public static final ShredderJaws.ShredderType JAWS_FOR_IRON = ShredderJaws.ShredderType.IRON;
    public static final ShredderJaws.ShredderType JAWS_FOR_GOLD = ShredderJaws.ShredderType.IRON;
    public static final ShredderJaws.ShredderType JAWS_FOR_DEMONIC = ShredderJaws.ShredderType.GOLDEN;
    public static final ShredderJaws.ShredderType JAWS_FOR_JEWELS = ShredderJaws.ShredderType.GOLDEN;
    public static final ShredderJaws.ShredderType JAWS_FOR_DEMONIC_2 = ShredderJaws.ShredderType.DEMONIC;
    public static final ShredderJaws.ShredderType JAWS_FOR_RUNIC = ShredderJaws.ShredderType.DEMONIC;
    public static final ShredderJaws.ShredderType JAWS_FOR_VOID = ShredderJaws.ShredderType.DEMONIC;
    public static final ShredderJaws.ShredderType JAWS_FOR_IVY = ShredderJaws.ShredderType.DEMONIC;
    public static final ShredderJaws.ShredderType JAWS_FOR_QUARTZ = ShredderJaws.ShredderType.IVY;
    public static final ShredderJaws.ShredderType JAWS_FOR_TUNGSTEN = ShredderJaws.ShredderType.QUARTZ;
    public static final ShredderJaws.ShredderType JAWS_FOR_GLACIAL = ShredderJaws.ShredderType.TUNGSTEN;
    public static final ShredderJaws.ShredderType JAWS_FOR_DRYAD = ShredderJaws.ShredderType.TUNGSTEN;
    public static final ShredderJaws.ShredderType JAWS_FOR_MYCELIUM = ShredderJaws.ShredderType.TUNGSTEN;
    public static final ShredderJaws.ShredderType JAWS_FOR_SHADOW = ShredderJaws.ShredderType.GLACIAL;
    public static final ShredderJaws.ShredderType JAWS_FOR_ANCIENT = ShredderJaws.ShredderType.MYCELIUM;
    public static final ShredderJaws.ShredderType JAWS_FOR_SPIDERITE = ShredderJaws.ShredderType.MYCELIUM;
    public static final Map<ShredderJaws.ShredderType, List<String>> SHREDS_BY_TYPE = new HashMap<ShredderJaws.ShredderType, List<String>>();

    public static void registerRecipes() {
        DisassemblerRecipes.registerSeedRecipes(RecraftTech.LIGHT_DISASSEMBLER_ONLY_TECH);
        DisassemblerRecipes.registerLeatherRecipes(RecraftTech.LIGHT_DISASSEMBLER_ONLY_TECH);
        DisassemblerRecipes.registerClothRecipes(RecraftTech.LIGHT_DISASSEMBLER_ONLY_TECH);
        DisassemblerRecipes.registerFurnitureRecipes(RecraftTech.LIGHT_DISASSEMBLER_TECH);
        DisassemblerRecipes.registerToolRecipes(RecraftTech.LIGHT_DISASSEMBLER_TECH);
        DisassemblerRecipes.registerWoodRecipes(RecraftTech.LIGHT_DISASSEMBLER_TECH);
        DisassemblerRecipes.registerCopperRecipes(RecraftTech.LIGHT_DISASSEMBLER_TECH);
        DisassemblerRecipes.registerTrapRecipes(RecraftTech.LIGHT_DISASSEMBLER_TECH);
        DisassemblerRecipes.registerIronRecipes(RecraftTech.DISASSEMBLER_TECH);
        DisassemblerRecipes.registerGoldRecipes(RecraftTech.DISASSEMBLER_TECH);
        DisassemblerRecipes.registerFrostRecipes(RecraftTech.DISASSEMBLER_TECH);
        DisassemblerRecipes.registerJewelRecipes(RecraftTech.DISASSEMBLER_TECH);
        DisassemblerRecipes.registerDemonicRecipes(RecraftTech.DISASSEMBLER_TECH);
        DisassemblerRecipes.registerRunicRecipes(RecraftTech.DISASSEMBLER_TECH);
        DisassemblerRecipes.registerVoidRecipes(RecraftTech.HEAVY_DISASSEMBLER_TECH);
        DisassemblerRecipes.registerBetterDemonicRecipes(RecraftTech.HEAVY_DISASSEMBLER_TECH);
        DisassemblerRecipes.registerIvyRecipes(RecraftTech.HEAVY_DISASSEMBLER_TECH);
        DisassemblerRecipes.registerQuartzRecipes(RecraftTech.HEAVY_DISASSEMBLER_TECH);
        DisassemblerRecipes.registerTungstenRecipes(RecraftTech.HEAVY_DISASSEMBLER_TECH);
        DisassemblerRecipes.registerShadowRecipes(RecraftTech.ANCIENT_DISASSEMBLER_TECH);
        DisassemblerRecipes.registerGlacialRecipes(RecraftTech.ANCIENT_DISASSEMBLER_TECH);
        DisassemblerRecipes.registerDryadRecipes(RecraftTech.ANCIENT_DISASSEMBLER_TECH);
        DisassemblerRecipes.registerMyceliumRecipes(RecraftTech.ANCIENT_DISASSEMBLER_TECH);
        DisassemblerRecipes.registerAncientFossilRecipes(RecraftTech.ANCIENT_DISASSEMBLER_TECH);
        DisassemblerRecipes.registerSpideriteRecipes(RecraftTech.ANCIENT_DISASSEMBLER_TECH);
    }

    public static List<String> getShredsList(ShredderJaws.ShredderType shredderType) {
        return SHREDS_BY_TYPE.get((Object)shredderType);
    }

    public static void registerRecipe(ShredderJaws.ShredderType requiredJaws, String resultStringId, int resultAmount, String inputItemId, int inputItemAmount, Tech tech) {
        Recipes.registerModRecipe((Recipe)new Recipe(resultStringId, resultAmount, tech, new Ingredient[]{new Ingredient(inputItemId, inputItemAmount)}, true));
        NEEDED_JAW_POWER_FOR_ITEM.put(inputItemId, requiredJaws.getPower());
    }

    public static boolean canShredItem(String itemId, ShredderJaws.ShredderType jawsType) {
        if (!NEEDED_JAW_POWER_FOR_ITEM.containsKey(itemId)) {
            return false;
        }
        return NEEDED_JAW_POWER_FOR_ITEM.get(itemId) <= jawsType.getPower();
    }

    private static void registerFurnitureRecipes(Tech tech) {
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 3, "storagebox", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 1, "woodwall", 2, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 1, "woodfloor", 5, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 1, "woodpathtile", 2, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 1, "woodfence", 2, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 1, "wooddoor", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 1, "woodfencegate", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 1, "stonefencegate", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 3, "barrel", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 4, "woodcolumn", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 4, "armorstand", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 2, "waterlantern", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 1, "banditfence", 2, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 1, "banditfencegate", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 1, "stool", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 4, "barshelf", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 4, "workstation", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 4, "workstationduo", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 4, "alchemytable", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 4, "cartographertable", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 10, "compostbin", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "caveglow", 5, "caveglowalchemytable", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 1, "paintingbroken", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TUNGSTEN, "oaklog", 7, "landscapingstation", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 3, "oakchest", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 5, "oakdinnertable", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 3, "oakdesk", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 3, "oakmodulartable", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 2, "oakchair", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 4, "oakbench", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 4, "oakbookshelf", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 4, "oakcabinet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 4, "oakbed", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 8, "oakdoublebed", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 3, "oakdresser", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 3, "oakclock", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 3, "oakcandelabra", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 4, "oakdisplay", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 4, "oakbathtub", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 3, "oaktoilet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 2, "christmascrate", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "sprucelog", 3, "sprucechest", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "sprucelog", 5, "sprucedinnertable", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "sprucelog", 3, "sprucedesk", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "sprucelog", 3, "sprucemodulartable", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "sprucelog", 2, "sprucechair", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "sprucelog", 4, "sprucebench", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "sprucelog", 4, "sprucebookshelf", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "sprucelog", 4, "sprucecabinet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "sprucelog", 4, "sprucebed", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "sprucelog", 8, "sprucedoublebed", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "sprucelog", 3, "sprucedresser", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "sprucelog", 3, "spruceclock", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "sprucelog", 3, "sprucecandelabra", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "sprucelog", 4, "sprucedisplay", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "sprucelog", 4, "sprucebathtub", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "sprucelog", 3, "sprucetoilet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "sprucelog", 2, "crate", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "pinelog", 1, "pinewall", 2, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "pinelog", 1, "pinedoor", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "pinelog", 1, "pinefloor", 5, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "pinelog", 3, "pinechest", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "pinelog", 5, "pinedinnertable", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "pinelog", 3, "pinedesk", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "pinelog", 3, "pinemodulartable", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "pinelog", 2, "pinechair", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "pinelog", 4, "pinebench", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "pinelog", 4, "pinebookshelf", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "pinelog", 4, "pinecabinet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "pinelog", 4, "pinebed", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "pinelog", 8, "pinedoublebed", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "pinelog", 3, "pinedresser", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "pinelog", 3, "pineclock", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "pinelog", 3, "pinecandelabra", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "pinelog", 4, "pinedisplay", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "pinelog", 4, "pinebathtub", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "pinelog", 3, "pinetoilet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "pinelog", 2, "snowcrate", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "palmlog", 1, "palmwall", 2, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "palmlog", 1, "palmdoor", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "palmlog", 1, "palmfloor", 5, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "palmlog", 3, "palmchest", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "palmlog", 5, "palmdinnertable", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "palmlog", 3, "palmdesk", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "palmlog", 3, "palmmodulartable", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "palmlog", 2, "palmchair", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "palmlog", 4, "palmbench", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "palmlog", 4, "palmbookshelf", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "palmlog", 4, "palmcabinet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "palmlog", 4, "palmbed", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "palmlog", 8, "palmdoublebed", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "palmlog", 3, "palmdresser", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "palmlog", 3, "palmclock", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "palmlog", 3, "palmcandelabra", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "palmlog", 4, "palmdisplay", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "palmlog", 4, "palmbathtub", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "palmlog", 3, "palmtoilet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "deadwoodlog", 1, "deadwoodfloor", 5, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "deadwoodlog", 3, "deadwoodchest", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "deadwoodlog", 5, "deadwooddinnertable", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "deadwoodlog", 3, "deadwooddesk", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "deadwoodlog", 3, "deadwoodmodulartable", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "deadwoodlog", 2, "deadwoodchair", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "deadwoodlog", 4, "deadwoodbench", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "deadwoodlog", 4, "deadwoodbookshelf", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "deadwoodlog", 4, "deadwoodcabinet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "deadwoodlog", 4, "deadwoodbed", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "deadwoodlog", 8, "deadwooddoublebed", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "deadwoodlog", 3, "deadwooddresser", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "deadwoodlog", 3, "deadwoodclock", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "deadwoodlog", 3, "deadwoodcandelabra", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "deadwoodlog", 4, "deadwooddisplay", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "deadwoodlog", 4, "deadwoodbathtub", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "deadwoodlog", 3, "deadwoodtoilet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "maplelog", 3, "maplechest", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "maplelog", 5, "mapledinnertable", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "maplelog", 3, "mapledesk", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "maplelog", 3, "maplemodulartable", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "maplelog", 2, "maplechair", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "maplelog", 4, "maplebench", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "maplelog", 4, "maplebookshelf", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "maplelog", 4, "maplecabinet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "maplelog", 4, "maplebed", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "maplelog", 8, "mapledoublebed", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "maplelog", 3, "mapledresser", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "maplelog", 3, "mapleclock", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "maplelog", 3, "maplecandelabra", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "maplelog", 4, "mapledisplay", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "maplelog", 4, "maplebathtub", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "maplelog", 3, "mapletoilet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "birchlog", 3, "birchchest", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "birchlog", 5, "birchdinnertable", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "birchlog", 3, "birchdesk", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "birchlog", 3, "birchmodulartable", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "birchlog", 2, "birchchair", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "birchlog", 4, "birchbench", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "birchlog", 4, "birchbookshelf", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "birchlog", 4, "birchcabinet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "birchlog", 4, "birchbed", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "birchlog", 8, "birchdoublebed", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "birchlog", 3, "birchdresser", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "birchlog", 3, "birchclock", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "birchlog", 3, "birchcandelabra", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "birchlog", 4, "birchdisplay", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "birchlog", 4, "birchbathtub", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "birchlog", 3, "birchtoilet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 3, "dungeonchest", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 5, "dungeondinnertable", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 3, "dungeondesk", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 3, "dungeonmodulartable", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 2, "dungeonchair", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 4, "dungeonbench", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 4, "dungeonbookshelf", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 4, "dungeoncabinet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 4, "dungeonbed", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 8, "dungeondoublebed", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 3, "dungeondresser", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 3, "dungeonclock", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 3, "dungeoncandelabra", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 4, "dungeondisplay", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 4, "dungeonbathtub", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "oaklog", 3, "dungeontoilet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "bamboo", 5, "bamboodinnertable", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "bamboo", 3, "bamboodesk", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "bamboo", 3, "bamboomodulartable", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "bamboo", 2, "bamboochair", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "bamboo", 4, "bamboobench", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "bamboo", 4, "bamboobookshelf", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "bamboo", 4, "bamboocabinet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "bamboo", 4, "bamboobed", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "bamboo", 8, "bamboodoublebed", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "bamboo", 3, "bamboodresser", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "bamboo", 3, "bambooclock", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "bamboo", 3, "bamboocandelabra", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "bamboo", 4, "bamboodisplay", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "bamboo", 4, "bamboobathtub", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "bamboo", 3, "bambootoilet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "bamboo", 1, "bamboowall", 2, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "bamboo", 1, "bamboodoor", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "bamboo", 1, "bamboofloor", 5, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "bone", 3, "bonechest", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "bone", 5, "bonedinnertable", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "bone", 3, "bonedesk", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "bone", 3, "bonemodulartable", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "bone", 2, "bonechair", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "bone", 4, "bonebench", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "bone", 4, "bonebookshelf", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "bone", 4, "bonecabinet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "bone", 4, "bonebed", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "bone", 4, "bonedoublebed", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "bone", 3, "bonedresser", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "bone", 3, "boneclock", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "bone", 3, "bonecandelabra", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "bone", 4, "bonedisplay", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "bone", 4, "bonebathtub", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "bone", 3, "bonetoilet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "willowlog", 2, "swampcrate", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "willowlog", 5, "willowdinnertable", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "willowlog", 3, "willowdesk", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "willowlog", 3, "willowmodulartable", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "willowlog", 2, "willowchair", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "willowlog", 4, "willowbench", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "willowlog", 4, "willowbookshelf", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "willowlog", 4, "willowcabinet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "willowlog", 4, "willowbed", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "willowlog", 8, "willowdoublebed", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "willowlog", 3, "willowdresser", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "willowlog", 3, "willowclock", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "willowlog", 3, "willowcandelabra", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "willowlog", 4, "willowdisplay", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "willowlog", 4, "willowbathtub", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "willowlog", 3, "willowtoilet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "willowlog", 1, "willowwall", 2, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "willowlog", 1, "willowfloor", 5, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "willowlog", 1, "willowdoor", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "dryadlog", 5, "dryaddinnertable", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "dryadlog", 3, "dryaddesk", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "dryadlog", 3, "dryadmodulartable", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "dryadlog", 2, "dryadchair", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "dryadlog", 4, "dryadbench", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "dryadlog", 4, "dryadbookshelf", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "dryadlog", 4, "dryadcabinet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "dryadlog", 4, "dryadbed", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "dryadlog", 8, "dryaddoublebed", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "dryadlog", 3, "dryaddresser", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "dryadlog", 3, "dryadclock", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "dryadlog", 3, "dryadcandelabra", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "dryadlog", 4, "dryaddisplay", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "dryadlog", 4, "dryadbathtub", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "dryadlog", 3, "dryadtoilet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "dryadlog", 1, "dryadwall", 2, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "dryadlog", 1, "dryaddoor", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "dryadlog", 1, "dryadfloor", 2, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "dryadlog", 1, "dryadpath", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "brokenirontool", 1, "ironfence", 4, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FURNITURE, "brokenirontool", 1, "ironfencegate", 2, tech);
    }

    private static void registerToolRecipes(Tech tech) {
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TOOLS, "dynamitestick", 4, "tnt", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TOOLS, "mapfragment", 2, "book", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TOOLS, "mapfragment", 1, "anymap", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TOOLS, "mapfragment", 1, "recallscroll", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TOOLS, "mapfragment", 1, "teleportationscroll", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TOOLS, "mapfragment", 1, "enchantingscroll", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TOOLS, "wheat", 6, "eggnest", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TOOLS, "bone", 1, "bonearrow", 200, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TOOLS, "batwing", 5, "bloodbolt", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TOOLS, "cavespidergland", 4, "spiderboomerang", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TOOLS, "cavespidergland", 5, "venomstaff", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TOOLS, "cavespidergland", 6, "spiderstaff", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TOOLS, "cavespidergland", 3, "spiderhelmet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TOOLS, "cavespidergland", 5, "spiderchestplate", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TOOLS, "cavespidergland", 2, "spiderboots", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TOOLS, "cavespidergland", 3, "spiderclaw", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TOOLS, "cavespidergland", 1, "poisonarrow", 100, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TOOLS, "oaklog", 1, "magicbranch", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TOOLS, "oaklog", 1, "brainonastick", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TOOLS, "glass", 1, "glassbottle", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TOOLS, "glass", 2, "wallwindow", 1, tech);
    }

    private static void registerLeatherRecipes(Tech tech) {
        DisassemblerRecipes.registerRecipe(JAWS_FOR_LEATHER, "leather", 4, "leatherglove", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_LEATHER, "leather", 4, "leatherhood", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_LEATHER, "leather", 5, "leathershirt", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_LEATHER, "leather", 2, "leatherboots", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_LEATHER, "leather", 1, "leathercarpet", 3, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_LEATHER, "leather", 2, "brownbearcarpet", 3, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_LEATHER, "leather", 1, "rope", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_LEATHER, "leather", 3, "infiniterope", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_LEATHER, "leather", 4, "leatherdashers", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_LEATHER, "leather", 4, "trackerboot", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_LEATHER, "leather", 2, "craftingguide", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_LEATHER, "leather", 2, "recipebook", 1, tech);
    }

    private static void registerClothRecipes(Tech tech) {
        DisassemblerRecipes.registerRecipe(JAWS_FOR_CLOTHES, "wool", 6, "clothhat", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_CLOTHES, "wool", 8, "clothrobe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_CLOTHES, "wool", 4, "clothboots", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_CLOTHES, "wool", 15, "bannerofspeed", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_CLOTHES, "wool", 15, "bannerofdamage", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_CLOTHES, "wool", 15, "bannerofsummonspeed", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_CLOTHES, "wool", 15, "bannerofdefense", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_CLOTHES, "wool", 15, "strikebanner", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_CLOTHES, "wool", 4, "merchantsbackpack", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_CLOTHES, "wool", 3, "woolcarpet", 2, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_CLOTHES, "clothscraps", 3, "runeboundcrown", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_CLOTHES, "clothscraps", 3, "runeboundcrownmask", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_CLOTHES, "clothscraps", 3, "runeboundskullhelmet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_CLOTHES, "clothscraps", 3, "runeboundhelmet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_CLOTHES, "clothscraps", 3, "runeboundhornhelmet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_CLOTHES, "clothscraps", 3, "runeboundhood", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_CLOTHES, "clothscraps", 3, "runeboundbackbones", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_CLOTHES, "clothscraps", 4, "runeboundrobe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_CLOTHES, "clothscraps", 4, "runeboundbonesrobe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_CLOTHES, "clothscraps", 4, "runeboundleatherchest", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_CLOTHES, "clothscraps", 2, "runeboundboots", 1, tech);
    }

    private static void registerWoodRecipes(Tech tech) {
        DisassemblerRecipes.registerRecipe(JAWS_FOR_WOOD, "oaklog", 3, "woodpickaxe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_WOOD, "oaklog", 3, "woodaxe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_WOOD, "oaklog", 3, "woodshovel", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_WOOD, "oaklog", 4, "woodsword", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_WOOD, "oaklog", 6, "woodgreatsword", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_WOOD, "oaklog", 5, "woodspear", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_WOOD, "oaklog", 4, "woodbow", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_WOOD, "oaklog", 4, "woodboomerang", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_WOOD, "birchlog", 4, "rollingpin", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_WOOD, "oaklog", 3, "ladderdown", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_WOOD, "oaklog", 2, "woodboat", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_WOOD, "oaklog", 2, "sign", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_WOOD, "oaklog", 1, "stonearrow", 200, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_WOOD, "oaklog", 1, "firearrow", 200, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_WOOD, "oaklog", 1, "walltorch", 2, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_WOOD, "oaklog", 1, "wallcandle", 3, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_WOOD, "oaklog", 1, "woodencandleset", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_WOOD, "oaklog", 3, "woodshield", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_WOOD, "oaklog", 3, "woodstaff", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_WOOD, "oaklog", 3, "woodfishingrod", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_WOOD, "oaklog", 2, "apiaryframe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_WOOD, "oaklog", 5, "net", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_WOOD, "oaklog", 5, "trainingdummy", 1, tech);
    }

    private static void registerTrapRecipes(Tech tech) {
        Stream.of("woodarrowtrap", "stonearrowtrap", "sandstonearrowtrap", "swampstonearrowtrap", "snowstonearrowtrap", "icearrowtrap", "dungeonarrowtrap", "deepstonearrowtrap", "obsidianarrowtrap", "deepsnowstonearrowtrap", "deepswampstonearrowtrap", "deepsandstonearrowtrap", "spidercastlearrowtrap", "dryadarrowtrap", "granitearrowtrap", "basaltarrowtrap").forEach(item -> DisassemblerRecipes.registerRecipe(JAWS_FOR_TRAPS, "wire", 30, item, 1, tech));
        Stream.of("woodsawtrap", "stonesawtrap", "sandstonesawtrap", "swampstonesawtrap", "snowstonesawtrap", "icesawtrap", "dungeonsawtrap", "deepstonesawtrap", "obsidiansawtrap", "deepsnowstonesawtrap", "deepswampstonesawtrap", "deepsandstonesawtrap", "granitesawtrap", "basaltsawtrap").forEach(item -> DisassemblerRecipes.registerRecipe(JAWS_FOR_TRAPS, "brokenirontool", 1, item, 1, tech));
        Stream.of("stoneflametrap", "sandstoneflametrap", "swampstoneflametrap", "dungeonflametrap", "deepstoneflametrap", "obsidianflametrap", "deepsnowstoneflametrap", "deepswampstoneflametrap", "deepsandstoneflametrap", "graniteflametrap", "basaltflametrap").forEach(item -> DisassemblerRecipes.registerRecipe(JAWS_FOR_TRAPS, "brokengoldentool", 1, item, 1, tech));
        Stream.of("woodpressureplate", "stonepressureplate", "snowstonepressureplate", "swampstonepressureplate", "dungeonpressureplate", "sandstonepressureplate", "deepstonepressureplate", "deepsnowstonepressureplate", "deepswampstonepressureplate", "granitepressureplate").forEach(item -> DisassemblerRecipes.registerRecipe(JAWS_FOR_TRAPS, "wire", 5, item, 1, tech));
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DEMONIC_2, "brokendemonictool", 1, "dungeonvoidtrap", 1, RecraftTech.HEAVY_DISASSEMBLER_TECH);
    }

    private static void registerCopperRecipes(Tech tech) {
        DisassemblerRecipes.registerRecipe(JAWS_FOR_COPPER, "brokencoppertool", 3, "copperhelmet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_COPPER, "brokencoppertool", 4, "copperchestplate", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_COPPER, "brokencoppertool", 2, "copperboots", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_COPPER, "brokencoppertool", 3, "copperbow", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_COPPER, "brokencoppertool", 1, "oillantern", 3, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_COPPER, "brokencoppertool", 1, "copperstreetlamp", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_COPPER, "brokencoppertool", 2, "copperdoublestreetlamp", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_COPPER, "brokencoppertool", 1, "wire", 20, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_COPPER, "brokencoppertool", 1, "rocklever", 4, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_COPPER, "brokencoppertool", 2, "copperpitchfork", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_COPPER, "brokencoppertool", 2, "copperpickaxe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_COPPER, "brokencoppertool", 2, "copperaxe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_COPPER, "brokencoppertool", 2, "coppershovel", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_COPPER, "brokencoppertool", 3, "coppersword", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_COPPER, "brokencoppertool", 4, "copperspear", 1, tech);
    }

    private static void registerIronRecipes(Tech tech) {
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 3, "ironhelmet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 4, "ironchestplate", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 2, "ironboots", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 3, "ironbow", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 1, "ironlamp", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 1, "ironstreetlamp", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 2, "irondoublestreetlamp", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 1, "ironarrow", 200, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 3, "wrench", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 3, "cutter", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 1, "bucket", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 2, "infinitewaterbucket", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 1, "simplebullet", 150, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 1, "ninjastar", 32, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 3, "heavyhammer", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 2, "nunchucks", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 1, "ironfishingrod", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 1, "binoculars", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 1, "slimecanister", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 1, "cannonball", 5, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 1, "hook", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 2, "butcherscleaver", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 2, "chefsspecial", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 2, "anchorandchain", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 2, "telescope", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 3, "katana", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 2, "ironanvil", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 1, "carpentersbench", 2, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 1, "cookingpot", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 3, "grainmill", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 1, "feedingtrough", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 3, "incinerator", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 1, "fireworkdispenser", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 3, "apiary", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 1, "largekeg", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 3, "chainshirt", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 2, "ironpickaxe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 2, "ironaxe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 2, "ironshovel", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 3, "ironsword", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 5, "irongreatsword", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 4, "ironspear", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 3, "minecart", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 1, "minecarttrack", 50, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 3, "sickle", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 3, "shears", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 3, "farmingscythe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 3, "hardenedshield", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IRON, "brokenirontool", 1, "sparkler", 1, tech);
    }

    private static void registerGoldRecipes(Tech tech) {
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GOLD, "brokengoldentool", 3, "goldcrown", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GOLD, "brokengoldentool", 3, "goldhelmet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GOLD, "brokengoldentool", 4, "goldchestplate", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GOLD, "brokengoldentool", 2, "goldboots", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GOLD, "brokengoldentool", 4, "goldglaive", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GOLD, "brokengoldentool", 3, "goldbow", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GOLD, "brokengoldentool", 4, "goldgreatbow", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GOLD, "brokengoldentool", 1, "goldlamp", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GOLD, "brokengoldentool", 1, "goldstreetlamp", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GOLD, "brokengoldentool", 2, "golddoublestreetlamp", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GOLD, "brokengoldentool", 1, "goldchair", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GOLD, "brokengoldentool", 2, "golddinnertable", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GOLD, "brokengoldentool", 1, "goldfishingrod", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GOLD, "brokengoldentool", 5, "cutlass", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GOLD, "brokengoldentool", 3, "genielamp", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GOLD, "brokengoldentool", 2, "goldpickaxe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GOLD, "brokengoldentool", 2, "goldaxe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GOLD, "brokengoldentool", 2, "goldshovel", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GOLD, "brokengoldentool", 3, "goldsword", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GOLD, "brokengoldentool", 4, "goldspear", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GOLD, "brokengoldentool", 4, "settlementflag", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GOLD, "brokengoldentool", 1, "musicplayer", 1, tech);
    }

    private static void registerFrostRecipes(Tech tech) {
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FROST, "frostshard", 4, "frosthelmet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FROST, "frostshard", 4, "frosthood", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FROST, "frostshard", 4, "frosthat", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FROST, "frostshard", 5, "frostchestplate", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FROST, "frostshard", 3, "frostboots", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FROST, "frostshard", 4, "frostpickaxe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FROST, "frostshard", 4, "frostaxe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FROST, "frostshard", 4, "frostshovel", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FROST, "frostshard", 4, "frostsword", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FROST, "frostshard", 6, "frostgreatsword", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FROST, "frostshard", 5, "frostspear", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FROST, "frostshard", 5, "frostglaive", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FROST, "frostshard", 4, "frostboomerang", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FROST, "frostshard", 4, "frostbow", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FROST, "frostshard", 1, "icejavelin", 15, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FROST, "frostshard", 5, "frostpiercer", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FROST, "frostshard", 1, "frostarrow", 100, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FROST, "frostshard", 1, "frostbullet", 100, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FROST, "frostshard", 5, "froststaff", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_FROST, "frostshard", 3, "coolingbox", 1, tech);
    }

    private static void registerJewelRecipes(Tech tech) {
        DisassemblerRecipes.registerRecipe(JAWS_FOR_JEWELS, "ruby", 7, "rubyshields", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_JEWELS, "sapphire", 1, "crystalbullet", 200, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_JEWELS, "amethyst", 5, "amethystsword", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_JEWELS, "sapphire", 5, "sapphirerevolver", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_JEWELS, "emerald", 5, "emeraldwand", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_JEWELS, "sapphire", 3, "sapphirestaff", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_JEWELS, "amethyst", 4, "amethyststaff", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_JEWELS, "ruby", 5, "rubystaff", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_JEWELS, "emerald", 6, "emeraldstaff", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_JEWELS, "topaz", 3, "topazstaff", 1, tech);
    }

    private static void registerDemonicRecipes(Tech tech) {
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DEMONIC, "brokendemonictool", 1, "demonicworkstation", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DEMONIC, "brokendemonictool", 1, "cheesepress", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DEMONIC, "brokendemonictool", 1, "demonicworkstationduo", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DEMONIC, "brokendemonictool", 2, "demonicanvil", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DEMONIC, "brokendemonictool", 3, "demonicpickaxe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DEMONIC, "brokendemonictool", 3, "demonicaxe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DEMONIC, "brokendemonictool", 3, "demonicshovel", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DEMONIC, "brokendemonictool", 3, "demonicsword", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DEMONIC, "brokendemonictool", 4, "demonicspear", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DEMONIC, "brokendemonictool", 3, "demonicbow", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DEMONIC, "brokendemonictool", 1, "demonclaw", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DEMONIC, "brokendemonictool", 1, "demonchest", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DEMONIC, "brokendemonictool", 3, "demonichelmet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DEMONIC, "brokendemonictool", 4, "demonicchestplate", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DEMONIC, "brokendemonictool", 2, "demonicboots", 1, tech);
    }

    private static void registerBetterDemonicRecipes(Tech tech) {
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DEMONIC_2, "brokendemonictool", 3, "bloodplatecowl", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DEMONIC_2, "brokendemonictool", 4, "bloodplatechestplate", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DEMONIC_2, "brokendemonictool", 3, "bloodplateboots", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DEMONIC_2, "brokendemonictool", 2, "vampiresgift", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DEMONIC_2, "brokendemonictool", 1, "royalegg", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DEMONIC_2, "brokendemonictool", 1, "mysteriousportal", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DEMONIC_2, "brokendemonictool", 1, "voidcaller", 1, tech);
    }

    private static void registerRunicRecipes(Tech tech) {
        DisassemblerRecipes.registerRecipe(JAWS_FOR_RUNIC, "brokenrunictool", 4, "runicpickaxe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_RUNIC, "brokenrunictool", 4, "runicaxe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_RUNIC, "brokenrunictool", 4, "runicshovel", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_RUNIC, "brokenrunictool", 4, "runichelmet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_RUNIC, "brokenrunictool", 3, "runichood", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_RUNIC, "brokenrunictool", 3, "runichat", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_RUNIC, "brokenrunictool", 3, "runiccrown", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_RUNIC, "brokenrunictool", 4, "runicchestplate", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_RUNIC, "brokenrunictool", 2, "runicboots", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_RUNIC, "brokenrunictool", 1, "boneoffering", 1, tech);
    }

    private static void registerVoidRecipes(Tech tech) {
        DisassemblerRecipes.registerRecipe(JAWS_FOR_VOID, "voidshard", 2, "voidmask", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_VOID, "voidshard", 2, "voidhat", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_VOID, "voidshard", 3, "voidrobe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_VOID, "voidshard", 2, "voidboots", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_VOID, "voidshard", 5, "bloodvolley", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_VOID, "voidshard", 1, "voidbullet", 200, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_VOID, "brokendemonictool", 2, "voidspear", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_VOID, "brokendemonictool", 1, "voidboomerang", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_VOID, "brokendemonictool", 2, "voidgreatbow", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_VOID, "brokendemonictool", 2, "voidstaff", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_VOID, "brokendemonictool", 1, "voidmissile", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_VOID, "brokendemonictool", 3, "lightninghammer", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_VOID, "voidshard", 5, "voidalchemytable", 1, tech);
    }

    private static void registerIvyRecipes(Tech tech) {
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IVY, "brokenivytool", 3, "ivypickaxe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IVY, "brokenivytool", 3, "ivyaxe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IVY, "brokenivytool", 3, "ivyshovel", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IVY, "brokenivytool", 3, "ivysword", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IVY, "brokenivytool", 5, "ivygreatsword", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IVY, "brokenivytool", 4, "ivyspear", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IVY, "brokenivytool", 3, "ivybow", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IVY, "brokenivytool", 1, "overgrownfishingrod", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IVY, "brokenivytool", 1, "razorbladeboomerang", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IVY, "brokenivytool", 2, "dredgingstaff", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IVY, "brokenivytool", 1, "swamptome", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IVY, "brokenivytool", 4, "ivygreatbow", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IVY, "brokenivytool", 4, "druidsgreatbow", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IVY, "brokenivytool", 3, "ivyhelmet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IVY, "brokenivytool", 3, "ivyhood", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IVY, "brokenivytool", 3, "ivyhat", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IVY, "brokenivytool", 3, "ivycirclet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IVY, "brokenivytool", 4, "ivychestplate", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IVY, "brokenivytool", 2, "ivyboots", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IVY, "brokenivytool", 3, "boulderstaff", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_IVY, "brokenivytool", 1, "spikedfossil", 1, tech);
    }

    private static void registerQuartzRecipes(Tech tech) {
        DisassemblerRecipes.registerRecipe(JAWS_FOR_QUARTZ, "brokenquartztool", 4, "quartzpickaxe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_QUARTZ, "brokenquartztool", 4, "quartzaxe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_QUARTZ, "brokenquartztool", 4, "quartzshovel", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_QUARTZ, "brokenquartztool", 5, "quartzgreatsword", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_QUARTZ, "brokenquartztool", 4, "quartzglaive", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_QUARTZ, "brokenquartztool", 3, "quartzhelmet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_QUARTZ, "brokenquartztool", 3, "quartzcrown", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_QUARTZ, "brokenquartztool", 4, "quartzchestplate", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_QUARTZ, "brokenquartztool", 2, "quartzboots", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_QUARTZ, "brokenquartztool", 3, "vulturesburst", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_QUARTZ, "brokenquartztool", 4, "vulturestalon", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_QUARTZ, "brokenquartztool", 1, "vulturestaff", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_QUARTZ, "brokenquartztool", 3, "quartzstaff", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_QUARTZ, "brokenquartztool", 1, "ancientstatue", 1, tech);
    }

    private static void registerSeedRecipes(Tech tech) {
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SEEDS, "wheatseed", 1, "wheat", 4, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SEEDS, "riceseed", 1, "rice", 4, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SEEDS, "cornseed", 1, "corn", 4, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SEEDS, "tomatoseed", 1, "tomato", 4, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SEEDS, "cabbageseed", 1, "cabbage", 4, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SEEDS, "chilipepperseed", 1, "chilipepper", 4, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SEEDS, "sugarbeetseed", 1, "sugarbeet", 4, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SEEDS, "eggplantseed", 1, "eggplant", 4, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SEEDS, "potatoseed", 1, "potato", 4, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SEEDS, "carrotseed", 1, "carrot", 4, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SEEDS, "onionseed", 1, "onion", 4, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SEEDS, "pumpkinseed", 1, "pumpkin", 4, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SEEDS, "strawberryseed", 1, "strawberry", 4, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SEEDS, "sunflowerseed", 1, "sunflower", 4, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SEEDS, "firemoneseed", 1, "firemone", 4, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SEEDS, "iceblossomseed", 1, "iceblossom", 4, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SEEDS, "beetseed", 1, "beet", 4, tech);
    }

    private static void registerTungstenRecipes(Tech tech) {
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TUNGSTEN, "brokentungstentool", 4, "tungstenpickaxe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TUNGSTEN, "brokentungstentool", 4, "tungstenaxe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TUNGSTEN, "brokentungstentool", 4, "tungstenshovel", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TUNGSTEN, "brokentungstentool", 3, "tungstensword", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TUNGSTEN, "brokentungstentool", 4, "tungstenspear", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TUNGSTEN, "brokentungstentool", 3, "tungstenbow", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TUNGSTEN, "brokentungstentool", 1, "tungstenstreetlamp", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TUNGSTEN, "brokentungstentool", 2, "tungstendoublestreetlamp", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TUNGSTEN, "brokentungstentool", 2, "deepladderdown", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TUNGSTEN, "brokentungstentool", 1, "lantern", 4, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TUNGSTEN, "brokentungstentool", 1, "walllantern", 4, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TUNGSTEN, "brokentungstentool", 2, "depthscatcher", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TUNGSTEN, "brokentungstentool", 2, "tungstenboomerang", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TUNGSTEN, "brokentungstentool", 4, "tungstenhelmet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TUNGSTEN, "brokentungstentool", 5, "tungstenchestplate", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TUNGSTEN, "brokentungstentool", 3, "tungstenboots", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TUNGSTEN, "brokentungstentool", 5, "tungstenshield", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TUNGSTEN, "brokentungstentool", 4, "tungstengreatbow", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TUNGSTEN, "brokentungstentool", 1, "bonehilt", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TUNGSTEN, "brokentungstentool", 2, "cookingstation", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TUNGSTEN, "brokentungstentool", 2, "tungstenanvil", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TUNGSTEN, "brokentungstentool", 3, "tungstenworkstation", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TUNGSTEN, "brokentungstentool", 1, "tungstencarpentersbench", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_TUNGSTEN, "brokentungstentool", 1, "tungstenlandscapingstation", 1, tech);
    }

    private static void registerShadowRecipes(Tech tech) {
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SHADOW, "brokentungstentool", 1, "shadowgate", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SHADOW, "ectoplasm", 5, "shadowbolt", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SHADOW, "ectoplasm", 4, "shadowhat", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SHADOW, "ectoplasm", 4, "shadowhood", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SHADOW, "ectoplasm", 5, "shadowmantle", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SHADOW, "ectoplasm", 3, "shadowboots", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SHADOW, "ectoplasm", 4, "ninjahood", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SHADOW, "ectoplasm", 5, "ninjarobe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SHADOW, "ectoplasm", 3, "ninjashoes", 1, tech);
    }

    private static void registerGlacialRecipes(Tech tech) {
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GLACIAL, "brokenglacialtool", 4, "glacialpickaxe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GLACIAL, "brokenglacialtool", 5, "icepickaxe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GLACIAL, "brokenglacialtool", 4, "glacialaxe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GLACIAL, "brokenglacialtool", 4, "glacialshovel", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GLACIAL, "brokenglacialtool", 5, "glacialgreatsword", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GLACIAL, "brokenglacialtool", 1, "glacialboomerang", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GLACIAL, "brokenglacialtool", 3, "glacialbow", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GLACIAL, "brokenglacialtool", 3, "glacialcirclet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GLACIAL, "brokenglacialtool", 3, "glacialhelmet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GLACIAL, "brokenglacialtool", 4, "glacialchestplate", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GLACIAL, "brokenglacialtool", 2, "glacialboots", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GLACIAL, "brokenglacialtool", 3, "iciclestaff", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GLACIAL, "brokenglacialtool", 4, "cryostaff", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GLACIAL, "brokenglacialtool", 4, "cryospear", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GLACIAL, "brokenglacialtool", 4, "cryoglaive", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_GLACIAL, "brokenglacialtool", 2, "icecrown", 1, tech);
    }

    private static void registerDryadRecipes(Tech tech) {
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DRYAD, "amber", 6, "dryadpickaxe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DRYAD, "amber", 6, "dryadaxe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DRYAD, "amber", 6, "dryadshovel", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DRYAD, "amber", 5, "dryadgreathammer", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DRYAD, "amber", 7, "dryadbow", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DRYAD, "amber", 7, "dryadbarrage", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DRYAD, "amber", 5, "dryadbranch", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DRYAD, "amber", 5, "dryadcrown", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DRYAD, "amber", 5, "dryadhat", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DRYAD, "amber", 5, "dryadhelmet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DRYAD, "amber", 5, "dryadscarf", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DRYAD, "amber", 7, "dryadchestplate", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DRYAD, "amber", 4, "dryadboots", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_DRYAD, "amber", 4, "spiriturn", 1, tech);
    }

    private static void registerMyceliumRecipes(Tech tech) {
        DisassemblerRecipes.registerRecipe(JAWS_FOR_MYCELIUM, "brokenmyceliumtool", 4, "myceliumpickaxe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_MYCELIUM, "brokenmyceliumtool", 4, "myceliumaxe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_MYCELIUM, "brokenmyceliumtool", 4, "myceliumshovel", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_MYCELIUM, "brokenmyceliumtool", 5, "myceliumgreatbow", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_MYCELIUM, "brokenmyceliumtool", 3, "myceliumhood", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_MYCELIUM, "brokenmyceliumtool", 3, "myceliumscarf", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_MYCELIUM, "brokenmyceliumtool", 4, "myceliumchestplate", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_MYCELIUM, "brokenmyceliumtool", 2, "myceliumboots", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_MYCELIUM, "brokenmyceliumtool", 2, "widowhelmet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_MYCELIUM, "brokenmyceliumtool", 3, "widowchestplate", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_MYCELIUM, "brokenmyceliumtool", 2, "widowboots", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_MYCELIUM, "brokenmyceliumtool", 1, "decayingleaf", 1, tech);
    }

    private static void registerSpideriteRecipes(Tech tech) {
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SPIDERITE, "brokenspideritetool", 1, "spideritearrow", 250, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SPIDERITE, "brokenspideritetool", 3, "spideritehelmet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SPIDERITE, "brokenspideritetool", 3, "spideritehood", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SPIDERITE, "brokenspideritetool", 3, "spideritehat", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SPIDERITE, "brokenspideritetool", 3, "spideritecrown", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SPIDERITE, "brokenspideritetool", 4, "spideritechestplate", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SPIDERITE, "brokenspideritetool", 2, "spideritegreaves", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SPIDERITE, "brokenspideritetool", 1, "spideritearmorstand", 2, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SPIDERITE, "brokenspideritetool", 4, "causticexecutioner", 2, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SPIDERITE, "brokenspideritetool", 4, "arachnidwebbow", 2, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SPIDERITE, "brokenspideritetool", 5, "webweaver", 2, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_SPIDERITE, "brokenspideritetool", 7, "empresscommand", 2, tech);
    }

    private static void registerAncientFossilRecipes(Tech tech) {
        DisassemblerRecipes.registerRecipe(JAWS_FOR_ANCIENT, "brokenancientfossiltool", 4, "ancientfossilpickaxe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_ANCIENT, "brokenancientfossiltool", 4, "ancientfossilaxe", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_ANCIENT, "brokenancientfossiltool", 4, "ancientfossilshovel", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_ANCIENT, "brokenancientfossiltool", 3, "antiquesword", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_ANCIENT, "brokenancientfossiltool", 3, "antiquebow", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_ANCIENT, "brokenancientfossiltool", 4, "ancientdredgingstaff", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_ANCIENT, "brokenancientfossiltool", 2, "ancientfossilmask", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_ANCIENT, "brokenancientfossiltool", 3, "ancientfossilhelmet", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_ANCIENT, "brokenancientfossiltool", 4, "ancientfossilchestplate", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_ANCIENT, "brokenancientfossiltool", 2, "ancientfossilboots", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_ANCIENT, "brokenancientfossiltool", 1, "dragonsouls", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_ANCIENT, "wormcarapace", 4, "carapacedagger", 1, tech);
        DisassemblerRecipes.registerRecipe(JAWS_FOR_ANCIENT, "wormcarapace", 8, "carapaceshield", 1, tech);
    }

    static {
        SHREDS_BY_TYPE.put(ShredderJaws.ShredderType.PAPER, Arrays.asList("carrot", "woodsword", "tnt", "villagemap", "leathershirt"));
        SHREDS_BY_TYPE.put(ShredderJaws.ShredderType.WOODEN, Arrays.asList("carrot", "woodsword", "tnt", "villagemap", "leathershirt"));
        SHREDS_BY_TYPE.put(ShredderJaws.ShredderType.COPPER, Arrays.asList("oakbed", "oakchest", "stoneflametrap", "coppersword"));
        SHREDS_BY_TYPE.put(ShredderJaws.ShredderType.IRON, Arrays.asList("ironsword", "shears", "minecarttrack", "goldsword", "icejavelin"));
        SHREDS_BY_TYPE.put(ShredderJaws.ShredderType.GOLDEN, Arrays.asList("demonicsword", "amethystsword"));
        SHREDS_BY_TYPE.put(ShredderJaws.ShredderType.DEMONIC, Arrays.asList("bloodplatechestplate", "mysteriousportal", "voidspear", "ivysword", "quartzchestplate"));
        SHREDS_BY_TYPE.put(ShredderJaws.ShredderType.IVY, Collections.EMPTY_LIST);
        SHREDS_BY_TYPE.put(ShredderJaws.ShredderType.QUARTZ, Arrays.asList("tungstensword"));
        SHREDS_BY_TYPE.put(ShredderJaws.ShredderType.TUNGSTEN, Arrays.asList("glacialchestplate", "dryadshovel", "myceliumchestplate"));
        SHREDS_BY_TYPE.put(ShredderJaws.ShredderType.GLACIAL, Arrays.asList("shadowmantle"));
        SHREDS_BY_TYPE.put(ShredderJaws.ShredderType.MYCELIUM, Arrays.asList("ancientfossilshovel", "spideritechestplate"));
    }
}

