/*
 * Decompiled with CFR 0.152.
 */
package recraft.objects.entities;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import necesse.engine.localization.Localization;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.gameTooltips.GameTooltipManager;
import necesse.gfx.gameTooltips.GameTooltips;
import necesse.gfx.gameTooltips.StringTooltips;
import necesse.gfx.gameTooltips.TooltipLocation;
import necesse.inventory.InventoryItem;
import necesse.inventory.InventoryRange;
import necesse.inventory.recipe.Ingredient;
import necesse.inventory.recipe.Recipe;
import necesse.inventory.recipe.Tech;
import necesse.level.maps.Level;
import recraft.items.ShredderJaws;
import recraft.objects.entities.CoalFueledProcessingTechInventoryObjectEntity;
import recraft.recipes.DisassemblerRecipes;
import recraft.util.RecraftTech;
import recraft.util.RecraftTextures;

public class DisassemblerObjectEntity
extends CoalFueledProcessingTechInventoryObjectEntity {
    public static int coalFuelTime = 40000;
    public static int recipeProcessTime = 8000;
    private boolean strongEnoughJaws = true;

    public DisassemblerObjectEntity(Level level, int x, int y) {
        this(level, x, y, 1, 4, 4, RecraftTech.LIGHT_DISASSEMBLER_ONLY_TECH, RecraftTech.LIGHT_DISASSEMBLER_TECH, RecraftTech.DISASSEMBLER_TECH);
    }

    public DisassemblerObjectEntity(Level level, int x, int y, int toolSlots, int inputSlots, int outputSlots, Tech ... techs) {
        super(level, "disassembler", x, y, toolSlots, inputSlots, outputSlots, false, false, true, techs);
    }

    @Override
    public int getFuelTime(InventoryItem item) {
        return coalFuelTime;
    }

    @Override
    public int getProcessTime(Recipe recipe) {
        return recipeProcessTime;
    }

    public List<ShredderJaws.ShredderType> getAcceptedJawTypes() {
        ArrayList<ShredderJaws.ShredderType> shredderTypes = new ArrayList<ShredderJaws.ShredderType>();
        shredderTypes.add(ShredderJaws.ShredderType.IRON);
        shredderTypes.add(ShredderJaws.ShredderType.GOLDEN);
        return shredderTypes;
    }

    @Override
    public boolean shouldBeAbleToChangeKeepFuelRunning() {
        return false;
    }

    @Override
    public GameTexture getToolSlotTexture() {
        return GameTexture.fromFile((String)RecraftTextures.JAWS_SLOT);
    }

    @Override
    public GameTexture getSideproductSlotTexture() {
        return GameTexture.fromFile((String)RecraftTextures.ASH_SLOT);
    }

    @Override
    public boolean isValidToolItem(InventoryItem item) {
        return item.item instanceof ShredderJaws && this.getAcceptedJawTypes().stream().anyMatch(acceptedJaws -> ((ShredderJaws)item.item).shredderType.equals(acceptedJaws));
    }

    public void consumeOneShred() {
        Optional.ofNullable(this.getInstalledJaws()).ifPresent(shredderJaws -> {
            ((ShredderJaws)shredderJaws.item).useOneShred((InventoryItem)shredderJaws);
            this.markDirty();
        });
    }

    public boolean areJawsStrongEnough() {
        return this.strongEnoughJaws;
    }

    @Override
    public boolean canProcessInput(Ingredient ... ingredients) {
        String itemId = ingredients[0].ingredientStringID;
        InventoryItem jaws = this.getInstalledJaws();
        if (jaws != null) {
            ShredderJaws.ShredderType jawsType = ((ShredderJaws)jaws.item).shredderType;
            this.strongEnoughJaws = DisassemblerRecipes.canShredItem(itemId, jawsType);
        } else {
            this.strongEnoughJaws = false;
        }
        return this.strongEnoughJaws;
    }

    @Override
    public boolean isTurnedOn() {
        InventoryItem jaws = this.getInstalledJaws();
        return jaws != null && ((ShredderJaws)jaws.item).getShredsLeft(jaws) > 0;
    }

    private InventoryItem getInstalledJaws() {
        InventoryItem item;
        InventoryRange inventoryRange = this.getToolInventoryRange();
        if (inventoryRange.startSlot <= inventoryRange.endSlot && (item = inventoryRange.inventory.getItem(inventoryRange.startSlot)) != null && item.item instanceof ShredderJaws) {
            return item;
        }
        return null;
    }

    @Override
    public void onMouseHover(PlayerMob perspective, boolean debug) {
        super.onMouseHover(perspective, debug);
        StringTooltips tooltips = new StringTooltips(this.getObject().getDisplayName());
        InventoryItem jawsItem = this.getInstalledJaws();
        if (jawsItem != null) {
            ShredderJaws jaws = (ShredderJaws)jawsItem.item;
            tooltips.add(String.format("%s: %s", Localization.translate((String)"itemtooltip", (String)"jaws_type_info"), Localization.translate((String)"item", (String)jaws.getStringID())));
            tooltips.add(String.format("%s: %d", Localization.translate((String)"itemtooltip", (String)"diss_jaws_left_info"), jaws.getShredsLeft(jawsItem)));
            if (!this.areJawsStrongEnough()) {
                tooltips.add(Localization.translate((String)"ui", (String)"needstrongerjaws"));
            }
        } else {
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"no_jaws_installed"));
        }
        GameTooltipManager.addTooltip((GameTooltips)tooltips, (TooltipLocation)TooltipLocation.INTERACT_FOCUS);
    }
}

