/*
 * Decompiled with CFR 0.152.
 */
package recraft.objects.entities;

import java.util.Optional;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.SoundPlayer;
import necesse.engine.sound.gameSound.GameSound;
import necesse.gfx.GameResources;
import necesse.inventory.InventoryItem;
import necesse.inventory.recipe.Tech;
import necesse.level.maps.Level;
import recraft.objects.entities.AnythingFueledProcessingTechInventoryObjectEntity;

public abstract class CoalFueledProcessingTechInventoryObjectEntity
extends AnythingFueledProcessingTechInventoryObjectEntity {
    public GameSound workingSound = GameResources.campfireAmbient;
    private SoundPlayer playingSound;

    public CoalFueledProcessingTechInventoryObjectEntity(Level level, String type, int x, int y, int toolSlots, int inputSlots, int outputSlots, boolean fuelAlwaysOn, boolean fuelRunsOutWhenNotProcessing, boolean runningOutOfFuelResetsProcessingTime, Tech ... techs) {
        super(level, type, x, y, 2, 2, toolSlots, inputSlots, outputSlots, fuelAlwaysOn, fuelRunsOutWhenNotProcessing, runningOutOfFuelResetsProcessingTime, "coal", techs);
    }

    @Override
    public void clientTick() {
        super.clientTick();
        if (this.workingSound != null && this.isFuelRunning()) {
            if (this.playingSound == null || this.playingSound.isDone()) {
                this.playingSound = SoundManager.playSound((GameSound)this.workingSound, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this).falloffDistance(400).volume(0.25f));
            }
            if (this.playingSound != null) {
                this.playingSound.refreshLooping(1.0f);
            }
        }
    }

    @Override
    public boolean isValidFuelItem(InventoryItem item) {
        return Optional.ofNullable(item).map(i -> i.item).map(i -> i.getStringID().equals("coal")).orElse(false);
    }

    @Override
    public int getNextFuelBurnTime(boolean useFuel) {
        return this.itemToBurnTime(useFuel, item -> this.isValidFuelItem((InventoryItem)item) ? this.getFuelTime((InventoryItem)item) : 0);
    }

    public abstract int getFuelTime(InventoryItem var1);
}

