/*
 * Decompiled with CFR 0.152.
 */
package recraft.objects.disassembler;

import java.awt.Rectangle;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.localization.Localization;
import necesse.engine.network.server.ServerClient;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.objectEntity.ObjectEntity;
import necesse.entity.particle.Particle;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.LevelSortedDrawable;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.inventory.container.object.CraftingStationContainer;
import necesse.level.gameObject.GameObject;
import necesse.level.gameObject.ObjectHoverHitbox;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;
import recraft.containers.RecraftContainers;
import recraft.objects.entities.DisassemblerObjectEntity;

public class DisassemblerObject
extends GameObject {
    public GameTexture texture;

    public DisassemblerObject() {
        super(new Rectangle(32, 32));
        this.setItemCategory(new String[]{"objects", "craftingstations"});
        this.setCraftingCategory(new String[]{"craftingstations"});
        this.drawDamage = false;
        this.isLightTransparent = true;
        this.roomProperties.add("metalwork");
        this.lightHue = 50.0f;
        this.lightSat = 0.2f;
        this.replaceCategories.add("workstation");
        this.canReplaceCategories.add("workstation");
        this.canReplaceCategories.add("wall");
        this.canReplaceCategories.add("furniture");
    }

    public int getLightLevel(Level level, int layerID, int x, int y) {
        DisassemblerObjectEntity disassemblerObjectEntity = this.getDisassemblerObjectEntity(level, x, y);
        return disassemblerObjectEntity != null && disassemblerObjectEntity.isFuelRunning() && disassemblerObjectEntity.isTurnedOn() ? 100 : 0;
    }

    public void tickEffect(Level level, int layerID, int x, int y) {
        DisassemblerObjectEntity disassemblerObjectEntity;
        super.tickEffect(level, layerID, x, y);
        if (GameRandom.globalRandom.nextInt(10) == 0 && (disassemblerObjectEntity = this.getDisassemblerObjectEntity(level, x, y)) != null && disassemblerObjectEntity.isFuelRunning() && disassemblerObjectEntity.isTurnedOn()) {
            int startHeight = 16 + GameRandom.globalRandom.nextInt(16);
            level.entityManager.addParticle((float)(x * 32 + GameRandom.globalRandom.getIntBetween(8, 24)), (float)(y * 32 + 32), Particle.GType.COSMETIC).smokeColor().heightMoves((float)startHeight, (float)(startHeight + 20)).lifeTime(1000);
        }
    }

    public void loadTextures() {
        this.texture = GameTexture.fromFile((String)"objects/disassembler");
    }

    public Rectangle getCollision(Level level, int x, int y, int rotation) {
        return rotation % 2 == 0 ? new Rectangle(x * 32 + 2, y * 32 + 6, 28, 20) : new Rectangle(x * 32 + 6, y * 32 + 2, 20, 28);
    }

    public List<ObjectHoverHitbox> getHoverHitboxes(Level level, int layerID, int tileX, int tileY) {
        List list = super.getHoverHitboxes(level, layerID, tileX, tileY);
        list.add(new ObjectHoverHitbox(layerID, tileX, tileY, 0, -16, 32, 16));
        return list;
    }

    public void addDrawables(List<LevelSortedDrawable> list, OrderableDrawables tileList, Level level, int tileX, int tileY, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        TextureDrawOptionsEnd shredder;
        GameLight light = level.getLightLevel(tileX, tileY);
        int drawX = camera.getTileDrawX(tileX);
        int drawY = camera.getTileDrawY(tileY);
        byte rotation = level.getObjectRotation(tileX, tileY);
        boolean isFueled = false;
        boolean turnedOn = false;
        DisassemblerObjectEntity objectEntity = this.getDisassemblerObjectEntity(level, tileX, tileY);
        if (objectEntity != null) {
            isFueled = objectEntity.isFuelRunning();
            turnedOn = objectEntity.isTurnedOn();
        }
        int spriteHeight = this.texture.getHeight() - 32;
        TextureDrawOptionsEnd options = this.texture.initDraw().sprite(rotation % 4, 0, 32, spriteHeight).light(light).pos(drawX, drawY - (spriteHeight - 32));
        if (isFueled && turnedOn && rotation == 2) {
            int spriteX = (int)(level.getWorldEntity().getWorldTime() % 1200L / 300L);
            shredder = this.texture.initDraw().sprite(spriteX, spriteHeight / 32, 32).light(light).pos(drawX, drawY);
        } else {
            shredder = null;
        }
        list.add(new LevelSortedDrawable(this, tileX, tileY, (TextureDrawOptions)options, shredder){
            final /* synthetic */ TextureDrawOptions val$options;
            final /* synthetic */ TextureDrawOptionsEnd val$shredder;
            {
                this.val$options = textureDrawOptions;
                this.val$shredder = textureDrawOptionsEnd;
                super(arg0, arg1, arg2);
            }

            public int getSortY() {
                return 16;
            }

            public void draw(TickManager tickManager) {
                this.val$options.draw();
                if (this.val$shredder != null) {
                    this.val$shredder.draw();
                }
            }
        });
    }

    public void drawPreview(Level level, int tileX, int tileY, int rotation, float alpha, PlayerMob player, GameCamera camera) {
        int drawX = camera.getTileDrawX(tileX);
        int drawY = camera.getTileDrawY(tileY);
        int spriteHeight = this.texture.getHeight() - 32;
        this.texture.initDraw().sprite(rotation % 4, 0, 32, spriteHeight).alpha(alpha).draw(drawX, drawY - (spriteHeight - 32));
    }

    public ObjectEntity getNewObjectEntity(Level level, int x, int y) {
        return new DisassemblerObjectEntity(level, x, y);
    }

    public String getInteractTip(Level level, int x, int y, PlayerMob perspective, boolean debug) {
        return Localization.translate((String)"controls", (String)"opentip");
    }

    public boolean canInteract(Level level, int x, int y, PlayerMob player) {
        return true;
    }

    public void interact(Level level, int x, int y, PlayerMob player) {
        if (level.isServer()) {
            CraftingStationContainer.openAndSendContainer((int)RecraftContainers.DISASSEMBLER_CONTAINER, (ServerClient)player.getServerClient(), (Level)level, (int)x, (int)y);
        }
    }

    public DisassemblerObjectEntity getDisassemblerObjectEntity(Level level, int tileX, int tileY) {
        ObjectEntity objectEntity = level.entityManager.getObjectEntity(tileX, tileY);
        return objectEntity instanceof DisassemblerObjectEntity ? (DisassemblerObjectEntity)objectEntity : null;
    }
}

