/*
 * Decompiled with CFR 0.152.
 */
package recraft.objects.disassembler;

import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.objectEntity.ObjectEntity;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.LevelSortedDrawable;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameTexture;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;
import recraft.objects.disassembler.DisassemblerObject;
import recraft.objects.entities.AncientDisassemblerObjectEntity;
import recraft.objects.entities.DisassemblerObjectEntity;

public class AncientDisassemblerObject
extends DisassemblerObject {
    @Override
    public void loadTextures() {
        this.texture = GameTexture.fromFile((String)"objects/ancient_disassembler");
    }

    @Override
    public ObjectEntity getNewObjectEntity(Level level, int x, int y) {
        return new AncientDisassemblerObjectEntity(level, x, y);
    }

    @Override
    public void addDrawables(List<LevelSortedDrawable> list, OrderableDrawables tileList, Level level, int tileX, int tileY, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        TextureDrawOptionsEnd shredder;
        GameLight light = level.getLightLevel(tileX, tileY);
        int drawX = camera.getTileDrawX(tileX);
        int drawY = camera.getTileDrawY(tileY);
        byte rotation = level.getObjectRotation(tileX, tileY);
        boolean isFueled = false;
        boolean turnedOn = false;
        DisassemblerObjectEntity objectEntity = this.getDisassemblerObjectEntity(level, tileX, tileY);
        if (objectEntity != null) {
            isFueled = objectEntity.isFuelRunning();
            turnedOn = objectEntity.isTurnedOn();
        }
        int spriteHeight = this.texture.getHeight() - 32;
        TextureDrawOptionsEnd options = this.texture.initDraw().sprite(rotation % 4, 0, 32, spriteHeight).light(light).pos(drawX, drawY - (spriteHeight - 32));
        if (isFueled && turnedOn) {
            int spriteX = (int)(level.getWorldEntity().getWorldTime() % 1200L / 300L);
            int jawsY = rotation % 2 == 0 ? drawY : drawY - 3;
            shredder = this.texture.initDraw().sprite(spriteX, spriteHeight / 32, 32).light(light).pos(drawX, jawsY);
        } else {
            shredder = null;
        }
        list.add(new LevelSortedDrawable(this, tileX, tileY, (TextureDrawOptions)options, shredder){
            final /* synthetic */ TextureDrawOptions val$options;
            final /* synthetic */ TextureDrawOptionsEnd val$shredder;
            {
                this.val$options = textureDrawOptions;
                this.val$shredder = textureDrawOptionsEnd;
                super(arg0, arg1, arg2);
            }

            public int getSortY() {
                return 16;
            }

            public void draw(TickManager tickManager) {
                this.val$options.draw();
                if (this.val$shredder != null) {
                    this.val$shredder.draw();
                }
            }
        });
    }
}

