/*
 * Decompiled with CFR 0.152.
 */
package recraft.items;

import java.util.stream.Stream;
import necesse.engine.Settings;
import necesse.engine.localization.Localization;
import necesse.engine.util.GameBlackboard;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.fairType.FairType;
import necesse.gfx.gameFont.FontOptions;
import necesse.gfx.gameTooltips.FairTypeTooltip;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.ItemCategory;
import recraft.recipes.DisassemblerRecipes;
import recraft.util.Helper;

public class ShredderJaws
extends Item {
    public final ShredderType shredderType;

    public ShredderJaws(ShredderType shredderType) {
        super(1);
        this.setItemCategory(new String[]{"equipment", "tools"});
        this.setItemCategory(ItemCategory.craftingManager, new String[]{"equipment", "tools"});
        this.shredderType = shredderType;
        this.dropsAsMatDeathPenalty = false;
        this.worldDrawSize = 32;
        this.incinerationTimeMillis = 30000;
    }

    public int getShredsLeft(InventoryItem inventoryItem) {
        return Math.max(0, this.shredderType.getShredsLimit() - inventoryItem.getGndData().getInt("shredsUsed"));
    }

    protected ListGameTooltips getBaseTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getBaseTooltips(item, perspective, blackboard);
        String disassemblerName = Localization.translate((String)"object", (String)Helper.getDisassemblerIdForJaws(this.shredderType));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"used_in") + " " + disassemblerName);
        tooltips.add(String.format("%s: %d", Localization.translate((String)"itemtooltip", (String)"jaws_left_info"), this.getShredsLeft(item)));
        if (this.getShredsLeft(item) < 1 && Stream.of(ShredderType.PAPER, ShredderType.WOODEN).noneMatch(e -> e.equals((Object)this.shredderType))) {
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"forgerecycle"));
        } else {
            String prevJawsId = this.shredderType.prevType != null ? Helper.jawTypeToItemNames.get((Object)this.shredderType.prevType) : null;
            FontOptions fontOptions = new FontOptions(Settings.tooltipTextSize).outline();
            FairType shredsTooltip = Helper.itemPlusItemsToFairType(fontOptions, prevJawsId, DisassemblerRecipes.getShredsList(this.shredderType));
            tooltips.add((Object)new FairTypeTooltip(shredsTooltip));
        }
        return tooltips;
    }

    public void useOneShred(InventoryItem inventoryItem) {
        int shredsUsed = inventoryItem.getGndData().getInt("shredsUsed");
        if (shredsUsed < this.shredderType.getShredsLimit()) {
            inventoryItem.getGndData().setInt("shredsUsed", ++shredsUsed);
        }
    }

    public static enum ShredderType {
        PAPER(5, 1, null),
        WOODEN(5, 1, null),
        COPPER(15, 2, WOODEN),
        IRON(18, 2, COPPER),
        GOLDEN(30, 3, IRON),
        DEMONIC(25, 4, GOLDEN),
        IVY(30, 5, DEMONIC),
        QUARTZ(30, 6, IVY),
        TUNGSTEN(22, 7, QUARTZ),
        GLACIAL(25, 8, TUNGSTEN),
        MYCELIUM(30, 9, GLACIAL);

        private final int shredsLimit;
        private final int power;
        private final ShredderType prevType;

        private ShredderType(int shredsLimit, int power, ShredderType prevType) {
            this.shredsLimit = shredsLimit;
            this.power = power;
            this.prevType = prevType;
        }

        public int getShredsLimit() {
            return this.shredsLimit;
        }

        public int getPower() {
            return this.power;
        }
    }
}

