/*
 * Decompiled with CFR 0.152.
 */
package recraft.events;

import java.util.Optional;
import java.util.Random;
import java.util.stream.Stream;
import necesse.engine.GameEventInterface;
import necesse.engine.GameEventListener;
import necesse.engine.GameEvents;
import necesse.engine.events.loot.MobLootTableDropsEvent;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.friendly.critters.MouseMob;
import necesse.entity.mobs.hostile.AncientSkeletonMob;
import necesse.entity.mobs.hostile.AncientSkeletonThrowerMob;
import necesse.entity.mobs.hostile.CaveMoleMob;
import necesse.entity.mobs.hostile.CrawlingZombieMob;
import necesse.entity.mobs.hostile.CryptVampireMob;
import necesse.entity.mobs.hostile.DesertCrawlerMob;
import necesse.entity.mobs.hostile.EnchantedCrawlingZombieMob;
import necesse.entity.mobs.hostile.EnchantedZombieArcherMob;
import necesse.entity.mobs.hostile.EnchantedZombieMob;
import necesse.entity.mobs.hostile.FrozenDwarfMob;
import necesse.entity.mobs.hostile.GoblinMob;
import necesse.entity.mobs.hostile.MummyMageMob;
import necesse.entity.mobs.hostile.MummyMob;
import necesse.entity.mobs.hostile.NinjaMob;
import necesse.entity.mobs.hostile.SandSpiritMob;
import necesse.entity.mobs.hostile.SkeletonMob;
import necesse.entity.mobs.hostile.SkeletonThrowerMob;
import necesse.entity.mobs.hostile.SpiderkinArcherMob;
import necesse.entity.mobs.hostile.SpiderkinMob;
import necesse.entity.mobs.hostile.SpiderkinWarriorMob;
import necesse.entity.mobs.hostile.SwampDwellerMob;
import necesse.entity.mobs.hostile.SwampSkeletonMob;
import necesse.entity.mobs.hostile.SwampSlimeMob;
import necesse.entity.mobs.hostile.SwampZombieMob;
import necesse.entity.mobs.hostile.TrapperZombieMob;
import necesse.entity.mobs.hostile.TrenchcoatGoblinChestplateMob;
import necesse.entity.mobs.hostile.TrenchcoatGoblinHelmetMob;
import necesse.entity.mobs.hostile.TrenchcoatGoblinShoesMob;
import necesse.entity.mobs.hostile.VoidApprentice;
import necesse.entity.mobs.hostile.ZombieArcherMob;
import necesse.entity.mobs.hostile.ZombieMob;
import necesse.entity.mobs.hostile.bosses.VoidWizard;
import necesse.entity.mobs.hostile.theRunebound.RuneboundBruteMob;
import necesse.entity.mobs.hostile.theRunebound.RuneboundShamanMob;
import necesse.entity.mobs.hostile.theRunebound.RuneboundTrapperMob;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.matItem.MultiTextureMatItem;
import necesse.inventory.lootTable.lootItem.ChanceLootItem;
import recraft.events.ItemProducedEvent;
import recraft.objects.entities.DisassemblerObjectEntity;
import recraft.util.Helper;

public class RecraftEvents {
    private static final double ZOMBIE_PART_ITEM_PROBABILITY = 0.15;
    private static final double GOLDEN_BROKEN_TOOL_PROBABILITY = 0.1;
    private static final double DEMONIC_BROKEN_TOOL_PROBABILITY = 0.1;
    private static final double RUNIC_BROKEN_TOOL_PROBABILITY = 0.08;
    private static final double IVY_BROKEN_TOOL_PROBABILITY = 0.1;
    private static final double QUARTZ_BROKEN_TOOL_PROBABILITY = 0.1;
    private static final double TUNGSTEN_BROKEN_TOOL_PROBABILITY = 0.1;
    private static final double GLACIAL_BROKEN_TOOL_PROBABILITY = 0.1;
    private static final double MYCELIUM_BROKEN_TOOL_PROBABILITY = 0.1;
    private static final double ANCIENT_FOSSIL_BROKEN_TOOL_PROBABILITY = 0.1;
    private static final double NIGHTSTEEL_BROKEN_TOOL_PROBABILITY = 0.05;
    private static final double SPIDERITE_BROKEN_TOOL_PROBABILITY = 0.05;

    public static void registerEvents() {
        GameEvents.addListener(MobLootTableDropsEvent.class, (GameEventInterface)new GameEventListener<MobLootTableDropsEvent>(){

            public void onEvent(MobLootTableDropsEvent event) {
                boolean firstBosKilled = Optional.ofNullable(Helper.getClient()).map(c -> c.characterStats.mob_kills.getKills("evilsprotector")).map(kills -> kills > 0).orElse(false);
                if (RecraftEvents.isMobAnyOf(event, new Class[]{ZombieMob.class, ZombieArcherMob.class, CrawlingZombieMob.class, EnchantedZombieMob.class, EnchantedZombieArcherMob.class, EnchantedCrawlingZombieMob.class, TrapperZombieMob.class, SwampZombieMob.class}) && RecraftEvents.should(0.15)) {
                    event.drops.add(new InventoryItem("zombie_part", 1));
                }
                if (RecraftEvents.isMobAnyOf(event, new Class[]{CrawlingZombieMob.class, TrapperZombieMob.class, GoblinMob.class, CaveMoleMob.class, FrozenDwarfMob.class, TrenchcoatGoblinChestplateMob.class, TrenchcoatGoblinHelmetMob.class, TrenchcoatGoblinShoesMob.class})) {
                    if (RecraftEvents.should(0.1)) {
                        event.drops.add(MultiTextureMatItem.generateRandomItem((String)"brokengoldentool", (Random)GameRandom.globalRandom));
                    }
                } else if (firstBosKilled && RecraftEvents.isMobAnyOf(event, new Class[]{EnchantedZombieMob.class, EnchantedZombieArcherMob.class, EnchantedCrawlingZombieMob.class, VoidApprentice.class, VoidWizard.class})) {
                    if (RecraftEvents.should(0.1)) {
                        event.drops.add(MultiTextureMatItem.generateRandomItem((String)"brokendemonictool", (Random)GameRandom.globalRandom));
                    }
                } else if (firstBosKilled && RecraftEvents.isMobAnyOf(event, new Class[]{RuneboundShamanMob.class, RuneboundTrapperMob.class, RuneboundBruteMob.class})) {
                    if (RecraftEvents.should(0.08)) {
                        event.drops.add(MultiTextureMatItem.generateRandomItem((String)"brokenrunictool", (Random)GameRandom.globalRandom));
                    }
                } else if (firstBosKilled && RecraftEvents.isMobAnyOf(event, new Class[]{SwampZombieMob.class, SwampSlimeMob.class})) {
                    if (RecraftEvents.should(0.1)) {
                        event.drops.add(MultiTextureMatItem.generateRandomItem((String)"brokenivytool", (Random)GameRandom.globalRandom));
                    }
                } else if (firstBosKilled && RecraftEvents.isMobAnyOf(event, new Class[]{MummyMageMob.class, MummyMob.class, SandSpiritMob.class})) {
                    if (RecraftEvents.should(0.1)) {
                        event.drops.add(MultiTextureMatItem.generateRandomItem((String)"brokenquartztool", (Random)GameRandom.globalRandom));
                    }
                } else if (RecraftEvents.isMobAnyOf(event, new Class[]{SkeletonMob.class, SkeletonThrowerMob.class, AncientSkeletonMob.class, AncientSkeletonThrowerMob.class})) {
                    if (RecraftEvents.should(0.1)) {
                        event.drops.add(MultiTextureMatItem.generateRandomItem((String)"brokentungstentool", (Random)GameRandom.globalRandom));
                    }
                } else if (RecraftEvents.isMobAnyOf(event, new Class[]{SwampSkeletonMob.class, SwampDwellerMob.class})) {
                    if (RecraftEvents.should(0.1)) {
                        event.drops.add(MultiTextureMatItem.generateRandomItem((String)"brokenmyceliumtool", (Random)GameRandom.globalRandom));
                    }
                } else if (RecraftEvents.isMobAnyOf(event, new Class[]{NinjaMob.class})) {
                    if (RecraftEvents.should(0.1)) {
                        event.drops.add(MultiTextureMatItem.generateRandomItem((String)"brokenglacialtool", (Random)GameRandom.globalRandom));
                    }
                } else if (RecraftEvents.isMobAnyOf(event, new Class[]{DesertCrawlerMob.class})) {
                    if (RecraftEvents.should(0.1)) {
                        event.drops.add(MultiTextureMatItem.generateRandomItem((String)"brokenancientfossiltool", (Random)GameRandom.globalRandom));
                    }
                } else if (RecraftEvents.isMobAnyOf(event, new Class[]{SpiderkinMob.class, SpiderkinArcherMob.class, SpiderkinWarriorMob.class})) {
                    if (RecraftEvents.should(0.05)) {
                        event.drops.add(MultiTextureMatItem.generateRandomItem((String)"brokenspideritetool", (Random)GameRandom.globalRandom));
                    }
                } else if (RecraftEvents.isMobAnyOf(event, new Class[]{CryptVampireMob.class}) && RecraftEvents.should(0.05)) {
                    event.drops.add(MultiTextureMatItem.generateRandomItem((String)"brokennightsteeltool", (Random)GameRandom.globalRandom));
                }
            }
        });
        GameEvents.addListener(ItemProducedEvent.class, (GameEventInterface)new GameEventListener<ItemProducedEvent>(){

            public void onEvent(ItemProducedEvent event) {
                if (event.entity instanceof DisassemblerObjectEntity) {
                    DisassemblerObjectEntity entity = (DisassemblerObjectEntity)event.entity;
                    entity.consumeOneShred();
                    if (event.recipe.resultStringID.endsWith("seed")) {
                        entity.addSideproduct(new InventoryItem("spoiledfood", 1));
                    }
                }
            }
        });
    }

    public static void registerMobDrops() {
        MouseMob.lootTable.items.add(new ChanceLootItem(0.01f, "cheese"));
    }

    private static boolean isMobAnyOf(MobLootTableDropsEvent event, Class ... classes) {
        return Stream.of(classes).anyMatch(e -> event.mob.getClass().equals(e));
    }

    private static boolean should(double probability) {
        return GameRandom.getChance((Random)GameRandom.globalRandom, (double)probability);
    }
}

