/*
 * Decompiled with CFR 0.152.
 */
package recraft.containers.forms;

import necesse.engine.Settings;
import necesse.engine.localization.Localization;
import necesse.engine.network.client.Client;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.GameBackground;
import necesse.gfx.forms.components.containerSlot.FormContainerSlot;
import necesse.gfx.gameFont.FontOptions;
import necesse.gfx.gameTooltips.FairTypeTooltip;
import necesse.gfx.gameTooltips.GameTooltipManager;
import necesse.gfx.gameTooltips.GameTooltips;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.gfx.gameTooltips.TooltipLocation;
import necesse.inventory.container.Container;
import recraft.containers.AnythingFueledProcessingOEInventoryContainer;
import recraft.objects.entities.DisassemblerObjectEntity;
import recraft.util.Helper;

public class TooltippedFormContainerSlot
extends FormContainerSlot {
    private final AnythingFueledProcessingOEInventoryContainer oeInventoryContainer;

    public TooltippedFormContainerSlot(Client client, AnythingFueledProcessingOEInventoryContainer container, int containerSlotIndex, int x, int y) {
        super(client, (Container)container, containerSlotIndex, x, y);
        this.oeInventoryContainer = container;
    }

    public GameTooltips getClearTooltips() {
        if (this.client.getPlayer().getDraggingItem() == null && this.oeInventoryContainer.fueledProcessingObjectEntity instanceof DisassemblerObjectEntity) {
            FontOptions fontOptions = new FontOptions(Settings.tooltipTextSize).outline();
            ListGameTooltips tooltips = new ListGameTooltips();
            tooltips.add(String.format("%s:", Localization.translate((String)"ui", (String)"accepts")));
            ((DisassemblerObjectEntity)this.oeInventoryContainer.fueledProcessingObjectEntity).getAcceptedJawTypes().stream().map(jawType -> {
                String jawsItemId = Helper.jawTypeToItemNames.get(jawType);
                return Helper.itemToFairType(fontOptions, jawsItemId);
            }).forEach(fairType -> tooltips.add((Object)new FairTypeTooltip(fairType, 10)));
            return tooltips;
        }
        return super.getClearTooltips();
    }

    public void addClearTooltips(PlayerMob perspective) {
        GameTooltips clearTooltips = this.getClearTooltips();
        if (clearTooltips != null) {
            GameTooltipManager.addTooltip((GameTooltips)clearTooltips, (GameBackground)GameBackground.getItemTooltipBackground(), (TooltipLocation)TooltipLocation.FORM_FOCUS);
        }
    }
}

