/*
 * Decompiled with CFR 0.152.
 */
package recraft.containers.forms;

import java.util.function.Supplier;
import necesse.engine.network.client.Client;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.containerSlot.FormContainerSlot;
import necesse.gfx.forms.components.localComponents.FormLocalLabel;
import necesse.gfx.forms.presets.containerComponent.object.FuelContainerForm;
import necesse.gfx.gameFont.FontOptions;
import necesse.inventory.container.Container;
import necesse.inventory.container.customAction.BooleanCustomAction;
import recraft.containers.forms.FormSlotsInfo;

public class FuelWithSideproductContainerForm
extends FuelContainerForm {
    public FuelWithSideproductContainerForm(Client client, Container container, FormSlotsInfo fuelSlotsInfo, FormSlotsInfo toolSlotsInfo, FormSlotsInfo sideproductSlotsInfo, boolean alwaysOn, BooleanCustomAction setKeepRunning, Supplier<Boolean> keepRunningGetter, Supplier<Float> fuelProgressGetter) {
        super(client, container, fuelSlotsInfo.startSlot, fuelSlotsInfo.endSlot, fuelSlotsInfo.texture, alwaysOn, setKeepRunning, keepRunningGetter, fuelProgressGetter);
        if (sideproductSlotsInfo != null && sideproductSlotsInfo.isValid()) {
            this.addSideproductForm(client, container, sideproductSlotsInfo);
        }
        if (toolSlotsInfo != null && toolSlotsInfo.isValid()) {
            this.addToolForm(client, container, toolSlotsInfo);
        }
    }

    private void addSideproductForm(Client client, Container container, FormSlotsInfo slotsInfo) {
        int currentHeight = this.getHeight();
        this.addComponent((FormComponent)new FormLocalLabel("ui", "fuelSideproduct", new FontOptions(16), 0, this.getWidth() / 2, currentHeight - 10));
        int columns = 2;
        int sideproductsInventorySize = slotsInfo.endSlot - slotsInfo.startSlot + 1;
        int rows = (sideproductsInventorySize + columns - 1) / columns;
        this.setHeight(currentHeight + rows * 40 + 20);
        for (int i = slotsInfo.startSlot; i <= slotsInfo.endSlot; ++i) {
            int index = i - slotsInfo.startSlot;
            int column = index % columns;
            int row = index / columns;
            int slotsInRow = Math.min(sideproductsInventorySize - row * columns, columns);
            int xOffset = slotsInRow * 20;
            FormContainerSlot sideproductSlot = new FormContainerSlot(client, container, i, this.getWidth() / 2 + column * 40 - xOffset, row * 40 + 10 + currentHeight);
            if (slotsInfo.texture != null) {
                sideproductSlot.setDecal(slotsInfo.texture);
            }
            this.addComponent((FormComponent)sideproductSlot);
        }
    }

    private void addToolForm(Client client, Container container, FormSlotsInfo slotsInfo) {
    }
}

