/*
 * Decompiled with CFR 0.152.
 */
package recraft.containers.forms;

import java.awt.Rectangle;
import necesse.engine.Settings;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.localization.Localization;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.GameBackground;
import necesse.gfx.GameColor;
import necesse.gfx.forms.components.FormCustomDraw;
import necesse.gfx.forms.presets.containerComponent.object.ProcessingHelp;
import necesse.gfx.gameTooltips.GameTooltipManager;
import necesse.gfx.gameTooltips.GameTooltips;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.gfx.gameTooltips.SpacerGameTooltip;
import necesse.gfx.gameTooltips.StringTooltips;
import necesse.gfx.gameTooltips.TooltipLocation;
import recraft.objects.entities.DisassemblerObjectEntity;

public class FormJawsProcessingProgressArrow
extends FormCustomDraw {
    protected ProcessingHelp help;
    protected DisassemblerObjectEntity disassemblerObjectEntity;

    public FormJawsProcessingProgressArrow(int x, int y, ProcessingHelp help, DisassemblerObjectEntity disassemblerObjectEntity) {
        super(x, y, 32, 32);
        this.help = help;
        this.disassemblerObjectEntity = disassemblerObjectEntity;
    }

    public void draw(TickManager tickManager, PlayerMob perspective, Rectangle renderBox) {
        GameTooltips currentRecipeTooltip;
        Settings.UI.processing_arrow_empty.initDraw().draw(this.getX(), this.getY());
        if (this.help.isProcessing()) {
            float progress = this.help.getProcessingProgress();
            int leftPadding = 2;
            int rightPadding = 2;
            int width = Settings.UI.processing_arrow_full.getWidth() - (leftPadding + rightPadding);
            Settings.UI.processing_arrow_full.initDraw().section(leftPadding, leftPadding + (int)((float)width * progress), 0, Settings.UI.processing_arrow_full.getHeight()).draw(this.getX() + leftPadding, this.getY());
            if (this.isHovering()) {
                ListGameTooltips tooltips = new ListGameTooltips();
                GameTooltips currentRecipeTooltip2 = this.help.getCurrentRecipeTooltip(perspective);
                if (currentRecipeTooltip2 != null) {
                    tooltips.add((Object)currentRecipeTooltip2);
                    tooltips.add((Object)new SpacerGameTooltip(5));
                }
                tooltips.add((int)(progress * 100.0f) + "%");
                if (currentRecipeTooltip2 != null) {
                    GameTooltipManager.addTooltip((GameTooltips)tooltips, (GameBackground)GameBackground.getItemTooltipBackground(), (TooltipLocation)TooltipLocation.FORM_FOCUS);
                } else {
                    GameTooltipManager.addTooltip((GameTooltips)tooltips, (TooltipLocation)TooltipLocation.FORM_FOCUS);
                }
            }
        } else if (this.isHovering() && (currentRecipeTooltip = this.help.getCurrentRecipeTooltip(perspective)) != null) {
            ListGameTooltips tooltips = new ListGameTooltips(currentRecipeTooltip);
            if (this.help.needsFuel()) {
                tooltips.add((Object)new StringTooltips(Localization.translate((String)"ui", (String)"needfuel"), GameColor.RED));
            }
            if (!this.disassemblerObjectEntity.areJawsStrongEnough()) {
                tooltips.add((Object)new StringTooltips(Localization.translate((String)"ui", (String)"needstrongerjaws"), GameColor.RED));
            }
            GameTooltipManager.addTooltip((GameTooltips)tooltips, (GameBackground)GameBackground.getItemTooltipBackground(), (TooltipLocation)TooltipLocation.FORM_FOCUS);
        }
    }
}

