/*
 * Decompiled with CFR 0.152.
 */
package recraft.containers.forms;

import java.awt.Rectangle;
import java.util.Objects;
import java.util.function.Supplier;
import necesse.engine.Settings;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.client.Client;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormFlow;
import necesse.gfx.forms.components.containerSlot.FormContainerProcessingRecipeSlot;
import necesse.gfx.forms.components.containerSlot.FormContainerSlot;
import necesse.gfx.forms.position.FormPosition;
import necesse.gfx.forms.position.FormPositionContainer;
import necesse.gfx.forms.position.FormRelativePosition;
import necesse.gfx.forms.presets.containerComponent.ContainerFormList;
import necesse.gfx.forms.presets.containerComponent.object.FuelContainerForm;
import necesse.gfx.forms.presets.containerComponent.object.OEInventoryContainerForm;
import necesse.gfx.forms.presets.containerComponent.object.ProcessingHelp;
import necesse.gfx.gameTexture.GameTexture;
import necesse.inventory.container.Container;
import necesse.inventory.container.customAction.BooleanCustomAction;
import necesse.inventory.container.object.FueledProcessingOEInventoryContainer;
import recraft.containers.AnythingFueledProcessingOEInventoryContainer;
import recraft.containers.forms.FormJawsProcessingProgressArrow;
import recraft.containers.forms.FormSlotsInfo;
import recraft.containers.forms.FuelWithSideproductContainerForm;
import recraft.containers.forms.TooltippedFormContainerSlot;
import recraft.objects.entities.AnythingFueledProcessingTechInventoryObjectEntity;
import recraft.objects.entities.DisassemblerObjectEntity;

public class AnythingFueledProcessingInventoryContainerForm
extends ContainerFormList<AnythingFueledProcessingOEInventoryContainer> {
    protected OEInventoryContainerForm<FueledProcessingOEInventoryContainer> containerForm;
    protected FuelContainerForm fuelForm;

    public AnythingFueledProcessingInventoryContainerForm(Client client, AnythingFueledProcessingOEInventoryContainer container, GameTexture fuelTexture, GameTexture sideproductTexture, GameTexture toolTexture) {
        super(client, (Container)container);
        final int fuelSlots = container.fueledProcessingObjectEntity.fuelSlots;
        final int sideproductSlots = container.fueledProcessingObjectEntity.sideproductSlots;
        final int toolSlots = container.fueledProcessingObjectEntity.toolSlots;
        final int inputSlots = container.fueledProcessingObjectEntity.inputSlots;
        this.containerForm = (OEInventoryContainerForm)this.addComponent((FormComponent)new OEInventoryContainerForm<AnythingFueledProcessingOEInventoryContainer>(client, container){

            protected void addSlots(FormFlow flow) {
                this.slots = new FormContainerSlot[((AnythingFueledProcessingOEInventoryContainer)this.container).INVENTORY_END - ((AnythingFueledProcessingOEInventoryContainer)this.container).INVENTORY_START + 1 - fuelSlots - sideproductSlots - toolSlots];
                ProcessingHelp processingHelp = ((AnythingFueledProcessingOEInventoryContainer)this.container).fueledProcessingObjectEntity.getProcessingHelp();
                int startY = flow.next();
                int centerWidth = 40;
                for (int i = 0; i < this.slots.length; ++i) {
                    int y;
                    int x;
                    int sideWidth;
                    int slotIndex = i + ((AnythingFueledProcessingOEInventoryContainer)this.container).INVENTORY_START + fuelSlots + sideproductSlots + toolSlots;
                    if (i < inputSlots) {
                        sideWidth = inputSlots * 40;
                        x = this.inventoryForm.getWidth() / 2 - sideWidth - centerWidth / 2 + i % 4 * 40;
                        y = i / 4 * 40;
                    } else {
                        sideWidth = i - inputSlots;
                        x = this.inventoryForm.getWidth() / 2 + centerWidth / 2 + sideWidth % 4 * 40;
                        y = sideWidth / 4 * 40;
                    }
                    this.slots[i] = (FormContainerSlot)this.inventoryForm.addComponent((FormComponent)new FormContainerProcessingRecipeSlot(this.client, this.container, slotIndex, x, startY + y, processingHelp));
                    if (flow.next() >= startY + y + 40) continue;
                    flow.next(startY + y + 40 - flow.next());
                }
            }
        });
        FormSlotsInfo fuelSlotsInfo = new FormSlotsInfo(fuelTexture, container.INVENTORY_START, container.INVENTORY_START + fuelSlots - 1);
        FormSlotsInfo sideproductSlotsInfo = new FormSlotsInfo(sideproductTexture, fuelSlotsInfo.endSlot + 1, fuelSlotsInfo.endSlot + sideproductSlots);
        FormSlotsInfo toolSlotsInfo = new FormSlotsInfo(toolTexture, sideproductSlotsInfo.endSlot + 1, sideproductSlotsInfo.endSlot + toolSlots);
        FormJawsProcessingProgressArrow arrow = new FormJawsProcessingProgressArrow(this.containerForm.inventoryForm.getWidth() / 2 - 16, 30 + (this.containerForm.inventoryForm.getHeight() - 30) / 2 - 16, container.fueledProcessingObjectEntity.getProcessingHelp(), (DisassemblerObjectEntity)container.fueledProcessingObjectEntity);
        this.containerForm.inventoryForm.addComponent((FormComponent)arrow);
        if (toolSlots > 0) {
            TooltippedFormContainerSlot toolSlot = new TooltippedFormContainerSlot(client, container, toolSlotsInfo.startSlot, this.containerForm.inventoryForm.getWidth() / 2 - 20, arrow.getY() + 32 + 2);
            this.containerForm.inventoryForm.addComponent((FormComponent)toolSlot);
            if (toolSlotsInfo.texture != null) {
                toolSlot.setDecal(toolSlotsInfo.texture);
            }
            this.containerForm.inventoryForm.setHeight(this.containerForm.inventoryForm.getHeight() + 42);
        }
        boolean fuelAlwaysOn = container.fueledProcessingObjectEntity.fuelAlwaysOn;
        BooleanCustomAction keepRunningAction = container.fueledProcessingObjectEntity.shouldBeAbleToChangeKeepFuelRunning() ? container.setKeepRunning : null;
        AnythingFueledProcessingTechInventoryObjectEntity fueledProcessingObjectEntity = container.fueledProcessingObjectEntity;
        Objects.requireNonNull(fueledProcessingObjectEntity);
        Supplier<Boolean> shouldKeepFuelRunning = fueledProcessingObjectEntity::shouldKeepFuelRunning;
        this.fuelForm = (FuelContainerForm)this.addComponent((FormComponent)new FuelWithSideproductContainerForm(client, (Container)container, fuelSlotsInfo, null, sideproductSlotsInfo, fuelAlwaysOn, keepRunningAction, shouldKeepFuelRunning, fueledProcessingObjectEntity::getFuelProgress));
        this.fuelForm.setPosition((FormPosition)new FormRelativePosition((FormPositionContainer)this.containerForm.inventoryForm, -this.fuelForm.getWidth() - Settings.UI.formSpacing, -Math.max(0, this.fuelForm.getHeight() - this.containerForm.inventoryForm.getHeight())));
    }

    public boolean shouldOpenInventory() {
        return true;
    }

    public void draw(TickManager tickManager, PlayerMob perspective, Rectangle renderBox) {
        this.fuelForm.setHidden(!this.containerForm.isCurrent((FormComponent)this.containerForm.inventoryForm));
        super.draw(tickManager, perspective, renderBox);
    }
}

