/*
 * Decompiled with CFR 0.152.
 */
package zoomout.patches;

import necesse.engine.GlobalData;
import necesse.engine.Settings;
import necesse.engine.commands.CommandLog;
import necesse.engine.commands.clientCommands.ZoomClientCommand;
import necesse.engine.modLoader.annotations.ModMethodPatch;
import necesse.engine.network.client.Client;
import necesse.engine.network.server.Server;
import necesse.engine.network.server.ServerClient;
import necesse.engine.window.WindowManager;
import net.bytebuddy.asm.Advice;

@ModMethodPatch(target=ZoomClientCommand.class, name="runModular", arguments={Client.class, Server.class, ServerClient.class, Object[].class, String[].class, CommandLog.class})
public class ZoomCommandPatch {
    @Advice.OnMethodEnter(skipOn=Advice.OnNonDefaultValue.class)
    static boolean onEnter() {
        return true;
    }

    @Advice.OnMethodExit
    static void onExit(@Advice.This ZoomClientCommand __instance, @Advice.Argument(value=3) Object[] args, @Advice.Argument(value=5) CommandLog logs) {
        int level = (Integer)args[0];
        if (GlobalData.isDevMode() || level >= 25 && level <= 400) {
            Settings.sceneSize = (float)level / 100.0f;
            WindowManager.getWindow().updateSceneSize();
            Settings.saveClientSettings();
            logs.add("Changed zoom level to " + level + "%");
        } else {
            logs.add("Zoom percent must be between 25 and 400");
        }
    }
}

