/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonweapons;

import necesse.engine.localization.Localization;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.util.GameBlackboard;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.toolItem.projectileToolItem.throwToolItem.boomerangToolItem.BoomerangToolItem;
import necesse.inventory.item.upgradeUtils.IntUpgradeValue;
import necesse.inventory.lootTable.presets.SummonWeaponsLootTable;
import necesse.level.maps.Level;

public class WormBucket
extends BoomerangToolItem {
    public IntUpgradeValue wormAmount = new IntUpgradeValue().setBaseValue(1);

    public WormBucket() {
        super(200, SummonWeaponsLootTable.summonWeapons, "wormproj");
        this.rarity = Item.Rarity.COMMON;
        this.damageType = DamageTypeRegistry.SUMMON;
        this.attackDamage.setBaseValue(10.0f).setUpgradedValue(1.0f, 35.0f);
        this.attackAnimTime.setBaseValue(300).setUpgradedValue(1.0f, 280);
        this.resilienceGain.setBaseValue(0.0f).setUpgradedValue(1.0f, 0.1f).setUpgradedValue(10.0f, 0.2f);
        this.attackRange.setBaseValue(400);
        this.velocity.setBaseValue(100).setUpgradedValue(1.0f, 120);
        this.wormAmount.setBaseValue(1).setUpgradedValue(1.0f, 2).setUpgradedValue(3.0f, 3).setUpgradedValue(5.0f, 4);
        this.canBeUsedForRaids = true;
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getPreEnchantmentTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"wormbuckettip"));
        return tooltips;
    }

    public String canAttack(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item) {
        return attackerMob.getBoomerangsUsage() < this.wormAmount.getValue(this.getUpgradeTier(item)) ? null : "";
    }
}

