/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonweapons;

import java.awt.Point;
import java.awt.geom.Point2D;
import necesse.engine.localization.Localization;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameUtils;
import necesse.engine.util.Ray;
import necesse.engine.util.RayLinkedList;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.itemAttacker.FollowPosition;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.projectile.Projectile;
import necesse.gfx.drawOptions.itemAttack.ItemAttackDrawOptions;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.arrowItem.ArrowItem;
import necesse.inventory.item.toolItem.projectileToolItem.bowProjectileToolItem.BowProjectileToolItem;
import necesse.inventory.item.upgradeUtils.IntUpgradeValue;
import necesse.inventory.lootTable.presets.SummonWeaponsLootTable;
import necesse.level.maps.CollisionFilter;
import necesse.level.maps.Level;
import summonerexpansion.summonminions.BowMosquitoMinion;
import summonerexpansion.summonprojs.MosquitoBowProj;

public class MosquitoBow
extends BowProjectileToolItem {
    public IntUpgradeValue maxMosquitos = new IntUpgradeValue(4, 0.0f);
    public int mosquitoStack;
    public int projectileMaxHeight;

    public MosquitoBow() {
        super(200, SummonWeaponsLootTable.summonWeapons);
        this.rarity = Item.Rarity.COMMON;
        this.damageType = DamageTypeRegistry.SUMMON;
        this.attackDamage.setBaseValue(40.0f).setUpgradedValue(1.0f, 75.0f);
        this.resilienceGain.setBaseValue(0.0f).setUpgradedValue(1.0f, 0.5f);
        this.attackAnimTime.setBaseValue(1500);
        this.attackRange.setBaseValue(1600);
        this.velocity.setBaseValue(350);
        this.projectileMaxHeight = 600;
        this.attackXOffset = 12;
        this.attackYOffset = 28;
        this.canBeUsedForRaids = true;
        this.maxMosquitos.setBaseValue(4).setUpgradedValue(1.0f, 6).setUpgradedValue(5.0f, 8);
    }

    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        BowMosquitoMinion mob = new BowMosquitoMinion();
        attackerMob.serverFollowersManager.addFollower("mosquitobowminion", (Mob)mob, FollowPosition.WALK_CLOSE, "summonedmob", 1.0f, this.maxMosquitos.getValue(this.getUpgradeTier(item)).intValue(), null, false);
        mob.updateDamage(this.getAttackDamage(item));
        mob.setEnchantment(this.getEnchantment(item));
        if (++this.mosquitoStack >= 20) {
            attackerMob.getLevel().entityManager.addMob((Mob)mob, attackerMob.x, attackerMob.y);
            this.mosquitoStack = 0;
        }
        return super.onAttack(level, x, y, attackerMob, attackHeight, item, slot, animAttack, seed, mapContent);
    }

    public Point getItemAttackerAttackPosition(Level level, ItemAttackerMob attackerMob, Mob target, int seed, InventoryItem item) {
        int travelTime = (int)Projectile.getTravelTimeMillis((float)this.getProjectileVelocity(item, (Mob)attackerMob), (float)(this.projectileMaxHeight * 2));
        return this.applyInaccuracy(attackerMob, item, this.getPredictedItemAttackerAttackPositionMillis(target, travelTime));
    }

    public MosquitoBowProj getMosquitoBowProjectile(Level level, int x, int y, Mob owner, GameDamage damage, float velocity, int knockback, float resilienceGain) {
        Point2D.Float targetPoints = new Point2D.Float(x, y);
        Point2D.Float normalizedVector = GameMath.normalize((float)(targetPoints.x - owner.x), (float)(targetPoints.y - owner.y));
        RayLinkedList hits = GameUtils.castRay((Level)level, (double)owner.x, (double)owner.y, (double)normalizedVector.x, (double)normalizedVector.y, (double)targetPoints.distance(owner.x, owner.y), (int)0, (CollisionFilter)new CollisionFilter().projectileCollision().addFilter(tp -> tp.object().object.isWall || tp.object().object.isRock));
        if (!hits.isEmpty()) {
            Ray first = (Ray)hits.getLast();
            targetPoints.x = (float)first.x2;
            targetPoints.y = (float)first.y2;
        }
        return new MosquitoBowProj(level, owner, owner.x, owner.y, owner.x, owner.y - 1.0f, velocity, this.projectileMaxHeight, damage, resilienceGain, knockback, targetPoints, false);
    }

    public void setDrawAttackRotation(InventoryItem item, ItemAttackDrawOptions drawOptions, float attackDirX, float attackDirY, float attackProgress) {
        drawOptions.rotation(-85.0f);
    }

    public Projectile getProjectile(Level level, int x, int y, ItemAttackerMob owner, InventoryItem item, int seed, ArrowItem arrow, boolean consumeAmmo, float velocity, int range, GameDamage damage, int knockback, float resilienceGain, GNDItemMap mapContent) {
        return this.getMosquitoBowProjectile(level, x, y, (Mob)owner, damage, velocity, knockback, resilienceGain);
    }

    protected void addExtraBowTooltips(ListGameTooltips tooltips, InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        super.addExtraBowTooltips(tooltips, item, perspective, blackboard);
    }

    protected void addAmmoTooltips(ListGameTooltips tooltips, InventoryItem item) {
        super.addAmmoTooltips(tooltips, item);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"mosquitobowtip"), 900);
    }

    public Point getControllerAttackLevelPos(Level level, float aimDirX, float aimDirY, PlayerMob player, InventoryItem item) {
        float range = 500.0f;
        return new Point((int)(player.x + aimDirX * range), (int)(player.y + aimDirY * range));
    }
}

