/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonweapons;

import java.awt.geom.Point2D;
import necesse.engine.localization.Localization;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.itemAttacker.FollowPosition;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.gfx.GameResources;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.ItemCategory;
import necesse.inventory.item.toolItem.projectileToolItem.throwToolItem.SettlerIgnoredThrowToolItem;
import necesse.level.maps.Level;
import summonerexpansion.summonminions.LeafShotColdSentry;

public class LeafShotColdPack
extends SettlerIgnoredThrowToolItem {
    public LeafShotColdPack() {
        this.rarity = Item.Rarity.COMMON;
        this.damageType = DamageTypeRegistry.SUMMON;
        this.attackAnimTime.setBaseValue(300);
        this.attackDamage.setBaseValue(20.0f);
        this.stackSize = 250;
        this.setItemCategory(new String[]{"equipment", "weapons", "summonweapons"});
        this.setItemCategory(ItemCategory.equipmentManager, new String[]{"weapons", "summonweapons"});
        this.setItemCategory(ItemCategory.craftingManager, new String[]{"equipment", "weapons", "summonweapons"});
        this.keyWords.add("summon");
    }

    public void showAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, int animAttack, int seed, GNDItemMap mapContent) {
        if (level.isClient()) {
            SoundManager.playSound((GameSound)GameResources.magicbolt4, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(0.3f).pitch(GameRandom.globalRandom.getFloatBetween(1.6f, 1.8f)));
        }
    }

    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        InventoryItem out = super.onAttack(level, x, y, attackerMob, attackHeight, item, slot, animAttack, seed, mapContent);
        if (animAttack == 0 && attackerMob.isServer()) {
            LeafShotColdSentry mob = new LeafShotColdSentry();
            Point2D.Float dir = GameMath.normalize((float)((float)x - attackerMob.x), (float)((float)y - attackerMob.y + (float)attackHeight));
            attackerMob.serverFollowersManager.addFollower("plantsentry", (Mob)mob, FollowPosition.WALK_CLOSE, "summonedmob", 1.0f, 6, null, false);
            mob.updateDamage(this.getAttackDamage(item));
            mob.setEnchantment(this.getEnchantment(item));
            mob.dx = dir.x * 300.0f;
            mob.dy = dir.y * 300.0f;
            attackerMob.getLevel().entityManager.addMob((Mob)mob, attackerMob.x + dir.x, attackerMob.y + dir.y);
            item.setAmount(item.getAmount() - 1);
        }
        return item;
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getPreEnchantmentTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"sentrytip"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"leafshotcoldpacktip"));
        return tooltips;
    }
}

