/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonweapons;

import necesse.engine.localization.Localization;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.registries.ProjectileRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.itemAttacker.FollowPosition;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.modifiers.ProjectileModifier;
import necesse.entity.projectile.modifiers.ResilienceOnHitProjectileModifier;
import necesse.gfx.GameResources;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.ItemInteractAction;
import necesse.inventory.item.toolItem.projectileToolItem.magicProjectileToolItem.MagicProjectileToolItem;
import necesse.inventory.item.upgradeUtils.IntUpgradeValue;
import necesse.inventory.lootTable.presets.SummonWeaponsLootTable;
import necesse.level.maps.Level;
import summonerexpansion.summonminions.IceBlossomSentry;
import summonerexpansion.summonminions.IceBlossomSentryT1;
import summonerexpansion.summonminions.IceBlossomSentryT5;

public class IceBlossomStaff
extends MagicProjectileToolItem
implements ItemInteractAction {
    public IntUpgradeValue sentryLevel = new IntUpgradeValue().setBaseValue(2);

    public IceBlossomStaff() {
        super(200, SummonWeaponsLootTable.summonWeapons);
        this.rarity = Item.Rarity.COMMON;
        this.damageType = DamageTypeRegistry.SUMMON;
        this.attackDamage.setBaseValue(25.0f).setUpgradedValue(1.0f, 155.0f);
        this.manaCost.setBaseValue(1.75f).setUpgradedValue(1.0f, 4.0f);
        this.resilienceGain.setBaseValue(0.0f).setUpgradedValue(1.0f, 1.0f);
        this.attackAnimTime.setBaseValue(800);
        this.attackRange.setBaseValue(700).setUpgradedValue(1.0f, 1000);
        this.velocity.setBaseValue(60).setUpgradedValue(1.0f, 70).setUpgradedValue(5.0f, 150);
        this.sentryLevel.setBaseValue(1).setUpgradedValue(1.0f, 2).setUpgradedValue(5.0f, 3);
        this.knockback.setBaseValue(20);
        this.attackXOffset = 20;
        this.attackYOffset = 20;
        this.itemAttackerProjectileCanHitWidth = 5.0f;
        this.itemAttackerPredictionDistanceOffset = -20.0f;
        this.canBeUsedForRaids = false;
    }

    public void showAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, int animAttack, int seed, GNDItemMap mapContent) {
        if (level.isClient()) {
            SoundManager.playSound((GameSound)GameResources.magicbolt2, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(0.4f).pitch(GameRandom.globalRandom.getFloatBetween(0.8f, 0.9f)));
        }
    }

    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        Projectile projectile = ProjectileRegistry.getProjectile((String)"iceblossomproj", (Level)level, (float)attackerMob.x, (float)attackerMob.y, (float)x, (float)y, (float)this.getProjectileVelocity(item, (Mob)attackerMob), (int)this.getAttackRange(item), (GameDamage)this.getAttackDamage(item), (int)this.getKnockback(item, (Attacker)attackerMob), (Mob)attackerMob);
        projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item)));
        GameRandom random = new GameRandom((long)seed);
        projectile.resetUniqueID(random);
        attackerMob.addAndSendAttackerProjectile(projectile, 20);
        this.consumeMana(attackerMob, item);
        return item;
    }

    public boolean canLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item) {
        return true;
    }

    public InventoryItem onLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int seed, GNDItemMap mapContent) {
        if (attackerMob.isServer()) {
            if (this.sentryLevel.getValue(this.getUpgradeTier(item)) == 1) {
                IceBlossomSentry mob1 = new IceBlossomSentry();
                attackerMob.serverFollowersManager.addFollower("iceblossomsentry", (Mob)mob1, FollowPosition.WALK_CLOSE, "summonedmob", 1.0f, 1, null, false);
                attackerMob.getLevel().entityManager.addMob((Mob)mob1, attackerMob.x, attackerMob.y);
            }
            if (this.sentryLevel.getValue(this.getUpgradeTier(item)) == 2) {
                IceBlossomSentryT1 mob2 = new IceBlossomSentryT1();
                attackerMob.serverFollowersManager.addFollower("iceblossomsentryt1", (Mob)mob2, FollowPosition.WALK_CLOSE, "summonedmob", 1.0f, 1, null, false);
                attackerMob.getLevel().entityManager.addMob((Mob)mob2, attackerMob.x, attackerMob.y);
            }
            if (this.sentryLevel.getValue(this.getUpgradeTier(item)) > 2) {
                IceBlossomSentryT5 mob3 = new IceBlossomSentryT5();
                attackerMob.serverFollowersManager.addFollower("iceblossomsentryt5", (Mob)mob3, FollowPosition.WALK_CLOSE, "summonedmob", 1.0f, 1, null, false);
                attackerMob.getLevel().entityManager.addMob((Mob)mob3, attackerMob.x, attackerMob.y);
            }
        }
        return item;
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getPreEnchantmentTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"clicksentrytip"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"iceblossomsentrytip"));
        return tooltips;
    }
}

