/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonweapons;

import java.awt.Color;
import necesse.engine.localization.Localization;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.util.GameBlackboard;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.attackHandler.AttackHandler;
import necesse.entity.mobs.attackHandler.GreatswordChargeLevel;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.toolItem.swordToolItem.greatswordToolItem.GreatswordToolItem;
import necesse.inventory.lootTable.presets.SummonWeaponsLootTable;
import necesse.level.maps.Level;
import summonerexpansion.summonothers.HorrorScytheHandler;

public class HorrorScythe
extends GreatswordToolItem {
    public HorrorScythe() {
        super(800, SummonWeaponsLootTable.summonWeapons, HorrorScythe.getChargeLevels(600, 800, 1200));
        this.rarity = Item.Rarity.EPIC;
        this.damageType = DamageTypeRegistry.SUMMON;
        this.attackDamage.setBaseValue(60.0f).setUpgradedValue(1.0f, 65.0f);
        this.resilienceGain.setBaseValue(0.0f).setUpgradedValue(1.0f, 1.0f).setUpgradedValue(10.0f, 1.2f);
        this.attackRange.setBaseValue(80);
        this.knockback.setBaseValue(120);
        this.attackXOffset = 12;
        this.attackYOffset = 14;
        this.canBeUsedForRaids = true;
    }

    public static GreatswordChargeLevel[] getChargeLevels(int level1Time, int level2Time, int level3Time) {
        return new GreatswordChargeLevel[]{new GreatswordChargeLevel(level1Time, 1.0f, new Color(10, 10, 10, 255)), new GreatswordChargeLevel(level2Time, 1.5f, new Color(30, 20, 20)), new GreatswordChargeLevel(level3Time, 2.0f, new Color(50, 20, 20))};
    }

    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        attackerMob.startAttackHandler((AttackHandler)new HorrorScytheHandler(attackerMob, slot, item, this, seed, x, y, this.chargeLevels));
        return item;
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getPreEnchantmentTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"horrorscythetip"));
        return tooltips;
    }
}

