/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonweapons;

import java.awt.Color;
import java.awt.geom.Point2D;
import necesse.engine.localization.Localization;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.ParticleTypeSwitcher;
import necesse.entity.levelEvent.GlaiveShowAttackEvent;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.levelEvent.mobAbilityLevelEvent.ToolItemMobAbilityEvent;
import necesse.entity.mobs.AttackAnimMob;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.itemAttacker.FollowPosition;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.ItemInteractAction;
import necesse.inventory.item.toolItem.glaiveToolItem.GlaiveToolItem;
import necesse.inventory.lootTable.presets.SummonWeaponsLootTable;
import necesse.level.maps.Level;
import summonerexpansion.summonminions.HorrorSentry;

public class HorrorGlaive
extends GlaiveToolItem
implements ItemInteractAction {
    public HorrorGlaive() {
        super(800, SummonWeaponsLootTable.summonWeapons);
        this.rarity = Item.Rarity.UNCOMMON;
        this.damageType = DamageTypeRegistry.SUMMON;
        this.attackDamage.setBaseValue(35.0f).setUpgradedValue(1.0f, 75.0f);
        this.attackAnimTime.setBaseValue(600);
        this.resilienceGain.setBaseValue(0.0f).setUpgradedValue(1.0f, 0.5f);
        this.attackRange.setBaseValue(200);
        this.knockback.setBaseValue(150);
        this.attackXOffset = 74;
        this.attackYOffset = 74;
        this.width = 20.0f;
        this.canBeUsedForRaids = true;
    }

    public void showAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, int animAttack, int seed, GNDItemMap mapContent) {
        super.showAttack(level, x, y, attackerMob, attackHeight, item, animAttack, seed, mapContent);
        if (level.isClient()) {
            level.entityManager.addLevelEventHidden((LevelEvent)new GlaiveShowAttackEvent((AttackAnimMob)attackerMob, x, y, seed, 10.0f){

                public void tick(float angle) {
                    GameRandom gameRandom = new GameRandom();
                    float colorModifier = gameRandom.getFloatBetween(0.0f, 1.0f);
                    Color randomColor = HorrorGlaive.this.getParticleColor(colorModifier);
                    Point2D.Float angleDir = this.getAngleDir(angle);
                    this.level.entityManager.addParticle(this.attackMob.x + angleDir.x * 85.0f + (float)this.attackMob.getCurrentAttackDrawXOffset(), this.attackMob.y + angleDir.y * 85.0f + (float)this.attackMob.getCurrentAttackDrawYOffset(), Particle.GType.COSMETIC).sprite(GameResources.bubbleParticle.sprite(0, 0, 12)).color(randomColor).movesConstant(angleDir.x * 40.0f, angleDir.y * 40.0f).lifeTime(400);
                    this.level.entityManager.addParticle(this.attackMob.x - angleDir.x * 85.0f + (float)this.attackMob.getCurrentAttackDrawXOffset(), this.attackMob.y - angleDir.y * 85.0f + (float)this.attackMob.getCurrentAttackDrawYOffset(), Particle.GType.COSMETIC).sprite(GameResources.bubbleParticle.sprite(0, 0, 12)).color(randomColor).movesConstant(angleDir.x * -40.0f, angleDir.y * -40.0f).lifeTime(400);
                }
            });
        }
    }

    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        if (attackerMob.buffManager.getStacks(BuffRegistry.getBuff((String)"horrorglaivestack")) >= 100) {
            int particleCount = 25;
            GameRandom random = GameRandom.globalRandom;
            ParticleTypeSwitcher typeSwitcher = new ParticleTypeSwitcher(new Particle.GType[]{Particle.GType.CRITICAL, Particle.GType.IMPORTANT_COSMETIC, Particle.GType.COSMETIC});
            float anglePerParticle = 360.0f / (float)particleCount;
            for (int i = 0; i < particleCount; ++i) {
                int angle = (int)((float)i * anglePerParticle + random.nextFloat() * anglePerParticle);
                float dx = (float)Math.sin(Math.toRadians(angle)) * 50.0f;
                float dy = (float)Math.cos(Math.toRadians(angle)) * 50.0f;
                attackerMob.getLevel().entityManager.addParticle((Entity)attackerMob, typeSwitcher.next()).sprite(GameResources.magicSparkParticles.sprite(random.nextInt(4), 0, 22)).sizeFades(22, 44).movesFriction(dx * 2.0f, dy * 2.0f, 0.8f).color(new Color(98, 0, 0)).givesLight(247.0f, 0.3f).heightMoves(0.0f, 30.0f).lifeTime(1500);
            }
        }
        return super.onAttack(level, x, y, attackerMob, attackHeight, item, slot, animAttack, seed, mapContent);
    }

    public void hitMob(InventoryItem item, ToolItemMobAbilityEvent event, Level level, Mob target, Mob attacker) {
        super.hitMob(item, event, level, target, attacker);
        if (attacker.isServer()) {
            ActiveBuff ab = new ActiveBuff(BuffRegistry.getBuff((String)"horrorglaivestack"), attacker, 30.0f, (Attacker)attacker);
            attacker.addBuff(ab, true);
        }
    }

    public boolean canLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item) {
        return !attackerMob.buffManager.hasBuff(BuffRegistry.getBuff((String)"horrorglaivecooldowndebuff")) && attackerMob.buffManager.getStacks(BuffRegistry.getBuff((String)"horrorglaivestack")) >= 100;
    }

    public float getItemCooldownPercent(InventoryItem item, PlayerMob perspective) {
        return perspective.buffManager.getBuffDurationLeftSeconds(BuffRegistry.getBuff((String)"horrorglaivecooldowndebuff")) / 12.0f;
    }

    public InventoryItem onLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int seed, GNDItemMap mapContent) {
        attackerMob.buffManager.addBuff(new ActiveBuff(BuffRegistry.getBuff((String)"horrorglaivecooldowndebuff"), (Mob)attackerMob, 12.0f, null), false);
        if (attackerMob.isServer() && attackerMob.buffManager.getStacks(BuffRegistry.getBuff((String)"horrorglaivestack")) >= 100) {
            HorrorSentry mob1 = new HorrorSentry();
            attackerMob.serverFollowersManager.addFollower("horrorspikesentry", (Mob)mob1, FollowPosition.WALK_CLOSE, "summonedmob", 1.0f, 5, null, false);
            mob1.updateDamage(this.getAttackDamage(item));
            mob1.setEnchantment(this.getEnchantment(item));
            attackerMob.getLevel().entityManager.addMob((Mob)mob1, attackerMob.x, attackerMob.y);
            attackerMob.buffManager.removeBuff("horrorglaivestack", true);
        }
        return item;
    }

    private Color getParticleColor(float modifier) {
        return new Color((int)(10.0f * (1.0f + 1.8f * modifier)), (int)(10.0f * (1.0f + 0.3f * modifier)), (int)(10.0f * (1.0f + 0.2f * modifier)));
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getPreEnchantmentTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"horrorglaivetip"));
        return tooltips;
    }
}

