/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonweapons;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import necesse.engine.localization.Localization;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.util.GameBlackboard;
import necesse.entity.levelEvent.mobAbilityLevelEvent.ToolItemMobAbilityEvent;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.itemAttacker.FollowPosition;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.ItemControllerInteract;
import necesse.inventory.item.ItemInteractAction;
import necesse.inventory.item.toolItem.swordToolItem.SwordToolItem;
import necesse.inventory.lootTable.presets.SummonWeaponsLootTable;
import necesse.level.maps.Level;
import summonerexpansion.summonminions.GoblinChestMinion;
import summonerexpansion.summonminions.GoblinHeadMinion;
import summonerexpansion.summonminions.GoblinLegMinion;

public class GoblinSword
extends SwordToolItem
implements ItemInteractAction {
    public GoblinSword() {
        super(400, SummonWeaponsLootTable.summonWeapons);
        this.rarity = Item.Rarity.UNCOMMON;
        this.damageType = DamageTypeRegistry.SUMMON;
        this.attackDamage.setBaseValue(20.0f).setUpgradedValue(1.0f, 100.0f);
        this.attackAnimTime.setBaseValue(300);
        this.resilienceGain.setBaseValue(0.0f).setUpgradedValue(1.0f, 0.1f).setUpgradedValue(10.0f, 0.2f);
        this.attackRange.setBaseValue(60);
        this.knockback.setBaseValue(75);
        this.canBeUsedForRaids = true;
    }

    public void hitMob(InventoryItem item, ToolItemMobAbilityEvent event, Level level, Mob target, Mob attacker) {
        super.hitMob(item, event, level, target, attacker);
        if (attacker.isServer()) {
            ActiveBuff ab = new ActiveBuff(BuffRegistry.getBuff((String)"goblinswordstack"), attacker, 30.0f, (Attacker)attacker);
            attacker.addBuff(ab, true);
        }
    }

    public boolean canLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item) {
        return !attackerMob.buffManager.hasBuff(BuffRegistry.getBuff((String)"goblincooldowndebuff")) && attackerMob.buffManager.getStacks(BuffRegistry.getBuff((String)"goblinswordstack")) >= 50;
    }

    public float getItemCooldownPercent(InventoryItem item, PlayerMob perspective) {
        return perspective.buffManager.getBuffDurationLeftSeconds(BuffRegistry.getBuff((String)"goblincooldowndebuff")) / 12.0f;
    }

    public InventoryItem onLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int seed, GNDItemMap mapContent) {
        attackerMob.buffManager.addBuff(new ActiveBuff(BuffRegistry.getBuff((String)"goblincooldowndebuff"), (Mob)attackerMob, 60.0f, null), false);
        if (attackerMob.isServer() && attackerMob.buffManager.getStacks(BuffRegistry.getBuff((String)"goblinswordstack")) >= 50) {
            GoblinHeadMinion mob1 = new GoblinHeadMinion();
            attackerMob.serverFollowersManager.addFollower("goblinheadminion", (Mob)mob1, FollowPosition.WALK_CLOSE, "summonedmob", 1.0f, 1, null, false);
            mob1.updateDamage(this.getAttackDamage(item));
            mob1.setEnchantment(this.getEnchantment(item));
            attackerMob.getLevel().entityManager.addMob((Mob)mob1, attackerMob.x, attackerMob.y - 50.0f);
            GoblinChestMinion mob2 = new GoblinChestMinion();
            attackerMob.serverFollowersManager.addFollower("goblinchestminion", (Mob)mob2, FollowPosition.WALK_CLOSE, "summonedmob", 1.0f, 1, null, false);
            mob2.updateDamage(this.getAttackDamage(item));
            mob2.setEnchantment(this.getEnchantment(item));
            attackerMob.getLevel().entityManager.addMob((Mob)mob2, attackerMob.x - 50.0f, attackerMob.y + 50.0f);
            GoblinLegMinion mob3 = new GoblinLegMinion();
            attackerMob.serverFollowersManager.addFollower("goblinlegminion", (Mob)mob3, FollowPosition.WALK_CLOSE, "summonedmob", 1.0f, 1, null, false);
            mob3.updateDamage(this.getAttackDamage(item));
            mob3.setEnchantment(this.getEnchantment(item));
            attackerMob.getLevel().entityManager.addMob((Mob)mob3, attackerMob.x + 50.0f, attackerMob.y + 50.0f);
            attackerMob.buffManager.removeBuff("goblinswordstack", true);
        }
        return item;
    }

    public ItemControllerInteract getControllerInteract(Level level, PlayerMob player, InventoryItem item, boolean beforeObjectInteract, int interactDir, LinkedList<Rectangle> mobInteractBoxes, LinkedList<Rectangle> tileInteractBoxes) {
        Point2D.Float controllerAimDir = player.getControllerAimDir();
        Point levelPos = this.getControllerAttackLevelPos(level, controllerAimDir.x, controllerAimDir.y, player, item);
        return new ItemControllerInteract(levelPos.x, levelPos.y){

            public DrawOptions getDrawOptions(GameCamera camera) {
                return null;
            }

            public void onCurrentlyFocused(GameCamera camera) {
            }
        };
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getPreEnchantmentTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"goblinswordtip"));
        return tooltips;
    }
}

