/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonweapons;

import java.awt.geom.Point2D;
import necesse.engine.localization.Localization;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.registries.DamageTypeRegistry;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameMath;
import necesse.entity.levelEvent.mobAbilityLevelEvent.ToolItemMobAbilityEvent;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.itemAttacker.FollowPosition;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.toolItem.spearToolItem.SpearToolItem;
import necesse.inventory.item.upgradeUtils.IntUpgradeValue;
import necesse.inventory.lootTable.presets.SummonWeaponsLootTable;
import necesse.level.maps.Level;
import summonerexpansion.summonminions.FishianMinion;

public class FishianSpear
extends SpearToolItem {
    public IntUpgradeValue maxFishians = new IntUpgradeValue().setBaseValue(2);

    public FishianSpear() {
        super(800, SummonWeaponsLootTable.summonWeapons);
        this.rarity = Item.Rarity.RARE;
        this.damageType = DamageTypeRegistry.SUMMON;
        this.attackDamage.setBaseValue(30.0f).setUpgradedValue(1.0f, 45.0f);
        this.attackAnimTime.setBaseValue(500);
        this.resilienceGain.setBaseValue(0.0f).setUpgradedValue(1.0f, 0.1f).setUpgradedValue(10.0f, 0.2f);
        this.attackRange.setBaseValue(80);
        this.knockback.setBaseValue(25);
        this.width = 80.0f;
        this.maxFishians.setBaseValue(2).setUpgradedValue(1.0f, 4).setUpgradedValue(5.0f, 6);
        this.canBeUsedForRaids = true;
    }

    public void hitMob(InventoryItem item, ToolItemMobAbilityEvent event, Level level, Mob target, Mob attacker) {
        super.hitMob(item, event, level, target, attacker);
        if (attacker.isServer()) {
            ActiveBuff ab = new ActiveBuff(BuffRegistry.getBuff((String)"fishianstack"), attacker, 30.0f, (Attacker)attacker);
            attacker.addBuff(ab, true);
        }
    }

    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        InventoryItem out = super.onAttack(level, x, y, attackerMob, attackHeight, item, slot, animAttack, seed, mapContent);
        if (animAttack == 0 && attackerMob.isServer() && attackerMob.buffManager.getStacks(BuffRegistry.getBuff((String)"fishianstack")) >= 100) {
            FishianMinion mob = new FishianMinion();
            Point2D.Float dir = GameMath.normalize((float)((float)x - attackerMob.x), (float)((float)y - attackerMob.y + (float)attackHeight));
            attackerMob.serverFollowersManager.addFollower("fishianminion", (Mob)mob, FollowPosition.WALK_CLOSE, "summonedmob", 1.0f, this.maxFishians.getValue(this.getUpgradeTier(item)).intValue(), null, false);
            mob.updateDamage(this.getAttackDamage(item));
            mob.setEnchantment(this.getEnchantment(item));
            mob.dx = dir.x * 300.0f;
            mob.dy = dir.y * 300.0f;
            attackerMob.getLevel().entityManager.addMob((Mob)mob, attackerMob.x + dir.x, attackerMob.y + dir.y);
            attackerMob.buffManager.removeBuff("fishianstack", true);
        }
        return item;
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getPreEnchantmentTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"fishianspeartip"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"minionactivecap", (String)"amount", (Object)this.maxFishians.getValue(this.getUpgradeTier(item))));
        return tooltips;
    }
}

