/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonweapons;

import java.awt.Color;
import necesse.engine.localization.Localization;
import necesse.engine.util.GameBlackboard;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.itemAttacker.FollowPosition;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.gfx.gameTooltips.StringTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.toolItem.summonToolItem.SummonToolItem;
import necesse.inventory.item.upgradeUtils.IntUpgradeValue;
import necesse.inventory.lootTable.presets.SummonWeaponsLootTable;

public class ExplosiveSnowball
extends SummonToolItem {
    public IntUpgradeValue maxSummons = new IntUpgradeValue(3, 0.0f);

    public ExplosiveSnowball() {
        super("explosivesnowmanminion", FollowPosition.PYRAMID, 1.0f, 200, SummonWeaponsLootTable.summonWeapons);
        this.summonType = "explosivesnowmanminion";
        this.rarity = Item.Rarity.COMMON;
        this.drawMaxSummons = false;
        this.canBeUsedForRaids = true;
        this.attackDamage.setBaseValue(20.0f).setUpgradedValue(1.0f, 40.0f);
        this.maxSummons.setBaseValue(3).setUpgradedValue(2.0f, 4).setUpgradedValue(10.0f, 9);
    }

    public int getMaxSummons(InventoryItem item, ItemAttackerMob attackerMob) {
        return this.maxSummons.getValue(this.getUpgradeTier(item));
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getPreEnchantmentTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"explosivesnowballtip"));
        if (perspective == null) {
            return tooltips;
        }
        if (perspective.buffManager.hasBuff("frostcrownsetbonus")) {
            tooltips.add((Object)new StringTooltips(Localization.translate((String)"itemtooltip", (String)"explosivesnowballtip2"), new Color(87, 189, 216)));
        }
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"secondarysummon"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"minionactivecap", (String)"amount", (Object)this.getMaxSummons(item, (ItemAttackerMob)perspective)));
        return tooltips;
    }
}

