/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonweapons;

import java.awt.Color;
import necesse.engine.localization.Localization;
import necesse.engine.util.GameBlackboard;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.itemAttacker.FollowPosition;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.gfx.gameTooltips.StringTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.toolItem.summonToolItem.SummonToolItem;
import necesse.inventory.item.upgradeUtils.IntUpgradeValue;
import necesse.inventory.lootTable.presets.SummonWeaponsLootTable;

public class BookRunic
extends SummonToolItem {
    public IntUpgradeValue maxSummons = new IntUpgradeValue(2, 0.0f);

    public BookRunic() {
        super("runicshieldminion", FollowPosition.FLYING_CIRCLE, 1.0f, 200, SummonWeaponsLootTable.summonWeapons);
        this.summonType = "summonedrunicshield";
        this.rarity = Item.Rarity.COMMON;
        this.drawMaxSummons = false;
        this.canBeUsedForRaids = true;
        this.attackAnimTime.setBaseValue(400);
        this.attackDamage.setBaseValue(30.0f).setUpgradedValue(1.0f, 65.0f);
        this.maxSummons.setBaseValue(2).setUpgradedValue(1.0f, 4).setUpgradedValue(10.0f, 8);
    }

    public int getMaxSummons(InventoryItem item, ItemAttackerMob attackerMob) {
        return this.maxSummons.getValue(this.getUpgradeTier(item));
    }

    public int getItemAttackerStoppingDistance(ItemAttackerMob mob, InventoryItem item, int attackRange) {
        return 128;
    }

    public int getItemAttackerRunAwayDistance(ItemAttackerMob attackerMob, InventoryItem item) {
        return 96;
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getPreEnchantmentTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"bookrunictip"));
        if (perspective == null) {
            return tooltips;
        }
        if (perspective.buffManager.hasBuff("runicsetbonus")) {
            tooltips.add((Object)new StringTooltips(Localization.translate((String)"itemtooltip", (String)"polarheadtip2"), new Color(86, 80, 111)));
        }
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"secondarysummon"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"minionactivecap", (String)"amount", (Object)this.getMaxSummons(item, (ItemAttackerMob)perspective)));
        return tooltips;
    }
}

