/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonweapons;

import necesse.engine.localization.Localization;
import necesse.engine.util.GameBlackboard;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.itemAttacker.FollowPosition;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.toolItem.summonToolItem.SummonToolItem;
import necesse.inventory.item.upgradeUtils.IntUpgradeValue;
import necesse.inventory.lootTable.presets.SummonWeaponsLootTable;

public class BookMushroom
extends SummonToolItem {
    public IntUpgradeValue maxSummons = new IntUpgradeValue(1, 0.0f);

    public BookMushroom() {
        super("mushroomsentry", FollowPosition.WALK_CLOSE, 1.0f, 200, SummonWeaponsLootTable.summonWeapons);
        this.summonType = "summonedmushroom";
        this.rarity = Item.Rarity.COMMON;
        this.drawMaxSummons = false;
        this.canBeUsedForRaids = false;
        this.attackDamage.setBaseValue(20.0f).setUpgradedValue(1.0f, 80.0f);
        this.maxSummons.setBaseValue(1).setUpgradedValue(2.0f, 2).setUpgradedValue(10.0f, 5);
    }

    public int getMaxSummons(InventoryItem item, ItemAttackerMob attackerMob) {
        return this.maxSummons.getValue(this.getUpgradeTier(item));
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getPreEnchantmentTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"bookmushroomtip"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"secondarysummon"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"minionactivecap", (String)"amount", (Object)this.getMaxSummons(item, (ItemAttackerMob)perspective)));
        return tooltips;
    }
}

