/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summonweapons;

import necesse.engine.localization.Localization;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.registries.MobRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.itemAttacker.FollowPosition;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.mobs.summon.summonFollowingMob.attackingFollowingMob.AttackingFollowingJumpingMob;
import necesse.entity.mobs.summon.summonFollowingMob.attackingFollowingMob.ToolItemSummonedMob;
import necesse.gfx.GameResources;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.toolItem.summonToolItem.SummonToolItem;
import necesse.inventory.item.upgradeUtils.IntUpgradeValue;
import necesse.inventory.lootTable.presets.SummonWeaponsLootTable;
import necesse.level.maps.Level;

public class BookMagma
extends SummonToolItem {
    public IntUpgradeValue maxSummons = new IntUpgradeValue(3, 0.0f);

    public BookMagma() {
        super("magmaslimeminion", FollowPosition.SLIME_CIRCLE_MOVEMENT, 1.0f, 200, SummonWeaponsLootTable.summonWeapons);
        this.summonType = "summonedmagmaslime";
        this.rarity = Item.Rarity.COMMON;
        this.drawMaxSummons = false;
        this.canBeUsedForRaids = true;
        this.attackAnimTime.setBaseValue(400);
        this.attackDamage.setBaseValue(22.0f).setUpgradedValue(1.0f, 35.0f);
        this.maxSummons.setBaseValue(3).setUpgradedValue(1.0f, 6).setUpgradedValue(10.0f, 10);
    }

    public int getMaxSummons(InventoryItem item, ItemAttackerMob attackerMob) {
        return this.maxSummons.getValue(this.getUpgradeTier(item));
    }

    public void runServerSummon(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        AttackingFollowingJumpingMob mob1 = (AttackingFollowingJumpingMob)MobRegistry.getMob((String)"magmaslimeminion", (Level)level);
        this.summonServerMob(attackerMob, (ToolItemSummonedMob)mob1, x, y, attackHeight, item);
    }

    public void showAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, int animAttack, int seed, GNDItemMap mapContent) {
        if (level.isClient()) {
            SoundManager.playSound((GameSound)GameResources.magicbolt4, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(0.3f).pitch(GameRandom.globalRandom.getFloatBetween(1.6f, 1.8f)));
        }
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getPreEnchantmentTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"bookmagmatip"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"secondarysummon"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"minionactivecap", (String)"amount", (Object)this.getMaxSummons(item, (ItemAttackerMob)perspective)));
        return tooltips;
    }
}

