/*
 * Decompiled with CFR 0.152.
 */
package summonerexpansion.summontrinketbuffs;

import necesse.engine.localization.Localization;
import necesse.engine.network.Packet;
import necesse.engine.network.packet.PacketLifelineEvent;
import necesse.engine.registries.BuffRegistry;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.MobBeforeDamageOverTimeTakenEvent;
import necesse.entity.mobs.MobBeforeHitCalculatedEvent;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffEventSubscriber;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.armorBuffs.trinketBuffs.TrinketBuff;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.trinketItem.TrinketItem;
import necesse.level.maps.Level;
import necesse.level.maps.regionSystem.RegionPositionGetter;

public class TransplantedHeartBuff
extends TrinketBuff {
    public void init(ActiveBuff buff, BuffEventSubscriber eventSubscriber) {
        buff.setModifier(BuffModifiers.COMBAT_HEALTH_REGEN_FLAT, (Object)Float.valueOf(0.75f));
        buff.setModifier(BuffModifiers.MAX_RESILIENCE, (Object)Float.valueOf(0.1f));
        eventSubscriber.subscribeEvent(MobBeforeDamageOverTimeTakenEvent.class, event -> {
            if (this.runLifeLineLogic(buff, event.getExpectedHealth())) {
                event.prevent();
            }
        });
        this.updateModifiers(buff);
    }

    public void clientTick(ActiveBuff buff) {
        this.updateModifiers(buff);
    }

    public void serverTick(ActiveBuff buff) {
        this.updateModifiers(buff);
    }

    private void updateModifiers(ActiveBuff buff) {
        Mob owner;
        int nextMaxHealth;
        int lastMaxHealth = buff.getGndData().getInt("lastMaxHealth");
        if (lastMaxHealth != (nextMaxHealth = buff.owner.getMaxHealth() + lastMaxHealth / 2)) {
            buff.setModifier(BuffModifiers.MAX_HEALTH_FLAT, (Object)(-nextMaxHealth / 2));
            buff.setModifier(BuffModifiers.MAX_RESILIENCE_FLAT, (Object)(nextMaxHealth / 2));
            buff.getGndData().setInt("lastMaxHealth", nextMaxHealth);
            buff.owner.buffManager.forceUpdateBuffs();
        }
        if ((owner = buff.owner).getHealth() < owner.getMaxHealth()) {
            buff.setModifier(BuffModifiers.RESILIENCE_REGEN_FLAT, (Object)Float.valueOf(0.0f));
        } else {
            buff.setModifier(BuffModifiers.RESILIENCE_REGEN_FLAT, (Object)Float.valueOf(owner.isInCombat() ? 1.0f + owner.getCombatRegen() : 1.0f + owner.getRegen() + owner.getCombatRegen()));
        }
    }

    public void onBeforeHitCalculated(ActiveBuff buff, MobBeforeHitCalculatedEvent event) {
        super.onBeforeHitCalculated(buff, event);
        if (this.runLifeLineLogic(buff, event.getExpectedHealth())) {
            event.prevent();
        }
    }

    protected boolean runLifeLineLogic(ActiveBuff buff, int expectedHealth) {
        Level level = buff.owner.getLevel();
        if (level.isServer() && !buff.owner.buffManager.hasBuff(BuffRegistry.Debuffs.LIFELINE_COOLDOWN.getID()) && expectedHealth <= 0) {
            buff.owner.setHealth(Math.max(10, buff.owner.getMaxHealth() / 4));
            buff.owner.buffManager.addBuff(new ActiveBuff(BuffRegistry.Debuffs.LIFELINE_COOLDOWN, buff.owner, 300.0f, null), true);
            level.getServer().network.sendToClientsWithEntity((Packet)new PacketLifelineEvent(buff.owner.getUniqueID()), (RegionPositionGetter)buff.owner);
            return true;
        }
        return false;
    }

    public ListGameTooltips getTrinketTooltip(TrinketItem trinketItem, InventoryItem item, PlayerMob perspective) {
        ListGameTooltips tooltips = new ListGameTooltips();
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"transplantedhearttip"));
        return tooltips;
    }
}

